/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.impl.j2audio;

import ipsk.audio.AudioController;
import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioControllerListener;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.FileAudioSource;
import ipsk.audio.URLAudioSource;
import ipsk.audio.impl.j2audio.Capture;
import ipsk.audio.impl.j2audio.CaptureListener;
import ipsk.audio.impl.j2audio.CaptureStatus;
import ipsk.audio.impl.j2audio.Playback;
import ipsk.audio.impl.j2audio.PlaybackListener;
import ipsk.audio.ui.AudioControllerUI;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class J2AudioController
implements AudioController,
CaptureListener,
PlaybackListener {
    private static final boolean DEBUG = false;
    private long mode;
    private AudioControllerUI acUi = null;
    private int numLines = 1;
    private int numLineChannels;
    private int numTotalChannels;
    private AudioSource[] audioSources = null;
    private InputStream[] playbackInputStreams;
    private File[] recordingFiles;
    private OutputStream[] recordingOutputStreams;
    private String reqTargetMixerName = null;
    private Mixer.Info reqTargetMixerInfo = null;
    private Mixer reqTargetMixer = null;
    private String reqSourceMixerName = null;
    private Mixer.Info reqSourceMixerInfo = null;
    private Mixer reqSourceMixer = null;
    private Mixer sourceMixer = null;
    private Mixer targetMixer = null;
    private SourceDataLine[] sdl = null;
    private DataLine.Info sdlInfo = null;
    private TargetDataLine[] tdl = null;
    private DataLine.Info tdlInfo = null;
    private AudioController.PlaybackStatus playbackStatus = new AudioController.PlaybackStatus("Closed");
    private AudioController.CaptureStatus captureStatus = new AudioController.CaptureStatus("Closed");
    private Vector<AudioControllerListener> listenerList = new Vector();
    private AudioFormat audioFormat;
    private AudioFormat playbackAudioFormat;
    private float[] levels;
    private Playback[] p = null;
    private Object playbackLock = new Object();
    private Capture[] c = null;
    private boolean overwrite = false;
    private boolean captureDeviceOpen = false;
    private boolean playbackDeviceOpen = false;
    private JFrame uiFrame = null;
    private Properties properties;
    private Logger logger;

    public J2AudioController() {
        String packageName = this.getClass().getPackage().getName();
        this.logger = Logger.getLogger(packageName);
        this.logger.setLevel(Level.INFO);
        this.setAudioFormat(new AudioFormat(44100.0f, 16, 2, true, false));
        this.setNumLines(1);
        this.setMode(2L);
        this.setPlaybackFiles(null);
        this.setRecordingFiles(null);
        this.properties = new Properties();
        this.logger.info("J2AudioController created.");
    }

    private Capture createCapture(TargetDataLine tdl) {
        String lineBufSizeProperty;
        Capture c = null;
        c = new Capture(this, tdl);
        String tmpFileProperty = this.getProperty("RECORD_USE_TMP_FILE");
        if (tmpFileProperty != null) {
            c.setUseTempFile(Boolean.valueOf(tmpFileProperty));
        }
        if ((lineBufSizeProperty = this.getProperty("CAPTURE_PREFERRED_LINE_BUFFER_SIZE")) != null) {
            c.setPreferredBufferSize(Integer.valueOf(lineBufSizeProperty));
        }
        return c;
    }

    private boolean checkMixerTargetLines(Mixer m, int numLines) throws LineUnavailableException {
        Line.Info[] tlinfos = null;
        tlinfos = m.getTargetLineInfo(this.tdlInfo);
        if (tlinfos.length < numLines) {
            return false;
        }
        try {
            for (int i = 0; i < numLines; ++i) {
                this.tdl[i] = (TargetDataLine)m.getLine(tlinfos[i]);
                this.c[i] = this.createCapture(this.tdl[i]);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean checkMixerSourceLines(Mixer m, int numLines) throws LineUnavailableException {
        Line.Info[] slinfos = m.getSourceLineInfo(this.sdlInfo);
        if (slinfos.length < numLines) {
            return false;
        }
        try {
            for (int i = 0; i < numLines; ++i) {
                this.p[i] = new Playback((PlaybackListener)this, m);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void setNumLines(int numLines) {
        this.numLines = numLines;
    }

    @Override
    public void setSourceMixer(Mixer.Info mixerInfo) {
        this.reqSourceMixerInfo = mixerInfo;
        this.reqSourceMixer = null;
        this.reqSourceMixerName = null;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public synchronized void configure() throws AudioControllerException {
        int mixerInd;
        String pStatus = this.playbackStatus.getStatus();
        String cStatus = this.captureStatus.getStatus();
        if (pStatus != "Closed" && pStatus != "Configured") {
            throw new AudioControllerException(new LineUnavailableException("Playback device is busy."));
        }
        if (cStatus != "Closed" && cStatus != "Configured") {
            throw new AudioControllerException(new LineUnavailableException("Capture device is busy."));
        }
        this.numLineChannels = this.audioFormat.getChannels();
        this.numTotalChannels = this.numLines * this.numLineChannels;
        this.levels = new float[this.numTotalChannels];
        this.resetLevels();
        this.sdlInfo = new DataLine.Info(SourceDataLine.class, this.playbackAudioFormat);
        this.tdlInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
        boolean sourceMixerFound = false;
        boolean targetMixerFound = false;
        this.sourceMixer = null;
        this.targetMixer = null;
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        String mixerName = null;
        this.tdl = new TargetDataLine[this.numLines];
        this.c = new Capture[this.numLines];
        boolean mixerNameFound = false;
        if (this.reqTargetMixerInfo != null) {
            this.targetMixer = AudioSystem.getMixer(this.reqTargetMixerInfo);
            try {
                targetMixerFound = this.checkMixerTargetLines(this.targetMixer, this.numLines);
            }
            catch (LineUnavailableException e) {
                throw new AudioControllerException(e);
            }
        }
        if (this.reqTargetMixer != null) {
            this.targetMixer = this.reqTargetMixer;
            try {
                targetMixerFound = this.checkMixerTargetLines(this.targetMixer, this.numLines);
            }
            catch (LineUnavailableException e) {
                throw new AudioControllerException(e);
            }
        }
        if (this.reqTargetMixerName != null) {
            for (mixerInd = 0; mixerInd < mi.length; ++mixerInd) {
                mixerName = mi[mixerInd].getName();
                if (this.reqTargetMixerName != null && !this.reqTargetMixerName.equals(mixerName)) continue;
                mixerNameFound = true;
                this.targetMixer = AudioSystem.getMixer(mi[mixerInd]);
                if (!targetMixerFound) {
                    try {
                        targetMixerFound = this.checkMixerTargetLines(this.targetMixer, this.numLines);
                    }
                    catch (LineUnavailableException e) {
                        throw new AudioControllerException(e);
                    }
                }
                if (!targetMixerFound) continue;
                this.reqTargetMixerInfo = this.targetMixer.getMixerInfo();
                break;
            }
        } else {
            for (mixerInd = 0; mixerInd < mi.length; ++mixerInd) {
                mixerName = mi[mixerInd].getName();
                this.targetMixer = AudioSystem.getMixer(mi[mixerInd]);
                Line.Info[] tlInfos = this.targetMixer.getTargetLineInfo(new DataLine.Info(TargetDataLine.class, null));
                if (tlInfos == null || tlInfos.length <= 0) continue;
                try {
                    targetMixerFound = this.checkMixerTargetLines(this.targetMixer, this.numLines);
                    break;
                }
                catch (LineUnavailableException e) {
                    throw new AudioControllerException(e);
                }
            }
        }
        if (!targetMixerFound) {
            AudioFormatNotSupportedException e;
            this.close();
            this.targetMixer = null;
            if (this.reqTargetMixerName != null) {
                if (!mixerNameFound) {
                    throw new AudioControllerException("Capture device " + this.reqTargetMixerName + " not found !");
                }
                e = new AudioFormatNotSupportedException(false, this.reqTargetMixerName, this.audioFormat);
            } else {
                e = new AudioFormatNotSupportedException(false, this.audioFormat);
            }
            throw new AudioControllerException(e);
        }
        this.captureStatus.setStatus("Configured");
        this.updateListeners(null, this.captureStatus);
        this.sdl = new SourceDataLine[this.numLines];
        this.p = new Playback[this.numLines];
        if (this.reqSourceMixerInfo != null) {
            this.sourceMixer = AudioSystem.getMixer(this.reqSourceMixerInfo);
            try {
                sourceMixerFound = this.checkMixerSourceLines(this.sourceMixer, this.numLines);
            }
            catch (LineUnavailableException e) {
                throw new AudioControllerException(e);
            }
        }
        if (this.reqSourceMixer != null) {
            this.sourceMixer = this.reqSourceMixer;
            try {
                sourceMixerFound = this.checkMixerSourceLines(this.sourceMixer, this.numLines);
            }
            catch (LineUnavailableException e) {
                throw new AudioControllerException(e);
            }
        }
        if (this.reqSourceMixerName != null) {
            mixerNameFound = false;
            for (mixerInd = 0; mixerInd < mi.length; ++mixerInd) {
                mixerName = mi[mixerInd].getName();
                if (this.reqSourceMixerName != null && !this.reqSourceMixerName.equals(mixerName)) continue;
                mixerNameFound = true;
                this.sourceMixer = AudioSystem.getMixer(mi[mixerInd]);
                try {
                    sourceMixerFound = this.checkMixerSourceLines(this.sourceMixer, this.numLines);
                }
                catch (LineUnavailableException e) {
                    throw new AudioControllerException(e);
                }
                if (!sourceMixerFound) continue;
                this.reqSourceMixerInfo = this.sourceMixer.getMixerInfo();
                break;
            }
        } else {
            for (mixerInd = 0; mixerInd < mi.length; ++mixerInd) {
                mixerName = mi[mixerInd].getName();
                this.sourceMixer = AudioSystem.getMixer(mi[mixerInd]);
                Line.Info[] slInfos = this.sourceMixer.getSourceLineInfo(new DataLine.Info(SourceDataLine.class, null));
                if (slInfos == null || slInfos.length <= 0) continue;
                try {
                    sourceMixerFound = this.checkMixerSourceLines(this.sourceMixer, this.numLines);
                    break;
                }
                catch (LineUnavailableException e) {
                    throw new AudioControllerException(e);
                }
            }
        }
        if (!sourceMixerFound) {
            AudioFormatNotSupportedException e;
            this.close();
            this.sourceMixer = null;
            if (this.reqSourceMixerName != null) {
                if (!mixerNameFound) {
                    throw new AudioControllerException("Playback device " + this.reqSourceMixerName + " not found !");
                }
                e = new AudioFormatNotSupportedException(false, this.reqSourceMixerName, this.playbackAudioFormat);
            } else {
                e = new AudioFormatNotSupportedException(false, this.playbackAudioFormat);
            }
            throw new AudioControllerException(e);
        }
        Class<?> sourceMixerClass = this.sourceMixer.getClass();
        this.playbackStatus.setStatus("Configured");
        this.updateListeners(this.playbackStatus, null);
        this.logger.info("J2AudioController configured.");
    }

    @Override
    public void open() throws AudioControllerException {
        try {
            if (this.captureStatus.getStatus() != "Configured") {
                new LineUnavailableException("Controller not configured.");
            }
            if (this.mode == 1L) {
                this.openCapture();
                this.openPlayback();
            }
        }
        catch (IOException e) {
            throw new AudioControllerException(e);
        }
        catch (LineUnavailableException e) {
            throw new AudioControllerException(e);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new AudioControllerException(e);
        }
        this.captureStatus.setStatus("Opened");
        this.updateListeners(null, this.captureStatus);
        this.playbackStatus.setStatus("Open");
        this.updateListeners(this.playbackStatus, null);
    }

    void openCapture() throws IOException, LineUnavailableException, AudioFormatNotSupportedException {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.c[i] == null) {
                this.checkMixerTargetLines(this.targetMixer, this.numLines);
            }
            this.c[i].open(this.audioFormat);
            this.log("Capture open");
        }
        this.captureDeviceOpen = true;
    }

    void openPlayback() throws AudioFormatNotSupportedException, LineUnavailableException {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.p[i] == null) {
                this.checkMixerSourceLines(this.sourceMixer, this.numLines);
            }
            this.sdl[i] = this.p[i].open(this.playbackAudioFormat);
            this.log("Playback open");
        }
        this.playbackDeviceOpen = true;
    }

    private void resetLevels() {
        for (int j = 0; j < this.numTotalChannels; ++j) {
            this.levels[j] = 0.0f;
        }
    }

    @Override
    public void prepareRecording() throws AudioControllerException {
        try {
            if (this.recordingOutputStreams != null) {
                this.prepareRecording(false);
            } else if (!this.prepareRecording(false)) {
                String msg = new String();
                for (int i = 0; i < this.numLines; ++i) {
                    File recordingFile = this.recordingFiles[i];
                    if (!recordingFile.exists()) continue;
                    msg = msg.concat("'" + recordingFile.getCanonicalPath() + "' already exists !");
                }
                throw new IOException(msg + "\nSet overwrite option to overwrite automatically.");
            }
        }
        catch (IOException e) {
            throw new AudioControllerException(e);
        }
    }

    public boolean prepareRecording(boolean forceOverwrite) throws AudioControllerException {
        if (!this.captureDeviceOpen) {
            try {
                this.openCapture();
            }
            catch (Exception e) {
                throw new AudioControllerException(e);
            }
        }
        if (this.targetMixer != null && this.targetMixer.isSynchronizationSupported(this.tdl, true)) {
            this.targetMixer.synchronize(this.tdl, true);
        }
        if (this.recordingOutputStreams != null) {
            for (int i = 0; i < this.numLines; ++i) {
                try {
                    this.c[i].prepareToRecord(this.recordingOutputStreams[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new AudioControllerException(e);
                }
            }
        } else {
            int i;
            if (this.recordingFiles == null) {
                throw new AudioControllerException("Files have not been set.");
            }
            if (!forceOverwrite) {
                for (i = 0; i < this.numLines; ++i) {
                    File recordingFile = this.recordingFiles[i];
                    if (this.overwrite || !recordingFile.exists()) continue;
                    return false;
                }
            }
            for (i = 0; i < this.numLines; ++i) {
                try {
                    this.c[i].prepareToRecord(this.recordingFiles[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new AudioControllerException(e);
                }
            }
        }
        this.captureStatus.setStatus("Prepared");
        this.updateListeners(null, this.captureStatus);
        return true;
    }

    @Override
    public void startRecording() {
        for (int i = 0; i < this.numLines; ++i) {
            this.c[i].startRecording();
        }
        this.captureStatus.setStatus("Recording");
        this.updateListeners(null, this.captureStatus);
    }

    @Override
    public void stopRecording() throws AudioControllerException {
        IOException captureException = null;
        for (int i = 0; i < this.numLines; ++i) {
            try {
                this.c[i].stopRecording();
                continue;
            }
            catch (IOException e) {
                if (captureException != null) continue;
                captureException = e;
            }
        }
        if (this.targetMixer != null && this.targetMixer.isSynchronizationSupported(this.tdl, true)) {
            this.targetMixer.unsynchronize(this.tdl);
        }
        this.captureStatus.setStatus("Recorded");
        this.updateListeners(null, this.captureStatus);
        if (this.mode == 2L) {
            this.closeCapture();
        }
        this.captureStatus.setStatus("Saved");
        this.updateListeners(null, this.captureStatus);
        if (captureException != null) {
            throw new AudioControllerException(captureException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void played(Playback pb) {
        boolean played = true;
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.p[i].isPlaying()) continue;
            played = false;
        }
        if (played) {
            if (this.sourceMixer != null && this.sourceMixer.isSynchronizationSupported(this.sdl, true)) {
                this.sourceMixer.unsynchronize(this.sdl);
            }
            Object object = this.playbackLock;
            synchronized (object) {
                this.playbackLock.notifyAll();
            }
            this.playbackStatus.setStatus("Played");
            this.updateListeners(this.playbackStatus, null);
            if (this.mode == 2L) {
                this.closePlayback();
            }
        }
    }

    @Override
    public void preparePlayback() throws AudioControllerException {
        AudioFormat fallBackPlaybackAudioFormat = this.playbackAudioFormat;
        AudioFormat paf = null;
        try {
            if (this.playbackInputStreams != null) {
                paf = AudioSystem.getAudioFileFormat(this.playbackInputStreams[0]).getFormat();
            } else {
                if (this.audioSources == null) {
                    throw new AudioControllerException("files have not been set.");
                }
                paf = this.audioSources[0].getAudioInputStream().getFormat();
            }
            if (!paf.matches(this.playbackAudioFormat)) {
                this.playbackAudioFormat = paf;
                this.close();
                this.configure();
                this.open();
            }
            if (!this.playbackDeviceOpen) {
                this.openPlayback();
            }
            for (int i = 0; i < this.numLines; ++i) {
                if (this.playbackInputStreams != null) {
                    this.p[i].prepareToPlay(this.playbackInputStreams[i]);
                    continue;
                }
                this.p[i].prepareToPlay(this.audioSources[i]);
            }
            if (this.sourceMixer != null && this.sourceMixer.isSynchronizationSupported(this.sdl, true)) {
                this.sourceMixer.synchronize(this.sdl, true);
            }
        }
        catch (Exception e) {
            this.playbackAudioFormat = fallBackPlaybackAudioFormat;
            throw new AudioControllerException(e);
        }
        this.playbackStatus.setStatus("Prepared");
        this.updateListeners(this.playbackStatus, null);
    }

    @Override
    public float[] getLevels() {
        if (this.captureStatus.getStatus() == "Recording" || this.captureStatus.getStatus() == "Capturing") {
            for (int i = 0; i < this.numLines; ++i) {
                float[] lineLevels = this.c[i].getLevels();
                for (int k = 0; k < lineLevels.length; ++k) {
                    int ik = i * this.numLineChannels + k;
                    this.levels[ik] = lineLevels[k];
                }
            }
            return this.levels;
        }
        if (this.playbackStatus.getStatus() == "Playing") {
            for (int i = 0; i < this.numLines; ++i) {
                if (this.p[i] == null) {
                    return null;
                }
                float[] lineLevels = this.p[i].getLevels();
                if (lineLevels == null) {
                    return null;
                }
                for (int k = 0; k < lineLevels.length; ++k) {
                    int ik = i * this.numLineChannels + k;
                    this.levels[ik] = lineLevels[k];
                }
            }
            return this.levels;
        }
        return null;
    }

    @Override
    public void close() {
        this.closePlayback();
        if (this.sourceMixer != null) {
            this.sourceMixer.close();
        }
        this.closeCapture();
        if (this.targetMixer != null) {
            this.targetMixer.close();
        }
        this.playbackStatus.setStatus("Closed");
        this.captureStatus.setStatus("Closed");
        this.updateListeners(this.playbackStatus, this.captureStatus);
        this.logger.info("J2AudioController closed.");
    }

    protected void closePlayback() {
        if (this.p != null) {
            for (int i = 0; i < this.numLines; ++i) {
                if (this.p[i] == null) continue;
                this.p[i].close();
            }
        }
        this.playbackDeviceOpen = false;
    }

    protected void closeCapture() {
        if (this.c != null) {
            for (int i = 0; i < this.numLines; ++i) {
                if (this.c[i] == null) continue;
                this.c[i].close();
            }
        }
        this.captureDeviceOpen = false;
    }

    @Override
    public synchronized void addAudioControllerListener(AudioControllerListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    @Override
    public synchronized void removeAudioControllerListener(AudioControllerListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void updateListeners(AudioController.PlaybackStatus pe, AudioController.CaptureStatus ce) {
        for (AudioControllerListener listener : this.listenerList) {
            listener.update(pe, ce);
        }
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    private void log(String msg) {
    }

    @Override
    public synchronized void startPlayback() throws AudioControllerException {
        boolean started = false;
        for (int i = 0; i < this.numLines; ++i) {
            started |= this.p[i].startPlayback();
        }
        if (started) {
            this.playbackStatus.setStatus("Playing");
        } else {
            this.playbackStatus.setStatus("Played");
        }
        this.updateListeners(this.playbackStatus, null);
    }

    public void play() throws AudioControllerException {
        this.startPlayback();
        this.playbackStatus.waitForNot("Playing");
    }

    @Override
    public void pausePlayback() {
        boolean paused = true;
        for (int i = 0; i < this.numLines; ++i) {
            paused &= this.p[i].pausePlayback();
        }
        if (paused) {
            this.playbackStatus.setStatus("Pause");
            this.updateListeners(this.playbackStatus, null);
        }
    }

    @Override
    public void stopPlayback() {
        if (this.p == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (this.p[i] == null) continue;
            this.p[i].stopPlayback();
        }
    }

    @Override
    public void startCapture() {
        for (int i = 0; i < this.numLines; ++i) {
            this.c[i].startCapturing();
        }
        this.captureStatus.setStatus("Capturing");
        this.updateListeners(null, this.captureStatus);
    }

    @Override
    public void stopCapture() {
        for (int i = 0; i < this.numLines; ++i) {
            this.c[i].stopCapturing();
        }
        this.captureStatus.setStatus("Opened");
        this.updateListeners(null, this.captureStatus);
        if (this.mode == 2L) {
            this.closeCapture();
        }
    }

    public synchronized void stop() throws IOException {
        this.stopCapture();
        this.stopPlayback();
    }

    public void startDuplex() throws AudioControllerException {
        throw new AudioControllerException("Duplex mode not implemented yet ! Sorry!");
    }

    @Override
    public long getPlaybackFrameLength() {
        long l = 0L;
        for (int i = 0; i < this.numLines; ++i) {
            if (this.p[0] == null || l >= this.p[i].getFrameLength()) continue;
            l = this.p[i].getFrameLength();
        }
        return l;
    }

    @Override
    public long getPlaybackFramePosition() {
        if (this.p == null) {
            return -1L;
        }
        if (this.p[0] == null) {
            return -1L;
        }
        return this.p[0].getFramePosition();
    }

    @Override
    public synchronized long getRecordingFramePosition() {
        if (this.c == null || this.c[0] == null) {
            return 0L;
        }
        return this.c[0].getFramePosition();
    }

    @Override
    public long setPlaybackFramePosition(long newPosition) {
        if (this.p != null) {
            for (int i = 0; i < this.numLines; ++i) {
                try {
                    if (this.p[i] == null) {
                        return -1L;
                    }
                    this.p[i].setFramePosition(newPosition);
                    continue;
                }
                catch (IOException e) {
                    return -1L;
                }
            }
            long resultPosition = this.p[0].getFramePosition();
            for (int i = 1; i < this.numLines; ++i) {
                if (this.p[i].getFramePosition() == resultPosition) continue;
                return -1L;
            }
            return resultPosition;
        }
        return -1L;
    }

    @Override
    public void setSettings() {
        if (this.uiFrame == null) {
            if (this.acUi == null) {
                this.acUi = new AudioControllerUI(this);
            }
            this.uiFrame = new JFrame(this.acUi.getTitle());
            this.uiFrame.setDefaultCloseOperation(1);
            this.uiFrame.getContentPane().add((Component)this.acUi, "Center");
            this.uiFrame.setLocationRelativeTo(null);
        } else {
            this.acUi.update();
            int newState = this.uiFrame.getExtendedState() & 0xFFFFFFFE;
            this.uiFrame.setExtendedState(newState);
        }
        Runnable packAndShow = new Runnable(){

            @Override
            public void run() {
                J2AudioController.this.uiFrame.pack();
                J2AudioController.this.uiFrame.toFront();
                J2AudioController.this.uiFrame.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(packAndShow);
    }

    @Override
    public synchronized AudioController.CaptureStatus getCaptureStatus() {
        return this.captureStatus;
    }

    @Override
    public synchronized AudioController.PlaybackStatus getPlaybackStatus() {
        return this.playbackStatus;
    }

    @Override
    public File[] getPlaybackFiles() {
        if (this.audioSources == null) {
            return null;
        }
        File[] files = new File[this.audioSources.length];
        for (int i = 0; i < this.audioSources.length; ++i) {
            if (!(this.audioSources[i] instanceof FileAudioSource)) {
                return null;
            }
            files[i] = ((FileAudioSource)this.audioSources[i]).getFile();
        }
        return files;
    }

    @Override
    public File[] getRecordingFiles() {
        return this.recordingFiles;
    }

    private void newPlaybackFilesSet() {
        this.setPlaybackStartFramePosition(0L);
        this.setPlaybackStopFramePosition(-1L);
        this.updateListeners(new AudioController.PlaybackStatus("Files set"), null);
    }

    @Override
    public void setPlaybackFiles(File[] files) {
        this.playbackInputStreams = null;
        if (files == null) {
            this.audioSources = null;
            return;
        }
        this.audioSources = new AudioSource[files.length];
        for (int i = 0; i < this.audioSources.length; ++i) {
            this.audioSources[i] = new FileAudioSource(files[i]);
        }
        this.newPlaybackFilesSet();
    }

    @Override
    public void setPlaybackURLs(URL[] urls) {
        this.playbackInputStreams = null;
        if (urls == null) {
            this.audioSources = null;
            return;
        }
        this.audioSources = new AudioSource[urls.length];
        for (int i = 0; i < this.audioSources.length; ++i) {
            this.audioSources[i] = new URLAudioSource(urls[i]);
        }
        this.newPlaybackFilesSet();
    }

    @Override
    public void setPlaybackAudioSources(AudioSource[] audioSources) {
        this.playbackInputStreams = null;
        this.audioSources = audioSources;
        this.newPlaybackFilesSet();
    }

    public AudioSource[] getPlaybackAudioSources() {
        return this.audioSources;
    }

    @Override
    public void setPlaybackInputStreams(InputStream[] inputStreams) {
        this.playbackInputStreams = inputStreams;
        this.audioSources = null;
        this.setPlaybackFramePosition(0L);
        this.setPlaybackStartFramePosition(0L);
        this.setPlaybackStopFramePosition(-1L);
        this.updateListeners(new AudioController.PlaybackStatus("Files set"), null);
    }

    @Override
    public void setRecordingFiles(File[] files) {
        this.recordingOutputStreams = null;
        this.recordingFiles = files;
        this.updateListeners(null, new AudioController.CaptureStatus("Files set"));
    }

    @Override
    public void setRecordingOutputStreams(OutputStream[] streams) {
        this.recordingFiles = null;
        this.recordingOutputStreams = streams;
    }

    public OutputStream[] getRecordingOutputStreams() {
        return this.recordingOutputStreams;
    }

    @Override
    public synchronized void setAudioFormat(AudioFormat format) {
        this.audioFormat = format;
        this.playbackAudioFormat = format;
    }

    @Override
    public boolean isPlaybackRandomPositioningSupported() {
        return true;
    }

    public void setSourceMixer(Mixer mixer) {
        this.reqSourceMixer = mixer;
        this.reqSourceMixerInfo = null;
        this.reqSourceMixerName = null;
    }

    public void setTargetMixer(Mixer mixer) {
        this.reqTargetMixer = mixer;
        this.reqTargetMixerInfo = null;
        this.reqTargetMixerName = null;
    }

    @Override
    public void setTargetMixerName(String targetMixerName) {
        this.reqTargetMixerName = targetMixerName;
        this.reqTargetMixerInfo = null;
        this.reqTargetMixer = null;
    }

    @Override
    public long getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        J2AudioController ac = new J2AudioController();
        OptionParser op = new OptionParser();
        op.addOption("p");
        op.addOption("r");
        op.addOption("f", "");
        op.addOption("i");
        op.addOption("d");
        try {
            op.parse(args);
        }
        catch (OptionParserException e1) {
            System.err.println(e1.getLocalizedMessage());
        }
        String[] params = op.getParams();
        int numLines = 1;
        File[] recFiles = null;
        if (op.isOptionSet("f")) {
            Option fileOption = op.getOption("f");
            String fileName = fileOption.getParam();
            File[] files = new File[]{new File(fileName)};
            ac.setRecordingFiles(files);
            ac.setPlaybackFiles(files);
        }
        boolean interactive = op.isOptionSet("i");
        if (params.length == 1) {
            numLines = 1;
            recFiles = new File[numLines];
            recFiles[0] = new File(params[0]);
            ac.setRecordingFiles(recFiles);
            ac.setPlaybackFiles(recFiles);
        }
        try {
            if (op.isOptionSet("d")) {
                ac.setMode(1L);
            } else {
                ac.setMode(2L);
            }
            ac.configure();
        }
        catch (Exception e) {
            ac.close();
            System.err.println("Error opening device: " + e.getMessage());
        }
        LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));
        if (op.isOptionSet("r")) {
            try {
                ac.prepareRecording();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            finally {
                ac.close();
            }
            if (interactive) {
                System.out.println("Press Return to record");
                try {
                    r.readLine();
                }
                catch (Exception e) {
                    System.err.println("Cannot read: " + e);
                }
            }
            ac.startRecording();
            if (interactive) {
                System.out.println("Recording ...");
                System.out.println("Press Return to stop.");
                try {
                    r.readLine();
                }
                catch (Exception e) {
                    System.err.println("Cannot read: " + e);
                }
            }
            try {
                ac.stopRecording();
            }
            catch (AudioControllerException e) {
                System.err.println("AudioController Problems: " + e);
            }
        }
        if (op.isOptionSet("p")) {
            if (interactive) {
                System.out.println("Press Return to play.");
                try {
                    r.readLine();
                }
                catch (Exception e) {
                    System.err.println("Cannot read: " + e);
                }
            }
            try {
                ac.preparePlayback();
                ac.play();
                if (interactive) {
                    System.out.println("Playback started.");
                }
            }
            catch (Exception e) {
                System.err.println("Cannot prepare: " + e);
            }
        }
        ac.close();
        if (interactive) {
            System.out.println("Exiting.");
        }
        System.exit(0);
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public long setPlaybackStartFramePosition(long startPosition) {
        if (this.p == null) {
            return 0L;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (this.p[i] == null) {
                return 0L;
            }
            this.p[i].setStartFramePosition(startPosition);
        }
        return this.p[0].getStartFramePosition();
    }

    @Override
    public long getPlaybackStartFramePosition() {
        return this.p[0].getStartFramePosition();
    }

    @Override
    public long setPlaybackStopFramePosition(long stopPosition) {
        if (this.p == null) {
            return -1L;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (this.p[i] == null) {
                return -1L;
            }
            this.p[i].setStopFramePosition(stopPosition);
        }
        return this.p[0].getStopFramePosition();
    }

    @Override
    public long getPlaybackStopFramePosition() {
        return this.p[0].getStopFramePosition();
    }

    @Override
    public void update(Playback p, Playback.PlayerStatus ps) {
        if (ps.getStatus() == "Playing") {
            this.playbackStatus.setStatus("Playing");
            this.updateListeners(this.playbackStatus, null);
        }
        if (ps.getStatus() == "Idle") {
            this.played(p);
        }
    }

    @Override
    public int getNumLines() {
        return this.numLines;
    }

    @Override
    public Mixer.Info getSourceMixerInfo() {
        if (this.sourceMixer == null) {
            return null;
        }
        return this.sourceMixer.getMixerInfo();
    }

    @Override
    public void setTargetMixer(Mixer.Info mixerInfo) {
        this.reqTargetMixerInfo = mixerInfo;
        this.reqTargetMixerName = null;
        this.reqTargetMixer = null;
    }

    @Override
    public Mixer.Info getTargetMixerInfo() {
        if (this.targetMixer == null) {
            return null;
        }
        return this.targetMixer.getMixerInfo();
    }

    @Override
    public void setMode(long modeBits) {
        this.mode = modeBits;
    }

    @Override
    public void update(Capture src, CaptureStatus cs) {
        if (cs.getStatus() == "Error") {
            this.captureStatus.setException(cs.getException());
            this.captureStatus.setStatus("Error");
            this.updateListeners(null, this.captureStatus);
        }
    }

    @Override
    public AudioFormat getPlaybackAudioFormat() {
        return this.playbackAudioFormat;
    }

    @Override
    public String[] getPropertyNames() {
        Enumeration<?> e = this.properties.propertyNames();
        Vector names = new Vector();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        return names.toArray(new String[0]);
    }

    @Override
    public String getPropertyDescription(String propertyName) {
        if (propertyName.equals("CAPTURE_USE_TEMP_FILE")) {
            return "If set the capture engine writes raw data to a temporary file.";
        }
        if (propertyName.equals("CAPTURE_PREFERRED_LINE_BUFFER_SIZE")) {
            return "Try to set the size of the capture buffer.\nSet this if you experience buffer overruns (dropouts) on recording.\n128 kBytes for example is a save value on 500 Mhz hosts";
        }
        return null;
    }

    @Override
    public void setProperty(String arg0, String arg1) {
        this.properties.setProperty(arg0, arg1);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    @Override
    public void setSourceMixerName(String string) {
        this.reqSourceMixerName = string;
        this.reqSourceMixerInfo = null;
        this.reqSourceMixer = null;
    }
}

