/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tests;

import ips.dsp.FIRFilter;
import ips.dsp.FIRFilterBuilder;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.FloatToPCMInputStream;
import ipsk.io.FloatStream;
import ipsk.io.InterleavedFloatStream;
import ipsk.io.InterleavedFloatStreamMonoAdapter;
import ipsk.math.Complex;
import ipsk.math.random.GaussianDistributionRandomGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class FIRFilterTest {
    private GaussianDistributionRandomGenerator whiteNoise;
    private double[] TEST_COEFF = new double[]{-0.0, 4.0E-4, 0.0, -5.0E-4, -0.0, 6.0E-4, -0.0, -7.0E-4, 0.0, 8.0E-4, 0.0, -0.001, -0.0, 0.0012, -0.0, -0.0015, -0.0, 0.0019, 0.0, -0.0022, -0.0, 0.0027, -0.0, -0.0032, -0.0, 0.0038, 0.0, -0.0045, -0.0, 0.0053, -0.0, -0.0062, -0.0, 0.0072, 0.0, -0.0084, -0.0, 0.0098, -0.0, -0.0114, -0.0, 0.0132, -0.0, -0.0155, -0.0, 0.0184, -0.0, -0.022, -0.0, 0.0268, -0.0, -0.0336, -0.0, 0.0441, -0.0, -0.0627, -0.0, 0.1055, -0.0, -0.3182, 0.5002, -0.3182, -0.0, 0.1055, -0.0, -0.0627, -0.0, 0.0441, -0.0, -0.0336, -0.0, 0.0268, -0.0, -0.022, -0.0, 0.0184, -0.0, -0.0155, -0.0, 0.0132, -0.0, -0.0114, -0.0, 0.0098, -0.0, -0.0084, 0.0, 0.0072, -0.0, -0.0062, -0.0, 0.0053, -0.0, -0.0045, 0.0, 0.0038, -0.0, -0.0032, -0.0, 0.0027, -0.0, -0.0022, 0.0, 0.0019, -0.0, -0.0015, -0.0, 0.0012, -0.0, -0.001, 0.0, 8.0E-4, 0.0, -7.0E-4, -0.0, 6.0E-4, -0.0, -5.0E-4, 0.0, 4.0E-4, -0.0};

    public FIRFilterTest() {
        double[] coeff;
        int i;
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
        long frameLength = 1000000L;
        this.whiteNoise = new GaussianDistributionRandomGenerator(0.0, 0.1, frameLength);
        Complex[] impulseResponse = new Complex[300];
        for (i = 0; i < 100; ++i) {
            impulseResponse[i] = new Complex(0.0, 0.0);
        }
        while (i < 200) {
            impulseResponse[i] = new Complex(1.0, 0.0);
            ++i;
        }
        while (i < 300) {
            impulseResponse[i] = new Complex(0.0, 0.0);
            ++i;
        }
        for (double d : coeff = FIRFilterBuilder.buildCoefficientsFromImpulsResponse((Complex[])impulseResponse)) {
            System.out.println(d);
        }
        FIRFilter fir = new FIRFilter((FloatStream)this.whiteNoise, coeff);
        InterleavedFloatStreamMonoAdapter ia = new InterleavedFloatStreamMonoAdapter((FloatStream)fir);
        try {
            FloatToPCMInputStream fToPCM = new FloatToPCMInputStream((InterleavedFloatStream)ia, audioFormat);
            AudioInputStream ais = new AudioInputStream((InputStream)((Object)fToPCM), audioFormat, frameLength);
            AudioSystem.write(ais, AudioFileFormat.Type.WAVE, new File("test.wav"));
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new FIRFilterTest();
    }
}

