/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.audio.arr.clip.ui;

import ips.dsp.AutoCorrelator;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.dsp.FloatRandomAccessStream;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class PitchAudioClipUI
extends BasicAudioClipUI {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private double startCorrTime = 0.004;
    private double endCorrTime = 0.012;
    private double corrLenTime = 0.1;
    private double SILENCE_THRESHOLD = 0.3333333333333333;

    @Override
    public String getName() {
        return "Pitch energy";
    }

    public PitchAudioClipUI(AudioClip annotatedAudioClip) throws AudioFormatNotSupportedException, AudioSourceException {
        super(annotatedAudioClip);
    }

    public PitchAudioClipUI() {
    }

    public void setAudioClip(AudioClip annotatedAudioClip) {
        super.setAudioSample(annotatedAudioClip);
    }

    @Override
    public Dimension getPreferredSize() {
        int prefHeight = 100;
        return new Dimension(0, prefHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getSize().width;
        int h = this.getSize().height;
        Stroke defStroke = g2.getStroke();
        BasicStroke bStroke = new BasicStroke(3.0f);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.BLUE);
        AudioSource audioSource = this.getAudioSample().getAudioSource();
        if (audioSource != null) {
            double[] energyDensities = new double[w];
            double maxenergyDensity = 0.0;
            try {
                float sampleRate = audioSource.getFormat().getSampleRate();
                FloatRandomAccessStream fras = new FloatRandomAccessStream(audioSource);
                int chs = fras.getChannels();
                long corrLenFrames = (long)(this.corrLenTime * (double)sampleRate);
                long corrStartFrames = (long)(this.startCorrTime * (double)sampleRate);
                long corrEndFrames = (long)(this.endCorrTime * (double)sampleRate);
                long corrInterval = corrEndFrames - corrStartFrames;
                long bufLen = corrLenFrames + corrEndFrames;
                int paintOffset = (int)(bufLen / 2L);
                double[][] buf = new double[(int)bufLen][chs];
                double[] corrBuf = new double[(int)bufLen];
                long frameLength = audioSource.getFrameLength();
                int segCnt = (int)(frameLength / corrLenFrames);
                double maxEnergy = 0.0;
                double maxCorrEnergy = 0.0;
                double maxCorr = 0.0;
                AutoCorrelator.AutoCorrelationResult[] ress = new AutoCorrelator.AutoCorrelationResult[segCnt];
                for (int s = 0; s < segCnt; ++s) {
                    double corr;
                    double ce;
                    AutoCorrelator.AutoCorrelationResult res;
                    long framePos = (long)s * corrLenFrames;
                    fras.setFramePosition(framePos);
                    fras.readFrames(buf, 0, (int)bufLen);
                    int i = 0;
                    while ((long)i < bufLen) {
                        corrBuf[i] = buf[i][0];
                        ++i;
                    }
                    ress[s] = res = AutoCorrelator.autoCorrelate((double[])corrBuf, (int)0, (int)((int)corrLenFrames), (int)((int)corrStartFrames), (int)((int)corrEndFrames));
                    double e = res.getEnergy();
                    if (e > maxEnergy) {
                        maxEnergy = e;
                    }
                    if ((ce = res.getCorrEnergyMax()) > maxCorrEnergy) {
                        maxCorrEnergy = ce;
                    }
                    if (!((corr = res.correlation()) > maxCorr)) continue;
                    maxCorr = corr;
                }
                g.setColor(Color.DARK_GRAY);
                int l1 = h / 3;
                int l2 = h * 2 / 3;
                g.drawLine(0, l1, w, l1);
                g.drawLine(0, l2, w, l2);
                g.setColor(Color.BLUE);
                for (int i = 0; i < segCnt - 1; ++i) {
                    int y2;
                    int y1;
                    AutoCorrelator.AutoCorrelationResult res1 = ress[i];
                    AutoCorrelator.AutoCorrelationResult res2 = ress[i + 1];
                    long framePos1 = (long)paintOffset + (long)i * corrLenFrames;
                    int x1 = this.mapFrameToPixel(framePos1);
                    long framePos2 = (long)paintOffset + (long)(i + 1) * corrLenFrames;
                    int x2 = this.mapFrameToPixel(framePos2);
                    double c1 = res1.correlation();
                    double c2 = res2.correlation();
                    if (c1 > this.SILENCE_THRESHOLD || c2 > this.SILENCE_THRESHOLD) {
                        g2.setStroke(bStroke);
                        g.setColor(Color.BLUE);
                        y1 = (int)((double)h * (double)res1.getPositionMax() / (double)corrInterval);
                        y2 = (int)((double)h * (double)res2.getPositionMax() / (double)corrInterval);
                        g.drawLine(x1, h - y1, x2, h - y2);
                        g2.setColor(Color.RED);
                    } else {
                        g2.setColor(Color.GREEN);
                        g2.setStroke(defStroke);
                    }
                    y1 = (int)((double)h * res1.correlation() / maxCorr);
                    y2 = (int)((double)h * res2.correlation() / maxCorr);
                    g.drawLine(x1, h - y1, x2, h - y2);
                    g.setColor(Color.ORANGE);
                    y1 = (int)((double)h * res1.getEnergy() / maxEnergy);
                    y2 = (int)((double)h * res2.getEnergy() / maxEnergy);
                    g.drawLine(x1, h - y1, x2, h - y2);
                }
                g.setColor(Color.BLACK);
                g2.setStroke(defStroke);
                g.drawString("Corr: " + Double.toString(maxCorr), 5, 20);
                g.drawString("Ener: " + Double.toString(maxEnergy), 5, 40);
            }
            catch (AudioSourceException e) {
                e.printStackTrace();
            }
            catch (AudioFormatNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isPreferredFixedHeight() {
        return false;
    }
}

