/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.BasicAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;

public class VectorBufferAudioSource
extends BasicAudioSource
implements AudioSource {
    private VectorBuffer vectorBuffer;

    public VectorBufferAudioSource(VectorBuffer vectorBuffer) {
        this.vectorBuffer = vectorBuffer;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        AudioInputStream ais = null;
        try {
            VectorBufferedInputStream vbis = new VectorBufferedInputStream(this.vectorBuffer);
            ais = ThreadSafeAudioSystem.getAudioInputStream((InputStream)vbis);
        }
        catch (Exception e) {
            throw new AudioSourceException(e);
        }
        return ais;
    }

    public VectorBuffer getVectorBuffer() {
        return this.vectorBuffer;
    }

    public void setVectorBuffer(VectorBuffer buffer) {
        this.vectorBuffer = buffer;
    }
}

