/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.BooleanControlUI;
import ipsk.audio.mixer.ui.CompoundControlUI;
import ipsk.audio.mixer.ui.ControlUI;
import ipsk.audio.mixer.ui.EnumControlUI;
import ipsk.audio.mixer.ui.FloatControlUI;
import ipsk.swing.TitledPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Port;
import javax.swing.JLabel;

public class LineControlsUI
extends TitledPanel {
    private static final boolean DEBUG = false;
    private Line.Info info;
    private Control[] memberControls;
    private ControlUI[] controlUIs;
    private Font smallFont;

    public LineControlsUI(Line l) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.anchor = 11;
        this.smallFont = this.getFont().deriveFont(10.0f);
        this.setFont(this.smallFont);
        this.info = l.getLineInfo();
        if (l instanceof Port) {
            Port.Info pi = (Port.Info)this.info;
            this.setTitle(pi.getName());
        }
        this.memberControls = l.getControls();
        if (this.memberControls.length == 0) {
            this.add(new JLabel("(no controls)"), c);
        } else {
            int i;
            this.controlUIs = new ControlUI[this.memberControls.length];
            int gridHeight = 0;
            int gridHeightMax = 0;
            for (i = 0; i < this.memberControls.length; ++i) {
                Control memberControl = this.memberControls[i];
                if (memberControl instanceof BooleanControl) {
                    BooleanControlUI bcUI = new BooleanControlUI((BooleanControl)memberControl);
                    this.controlUIs[i] = bcUI;
                    ++gridHeight;
                } else if (memberControl instanceof FloatControl) {
                    FloatControlUI fcUI = new FloatControlUI((FloatControl)memberControl);
                    this.controlUIs[i] = fcUI;
                    ++gridHeight;
                } else if (memberControl instanceof EnumControl) {
                    EnumControlUI ecUI = new EnumControlUI((EnumControl)memberControl);
                    this.controlUIs[i] = ecUI;
                    ++gridHeight;
                } else if (memberControl instanceof CompoundControl) {
                    CompoundControlUI ccUI = new CompoundControlUI((CompoundControl)memberControl);
                    ccUI.setFont(this.smallFont);
                    this.controlUIs[i] = ccUI;
                    gridHeight = 0;
                }
                if (gridHeight <= gridHeightMax) continue;
                gridHeightMax = gridHeight;
            }
            c.gridx = 0;
            c.gridy = 0;
            for (i = 0; i < this.controlUIs.length; ++i) {
                if (this.controlUIs[i] instanceof CompoundControlUI) {
                    ++c.gridx;
                    c.gridy = 0;
                    c.gridheight = gridHeight;
                } else {
                    ++c.gridy;
                }
                this.add(this.controlUIs[i], c);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        Component[] childs = this.getComponents();
        for (int i = 0; i < childs.length; ++i) {
            childs[i].setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void updateValue() {
        if (this.controlUIs != null) {
            for (ControlUI cui : this.controlUIs) {
                cui.updateValue();
            }
        }
    }
}

