/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class RandomAccessAudioStream {
    public static final boolean DEBUG = false;
    protected AudioSource audioSource;
    protected AudioInputStream audioInputStream = null;
    protected long framePos = 0L;
    protected int frameSize;

    public RandomAccessAudioStream(AudioSource audioSource) {
        this.audioSource = audioSource;
    }

    public int readFrames(byte[] buf, int offset, int len) throws AudioSourceException {
        int readBytes;
        this.getStream();
        try {
            readBytes = this.audioInputStream.read(buf, offset * this.frameSize, len * this.frameSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AudioSourceException(e);
        }
        if (readBytes == -1) {
            return readBytes;
        }
        if (readBytes % this.frameSize != 0) {
            throw new AudioSourceException("Could not read multiple bytes of a frame");
        }
        int readFrames = readBytes / this.frameSize;
        this.framePos += (long)readFrames;
        return readFrames;
    }

    public int readFrames(long pos, byte[] buf, int offset, int len) throws AudioSourceException {
        this.setPosition(pos);
        return this.readFrames(buf, offset, len);
    }

    private AudioInputStream getStream() throws AudioSourceException {
        if (this.audioInputStream == null) {
            this.framePos = 0L;
            this.audioInputStream = this.audioSource.getAudioInputStream();
            this.frameSize = this.audioInputStream.getFormat().getFrameSize();
        }
        return this.audioInputStream;
    }

    public long getPosition() {
        return this.framePos;
    }

    public void setPosition(long pos) throws AudioSourceException {
        this.getStream();
        if (this.framePos > pos) {
            this.framePos = 0L;
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
            this.audioInputStream = this.audioSource.getAudioInputStream();
        }
        if (pos > this.framePos) {
            for (long toSkip = (long)this.frameSize * (pos - this.framePos); toSkip > 0L; toSkip -= this.audioInputStream.skip(toSkip)) {
                try {
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new AudioSourceException(e);
                }
            }
            this.framePos = pos;
        }
    }

    public long skipFrames(long framesToSkip) throws AudioSourceException {
        long skipped;
        this.getStream();
        this.frameSize = this.audioSource.getFormat().getFrameSize();
        long toSkip = framesToSkip * (long)this.frameSize;
        try {
            skipped = this.audioInputStream.skip(toSkip);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AudioSourceException(e);
        }
        if (skipped % (long)this.frameSize > 0L) {
            throw new AudioSourceException("could not skip multile bytes of frame");
        }
        long skippedFrames = skipped / (long)this.frameSize;
        this.framePos += skippedFrames;
        return skippedFrames;
    }

    public void close() throws AudioSourceException {
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
            finally {
                this.audioInputStream = null;
            }
        }
    }

    public long getFrameLength() throws AudioSourceException {
        return this.audioSource.getFrameLength();
    }
}

