/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.BasicAudioSource;
import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class VectorBufferRawAudioSource
extends BasicAudioSource
implements AudioSource {
    private AudioFormat audioFormat;
    private VectorBuffer vectorBuffer;

    public VectorBufferRawAudioSource(VectorBuffer vectorBuffer, AudioFormat audioFormat) {
        this.vectorBuffer = vectorBuffer;
        this.audioFormat = audioFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        long lengthInFrames = this.vectorBuffer.getLength() / (long)this.audioFormat.getFrameSize();
        VectorBufferedInputStream is = new VectorBufferedInputStream(this.vectorBuffer);
        AudioInputStream ais = new AudioInputStream((InputStream)is, this.audioFormat, lengthInFrames);
        return ais;
    }

    @Override
    public boolean isRandomAccessible() {
        return true;
    }
}

