/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui.audiosignal;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalModelRenderer;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalModelRendererEvent;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalModelRendererListener;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AudioSignalClipView
extends BasicAudioClipUI
implements AudioSignalModelRendererListener {
    private AudioSignalModelRenderer renderer;
    private AudioSignalPainter<JPanel> painter = new AudioSignalPainter();
    private int preferredHeight = 60;
    private boolean useThread = true;

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        super.audioClipChanged(event);
        if (event instanceof AudioSourceChangedEvent) {
            this.close();
            this.repaint();
            AudioSource as = ((AudioSourceChangedEvent)event).getAudioSource();
            if (as != null) {
                try {
                    if (this.renderer != null) {
                        this.renderer.close();
                    }
                    this.renderer = new AudioSignalModelRenderer(as, this);
                }
                catch (AudioFormatNotSupportedException e) {
                    JOptionPane.showMessageDialog(this, "Audio format not supported\n" + e.getLocalizedMessage(), "Audio signal renderer", 1);
                    e.printStackTrace();
                }
                catch (AudioSourceException e) {
                    JOptionPane.showMessageDialog(this, "Audio source error: \n" + e.getLocalizedMessage(), "Audio signal renderer error", 0);
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clipBounds = g.getClipBounds();
        super.paintComponent(g2d);
        if (this.audioSample == null || this.audioSample.getAudioSource() == null || this.channels == 0 || this.pixelsPerFrame == 0.0 || this.renderer == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int paintFrom = clipBounds.x - (int)this.pixelsPerFrame - 1;
        if (paintFrom < 0) {
            paintFrom = 0;
        }
        int paintTo = clipBounds.x + clipBounds.width + (int)this.pixelsPerFrame + 1;
        AudioSignalModelRenderer.RenderResult rr = null;
        try {
            rr = this.renderer.render(paintFrom, paintTo, this.framesPerPixel, this.useThread, false);
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        if (rr != null) {
            this.painter.setRenderResult(rr);
            this.painter.paint(g2d, this, width, height);
        }
    }

    @Override
    public void update(AudioSignalModelRendererEvent event) {
        Throwable renderException = event.getRenderException();
        if (renderException != null) {
            this.close();
            JOptionPane.showMessageDialog(this, "Audio signla model renderer error: \n" + renderException.getLocalizedMessage(), "Audio signal model renderer error", 0);
        } else {
            this.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getWidth(), 3);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.preferredHeight);
    }

    @Override
    public void close() {
        if (this.renderer != null) {
            this.renderer.close();
        }
    }
}

