/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class AudioStatus
extends JComponent {
    private Status status = Status.OFF;
    private Dimension size;
    public int DEFAULT_UNIT_PIXELS = 2;
    public int DEFAULT_EDGE_LENGTH_UNITS = 10;
    public int unit = this.DEFAULT_UNIT_PIXELS;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.repaint();
    }

    public AudioStatus() {
        this.size = new Dimension(this.DEFAULT_EDGE_LENGTH_UNITS * this.unit, this.DEFAULT_EDGE_LENGTH_UNITS * this.unit);
        this.setPreferredSize(this.size);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (Status.CAPTURE.equals((Object)this.status)) {
            g2.setColor(Color.YELLOW);
            g2.fillRect(this.unit, this.unit, 3 * this.unit, 8 * this.unit);
            g2.fillRect(6 * this.unit, this.unit, 3 * this.unit, 8 * this.unit);
            g2.setColor(Color.BLACK);
            g2.drawRect(this.unit, this.unit, 3 * this.unit, 8 * this.unit);
            g2.drawRect(6 * this.unit, this.unit, 3 * this.unit, 8 * this.unit);
        } else if (Status.RECORDING.equals((Object)this.status)) {
            g2.setColor(Color.RED);
            g2.fillRect(this.unit, this.unit, 8 * this.unit, 8 * this.unit);
            g2.setColor(Color.BLACK);
            g2.drawRect(this.unit, this.unit, 8 * this.unit, 8 * this.unit);
        } else if (Status.PLAYBACK.equals((Object)this.status)) {
            int border = this.unit;
            int edgeLength = this.unit * 10;
            Polygon poly = new Polygon(new int[]{this.unit, edgeLength - border, border}, new int[]{border, edgeLength / 2, edgeLength - border}, 3);
            g2.setColor(Color.GREEN);
            g2.fillPolygon(poly);
            g2.setColor(Color.BLACK);
            g2.drawPolygon(poly);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    public static void main(String[] args) {
        final AudioStatus as = new AudioStatus();
        Runnable sr = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.getContentPane().add(as);
                f.pack();
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(sr);
        try {
            Thread.sleep(2000L);
            as.setStatus(Status.CAPTURE);
            Thread.sleep(2000L);
            as.setStatus(Status.RECORDING);
            Thread.sleep(2000L);
            as.setStatus(Status.PLAYBACK);
            Thread.sleep(2000L);
            as.setStatus(Status.OFF);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum Status {
        OFF,
        CAPTURE,
        RECORDING,
        PLAYBACK;

    }
}

