/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.BasicAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.SelectionGroup;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.FramePositionChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.audio.dsp.FloatAudioInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AudioClip
extends BasicAudioSource
implements AudioSource {
    private AudioSource audioSource = null;
    private Selection selection = null;
    private Hashtable<String, SelectionGroup> selectionGroups = new Hashtable();
    public static final String PLAYBACK = "Playback";
    public static final String EDIT = "Edit";
    protected AudioClipDSPInfo clipDSPInfo = null;
    private long framePosition = 0L;
    private Vector<AudioClipListener> listenerList = new Vector();

    public AudioClip() {
    }

    public AudioClip(AudioSource audioSource) {
        this();
        this.audioSource = audioSource;
    }

    public AudioSource getAudioSource() {
        return this.audioSource;
    }

    public long getFramePosition() {
        return this.framePosition;
    }

    public void setAudioSource(AudioSource source) {
        this.audioSource = source;
        this.selection = null;
        this.framePosition = 0L;
        this.frameLengthObj = null;
        this.fireAudioSampleChanged(new AudioSourceChangedEvent(this, this.audioSource));
    }

    public void setFramePosition(long l) {
        long oldFramePosition = this.framePosition;
        this.framePosition = l;
        if (this.framePosition != oldFramePosition) {
            this.fireAudioSampleChanged(new FramePositionChangedEvent(this, this.framePosition));
        }
    }

    public synchronized void addAudioSampleListener(AudioClipListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    public synchronized void removeAudioSampleListener(AudioClipListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAudioSampleChanged(AudioClipChangedEvent event) {
        Vector<AudioClipListener> vector = this.listenerList;
        synchronized (vector) {
            for (AudioClipListener listener : this.listenerList) {
                listener.audioClipChanged(event);
            }
        }
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        if (this.audioSource == null) {
            return null;
        }
        AudioInputStream ais = this.audioSource.getAudioInputStream();
        return ais;
    }

    public FloatAudioInputStream getFloatAudioInputStream() throws AudioSourceException {
        FloatAudioInputStream fais;
        if (this.audioSource == null) {
            return null;
        }
        AudioInputStream ais = this.audioSource.getAudioInputStream();
        AudioInputStream pcmStream = null;
        try {
            AudioFormat af = ais.getFormat();
            AudioFormat.Encoding afEnc = af.getEncoding();
            pcmStream = AudioFormat.Encoding.PCM_FLOAT.equals(afEnc) ? ais : (AudioFormat.Encoding.PCM_SIGNED.equals(afEnc) ? ais : ThreadSafeAudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais));
            fais = new FloatAudioInputStream(pcmStream);
            fais.setUseReadOnSkipException(true);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new AudioSourceException(e);
        }
        return fais;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
        this.fireAudioSampleChanged(new SelectionChangedEvent(this, selection));
    }

    public void addSelectionGroup(SelectionGroup sg) {
        this.selectionGroups.put(sg.getName(), sg);
    }

    public void removeSelectionGroup(SelectionGroup sg) {
        this.selectionGroups.remove(sg);
    }

    public SelectionGroup getSelectionGroup(String name) {
        return this.selectionGroups.get(name);
    }

    public AudioClipDSPInfo getClipDSPInfo() {
        return this.clipDSPInfo;
    }

    public void setClipDSPInfo(AudioClipDSPInfo info) {
        this.clipDSPInfo = info;
    }
}

