/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class BasicAudioSource
implements AudioSource {
    protected AudioFormat audioFormat = null;
    protected Long frameLengthObj = null;

    @Override
    public abstract AudioInputStream getAudioInputStream() throws AudioSourceException;

    @Override
    public long getFrameLength() throws AudioSourceException {
        AudioInputStream ais = this.getAudioInputStream();
        long fl = ais.getFrameLength();
        this.frameLengthObj = fl;
        try {
            ais.close();
        }
        catch (IOException e) {
            throw new AudioSourceException(e);
        }
        return this.frameLengthObj;
    }

    @Override
    public AudioFormat getFormat() throws AudioSourceException {
        if (this.audioFormat == null) {
            AudioInputStream ais = this.getAudioInputStream();
            this.audioFormat = ais.getFormat();
            long fl = ais.getFrameLength();
            this.frameLengthObj = fl;
            try {
                ais.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
        }
        return this.audioFormat;
    }

    protected void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    protected void setFrameLength(long frameLength) {
        this.frameLengthObj = frameLength;
    }

    public boolean isRandomAccessible() {
        return false;
    }
}

