/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.io.KnownLengthAudioInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ConvenienceFileAudioSource
extends FileAudioSource {
    private int DETERMINE_FRAME_LEN_BUFFER_SIZE = 2048;
    private long DETERMINE_FRAME_LEN_SKIP_SIZE = 1000000L;
    private long frameLength = ThreadSafeAudioSystem.NOT_SPECIFIED;
    private AudioFormat audioFormat;

    public ConvenienceFileAudioSource(File file) throws AudioSourceException {
        super(file);
        this.getFrameLength();
    }

    private AudioInputStream getPCMAudioInputStream() throws UnsupportedAudioFileException, IOException {
        AudioInputStream pcmStream = null;
        AudioInputStream srcStream = ThreadSafeAudioSystem.getAudioInputStream(this.file);
        AudioFormat srcAf = srcStream.getFormat();
        AudioFormat.Encoding srcEnc = srcAf.getEncoding();
        pcmStream = AudioFormat.Encoding.PCM_SIGNED.equals(srcEnc) || AudioFormat.Encoding.PCM_FLOAT.equals(srcEnc) ? srcStream : ThreadSafeAudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, srcStream);
        return pcmStream;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        try {
            return new KnownLengthAudioInputStream(this.getPCMAudioInputStream(), this.frameLength);
        }
        catch (Exception e) {
            throw new AudioSourceException(e);
        }
    }

    @Override
    public long getFrameLength() throws AudioSourceException {
        AudioInputStream ais;
        if (this.frameLength != (long)ThreadSafeAudioSystem.NOT_SPECIFIED) {
            return this.frameLength;
        }
        try {
            ais = this.getPCMAudioInputStream();
        }
        catch (Exception e) {
            throw new AudioSourceException(e);
        }
        long streamLength = ais.getFrameLength();
        if (streamLength == (long)ThreadSafeAudioSystem.NOT_SPECIFIED) {
            int frameSize = ais.getFormat().getFrameSize();
            long toSkip = this.DETERMINE_FRAME_LEN_SKIP_SIZE * (long)frameSize;
            long byteLength = 0L;
            byte[] buf = new byte[this.DETERMINE_FRAME_LEN_BUFFER_SIZE * frameSize];
            try {
                int read;
                long s;
                while ((s = ais.skip(toSkip)) != 0L) {
                    byteLength += s;
                }
                while ((read = ais.read(buf)) != -1) {
                    byteLength += (long)read;
                }
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
            finally {
                try {
                    ais.close();
                }
                catch (IOException e1) {
                    throw new AudioSourceException(e1);
                }
            }
            streamLength = byteLength / (long)frameSize;
        }
        this.frameLength = streamLength;
        try {
            ais.close();
        }
        catch (IOException e) {
            throw new AudioSourceException(e);
        }
        return this.frameLength;
    }

    @Override
    public AudioFormat getFormat() throws AudioSourceException {
        if (this.audioFormat == null) {
            AudioInputStream ais = this.getAudioInputStream();
            this.audioFormat = ais.getFormat();
            try {
                ais.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
        }
        return this.audioFormat;
    }
}

