/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.samples.SampleManager;
import ipsk.util.services.ServicesInspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;

public class ThreadSafeAudioSystem {
    private static final boolean DEBUG = false;
    private static boolean enabled = false;
    private static String[] READER_TESTFILES = new String[]{"onesample/one_sample.ogg", "onesample/one_sample.flac", "onesample/one_sample.mp3"};
    private static String[] PLUGIN_GREY_LIST = new String[]{"com.sun.media.sound.WaveFloatFileReader"};
    private static ServicesInspector<AudioFileReader> audioFileReaderInspector;
    private static ServicesInspector<AudioFileWriter> audioFileWriterInspector;
    private static ServicesInspector<FormatConversionProvider> formatConversionProviderInspector;
    private static List<Class<? extends FormatConversionProvider>> formatConversionProviderList;
    private static List<Class<? extends AudioFileReader>> audioFileReaderClassList;
    private static List<Class<? extends AudioFileWriter>> audioFileWriterClassList;
    public static int NOT_SPECIFIED;

    public static synchronized void reload() {
        audioFileReaderInspector = new ServicesInspector(AudioFileReader.class);
        try {
            List audioFileReaderClassListOrg = audioFileReaderInspector.getServiceImplementorClasses(true);
            ArrayList<Class> audioFileReaderClassNotGreyList = new ArrayList<Class>();
            audioFileReaderClassList = new ArrayList<Class<? extends AudioFileReader>>();
            for (Class afrCl : audioFileReaderClassListOrg) {
                String afrClNm = afrCl.getName();
                for (String plgGreyNm : PLUGIN_GREY_LIST) {
                    if (plgGreyNm.equals(afrClNm)) {
                        audioFileReaderClassList.add(afrCl);
                        continue;
                    }
                    audioFileReaderClassNotGreyList.add(afrCl);
                }
            }
            audioFileReaderClassList.addAll(audioFileReaderClassNotGreyList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        formatConversionProviderInspector = new ServicesInspector(FormatConversionProvider.class);
        try {
            formatConversionProviderList = formatConversionProviderInspector.getServiceImplementorClasses(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        audioFileWriterInspector = new ServicesInspector(AudioFileWriter.class);
        try {
            audioFileWriterClassList = audioFileWriterInspector.getServiceImplementorClasses(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        return AudioSystem.getAudioFileTypes();
    }

    public static AudioFileFormat.Type[] getAudioFileReaderTypes() {
        Hashtable<String, AudioFileFormat.Type> types = new Hashtable<String, AudioFileFormat.Type>();
        AudioFileFormat.Type[] fcTypes = ThreadSafeAudioSystem.getAudioFileTypes();
        for (AudioFileFormat.Type fcType : fcTypes) {
            types.put(fcType.toString(), fcType);
        }
        types.put(AudioFileFormat.Type.SND.toString(), AudioFileFormat.Type.SND);
        types.put(AudioFileFormat.Type.AIFC.toString(), AudioFileFormat.Type.AIFC);
        for (String readerTestFile : READER_TESTFILES) {
            URL testUrl = SampleManager.class.getResource(readerTestFile);
            try {
                AudioFileFormat testAff = ThreadSafeAudioSystem.getAudioFileFormat(testUrl);
                if (testAff == null) continue;
                AudioFileFormat.Type affT = testAff.getType();
                types.put(affT.toString(), affT);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedAudioFileException e) {
                // empty catch block
            }
        }
        AudioFileFormat.Type[] rTypes = new AudioFileFormat.Type[types.size()];
        int i = 0;
        for (Map.Entry e : types.entrySet()) {
            rTypes[i++] = (AudioFileFormat.Type)e.getValue();
        }
        return rTypes;
    }

    public static boolean _write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        if (audioFileWriterClassList != null) {
            for (int i = audioFileWriterClassList.size() - 1; i >= 0; --i) {
                Class<? extends AudioFileWriter> afwClass = audioFileWriterClassList.get(i);
                try {
                    AudioFileWriter afw = afwClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    afw.write(stream, fileType, out);
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    continue;
                }
            }
        }
        return false;
    }

    public static void write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException, IllegalArgumentException {
        if (enabled) {
            boolean success = ThreadSafeAudioSystem._write(stream, fileType, out);
            if (!success) {
                ThreadSafeAudioSystem.reload();
                success = ThreadSafeAudioSystem._write(stream, fileType, out);
            }
            if (!success) {
                AudioSystem.write(stream, fileType, out);
            }
        } else {
            AudioSystem.write(stream, fileType, out);
        }
    }

    private static AudioInputStream _getAudioInputStream(URL url) throws IOException {
        if (audioFileReaderClassList != null) {
            for (int i = audioFileReaderClassList.size() - 1; i >= 0; --i) {
                Class<? extends AudioFileReader> afrClass = audioFileReaderClassList.get(i);
                try {
                    Constructor<? extends AudioFileReader> cstr = afrClass.getDeclaredConstructor(new Class[0]);
                    AudioFileReader afr = cstr.newInstance(new Object[0]);
                    AudioInputStream ais = afr.getAudioInputStream(url);
                    if (ais != null) {
                        return ais;
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnsupportedAudioFileException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        if (enabled) {
            AudioInputStream ais = ThreadSafeAudioSystem._getAudioInputStream(url);
            if (ais == null) {
                ThreadSafeAudioSystem.reload();
                ais = ThreadSafeAudioSystem._getAudioInputStream(url);
            }
            if (ais == null) {
                throw new UnsupportedAudioFileException();
            }
            return ais;
        }
        return AudioSystem.getAudioInputStream(url);
    }

    private static AudioInputStream _getAudioInputStream(File file) throws IOException {
        if (audioFileReaderClassList != null) {
            for (int i = audioFileReaderClassList.size() - 1; i >= 0; --i) {
                Class<? extends AudioFileReader> afrClass = audioFileReaderClassList.get(i);
                try {
                    AudioFileReader afr = afrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    AudioInputStream ais = afr.getAudioInputStream(file);
                    if (ais != null) {
                        return ais;
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnsupportedAudioFileException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        if (enabled) {
            AudioInputStream ais = ThreadSafeAudioSystem._getAudioInputStream(file);
            if (ais == null) {
                ThreadSafeAudioSystem.reload();
                ais = ThreadSafeAudioSystem._getAudioInputStream(file);
            }
            if (ais == null) {
                throw new UnsupportedAudioFileException();
            }
            return ais;
        }
        return AudioSystem.getAudioInputStream(file);
    }

    private static AudioInputStream _getAudioInputStream(InputStream is) throws IOException {
        if (audioFileReaderClassList != null) {
            for (int i = audioFileReaderClassList.size() - 1; i >= 0; --i) {
                Class<? extends AudioFileReader> afrClass = audioFileReaderClassList.get(i);
                try {
                    AudioFileReader afr = afrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    AudioInputStream ais = afr.getAudioInputStream(is);
                    if (ais != null) {
                        return ais;
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnsupportedAudioFileException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        if (enabled) {
            AudioInputStream ais = ThreadSafeAudioSystem._getAudioInputStream(stream);
            if (ais == null) {
                ThreadSafeAudioSystem.reload();
                ais = ThreadSafeAudioSystem._getAudioInputStream(stream);
            }
            if (ais == null) {
                return AudioSystem.getAudioInputStream(stream);
            }
            return ais;
        }
        return AudioSystem.getAudioInputStream(stream);
    }

    private static AudioInputStream _getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        AudioFormat srcFormat = sourceStream.getFormat();
        AudioFormat.Encoding srcEncoding = srcFormat.getEncoding();
        if (srcEncoding.equals(targetEncoding)) {
            return sourceStream;
        }
        if (formatConversionProviderList != null) {
            for (int i = formatConversionProviderList.size() - 1; i >= 0; --i) {
                Class<? extends FormatConversionProvider> fcpClass = formatConversionProviderList.get(i);
                try {
                    AudioFormat.Encoding[] targetEncodings;
                    FormatConversionProvider fcp = fcpClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (AudioFormat.Encoding e : targetEncodings = fcp.getTargetEncodings(srcFormat)) {
                        if (!e.equals(targetEncoding)) continue;
                        AudioInputStream ais = fcp.getAudioInputStream(targetEncoding, sourceStream);
                        return ais;
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (enabled) {
            AudioInputStream ais = ThreadSafeAudioSystem._getAudioInputStream(targetEncoding, sourceStream);
            if (ais == null) {
                ThreadSafeAudioSystem.reload();
                ais = ThreadSafeAudioSystem._getAudioInputStream(targetEncoding, sourceStream);
            }
            if (ais == null) {
                return AudioSystem.getAudioInputStream(targetEncoding, sourceStream);
            }
            return ais;
        }
        return AudioSystem.getAudioInputStream(targetEncoding, sourceStream);
    }

    private static AudioFileFormat _getAudioFileFormat(URL url) throws IOException {
        if (audioFileReaderClassList != null) {
            for (int i = audioFileReaderClassList.size() - 1; i >= 0; --i) {
                Class<? extends AudioFileReader> afrClass = audioFileReaderClassList.get(i);
                try {
                    AudioFileReader afr = afrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    AudioFileFormat aff = afr.getAudioFileFormat(url);
                    if (aff != null) {
                        return aff;
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnsupportedAudioFileException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws IOException, UnsupportedAudioFileException {
        if (enabled) {
            AudioFileFormat aff = ThreadSafeAudioSystem._getAudioFileFormat(url);
            if (aff == null) {
                ThreadSafeAudioSystem.reload();
                aff = ThreadSafeAudioSystem._getAudioFileFormat(url);
            }
            if (aff == null) {
                return AudioSystem.getAudioFileFormat(url);
            }
            return aff;
        }
        return AudioSystem.getAudioFileFormat(url);
    }

    private static AudioFileFormat _getAudioFileFormat(File file) throws IOException {
        if (audioFileReaderClassList != null) {
            for (int i = audioFileReaderClassList.size() - 1; i >= 0; --i) {
                Class<? extends AudioFileReader> afrClass = audioFileReaderClassList.get(i);
                try {
                    AudioFileReader afr = afrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    AudioFileFormat aff = afr.getAudioFileFormat(file);
                    if (aff != null) {
                        return aff;
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnsupportedAudioFileException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        if (enabled) {
            AudioFileFormat aff = ThreadSafeAudioSystem._getAudioFileFormat(file);
            if (aff == null) {
                ThreadSafeAudioSystem.reload();
                aff = ThreadSafeAudioSystem._getAudioFileFormat(file);
            }
            if (aff == null) {
                return AudioSystem.getAudioFileFormat(file);
            }
            return aff;
        }
        return AudioSystem.getAudioFileFormat(file);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean e) {
        enabled = e;
    }

    static {
        formatConversionProviderList = null;
        audioFileReaderClassList = null;
        audioFileWriterClassList = null;
        NOT_SPECIFIED = -1;
    }
}

