/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ajs;

import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import ipsk.audio.ajs.impl.stdjs.JavaSoundServiceDescriptor;
import ipsk.util.services.ServiceDescriptorsInspector;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.spi.MixerProvider;
import javax.swing.SwingUtilities;

public class AJSAudioSystem
extends ThreadSafeAudioSystem {
    private static HashMap<String, MixerProvider> mixerProviderCache = new HashMap();
    private static ServiceDescriptorsInspector<MixerProviderServiceDescriptor, MixerProvider> mixerProviderServiceInspector = new ServiceDescriptorsInspector(MixerProvider.class);
    private static String applicationName = null;
    private static String freeDesktopApplicationIconName = null;
    private static String DIRECT_SOUND = "DirectSound";
    private static DataLine.Info sourceDataLineInfo = new DataLine.Info(SourceDataLine.class, null);
    private static DataLine.Info targetDataLineInfo = new DataLine.Info(TargetDataLine.class, null);

    public static String getFreeDesktopApplicationIconName() {
        return freeDesktopApplicationIconName;
    }

    public static void setFreeDesktopApplicationIconName(String freeDesktopApplicationIconName) {
        AJSAudioSystem.freeDesktopApplicationIconName = freeDesktopApplicationIconName;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setApplicationName(String applicationName) {
        AJSAudioSystem.applicationName = applicationName;
    }

    public static void init() {
        Runnable comInitializer = new Runnable(){

            @Override
            public void run() {
                List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
                for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                    String mpsdIname = mpsd.getAudioInterfaceName();
                    if (!DIRECT_SOUND.equals(mpsdIname)) continue;
                    try {
                        Class<?> dsMixerclass = Class.forName(mpsd.getServiceImplementationClassname());
                        if (dsMixerclass == null) continue;
                        dsMixerclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Error dsMixerclass) {
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            comInitializer.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(comInitializer);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean hasDataLineInfo(Line.Info[] lineInfos) {
        if (lineInfos == null) {
            return false;
        }
        for (Line.Info li : lineInfos) {
            if (!(li instanceof DataLine.Info)) continue;
            return true;
        }
        return false;
    }

    public static List<MixerProviderServiceDescriptor> listMixerProviderDescriptors() {
        try {
            List mpsds = mixerProviderServiceInspector.getTypedServiceDescriptors(MixerProviderServiceDescriptor.class);
            mpsds.add(new JavaSoundServiceDescriptor());
            return mpsds;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void applyProperties(MixerProvider mixerprovider) {
        Class<?> mpClass = mixerprovider.getClass();
        try {
            Method setMethod = mpClass.getMethod("setAJSProperties", Properties.class);
            if (setMethod != null) {
                Properties p = new Properties();
                if (applicationName != null) {
                    p.put("ips.audio.ajs.application.name", applicationName);
                }
                if (freeDesktopApplicationIconName != null) {
                    p.put("ips.audio.ajs.freedesktop.application.icon.name", freeDesktopApplicationIconName);
                }
                if (p.size() > 0) {
                    try {
                        setMethod.invoke((Object)mixerprovider, p);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MixerProvider getMixerProvider(MixerProviderServiceDescriptor mpsd) {
        HashMap<String, MixerProvider> hashMap = mixerProviderCache;
        synchronized (hashMap) {
            String sClname = mpsd.getServiceImplementationClassname();
            MixerProvider mp = mixerProviderCache.get(sClname);
            if (mp == null) {
                try {
                    Class<?> mpClass = Class.forName(sClname);
                    Object nmpo = mpClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (nmpo instanceof MixerProvider) {
                        mp = (MixerProvider)nmpo;
                        mixerProviderCache.put(sClname, mp);
                        AJSAudioSystem.applyProperties(mp);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return mp;
        }
    }

    public static MixerProviderServiceDescriptor getMixerProviderServiceDescriptor(MixerProvider mp) {
        if (mp == null) {
            return null;
        }
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        String sClname = mp.getClass().getName();
        for (MixerProviderServiceDescriptor mpsd : mpsdList) {
            if (!sClname.equals(mpsd.getServiceImplementationClassname())) continue;
            return mpsd;
        }
        return null;
    }

    public static AJSDevice getDefaultResolvedCaptureDevice() {
        AJSDeviceInfo defDevInfo = AJSAudioSystem.getDefaultCaptureDeviceInfo();
        AJSDevice defDev = AJSAudioSystem.getResolvedCaptureDevice(defDevInfo);
        return defDev;
    }

    public static AJSDevice getResolvedCaptureDevice(AJSDeviceInfo deviceInfo) {
        AJSDevice dev = AJSAudioSystem.getDevice(deviceInfo);
        if (dev.getMixer() == null) {
            Mixer.Info[] mpMixerInfos;
            MixerProviderServiceDescriptor mpsd = deviceInfo.getMixerProviderServiceDescriptor();
            MixerProvider mp = AJSAudioSystem.getMixerProvider(mpsd);
            for (Mixer.Info mpMixerInfo : mpMixerInfos = mp.getMixerInfo()) {
                Mixer m = mp.getMixer(mpMixerInfo);
                Line.Info[] tdlInfos = m.getTargetLineInfo();
                if (!AJSAudioSystem.hasDataLineInfo(tdlInfos)) continue;
                dev = new AJSDevice(mpsd, m);
                break;
            }
        }
        return dev;
    }

    public static AJSDevice getDefaultResolvedPlaybackDevice() {
        AJSDeviceInfo defDevInfo = AJSAudioSystem.getDefaultPlaybackDeviceInfo();
        AJSDevice defDev = AJSAudioSystem.getResolvedPlaybackDevice(defDevInfo);
        return defDev;
    }

    public static AJSDevice getResolvedPlaybackDevice(AJSDeviceInfo deviceInfo) {
        AJSDevice dev = AJSAudioSystem.getDevice(deviceInfo);
        if (dev.getMixer() == null) {
            Mixer.Info[] mpMixerInfos;
            MixerProviderServiceDescriptor mpsd = deviceInfo.getMixerProviderServiceDescriptor();
            MixerProvider mp = AJSAudioSystem.getMixerProvider(mpsd);
            for (Mixer.Info mpMixerInfo : mpMixerInfos = mp.getMixerInfo()) {
                Mixer m = mp.getMixer(mpMixerInfo);
                Line.Info[] sdlInfos = m.getSourceLineInfo();
                if (!AJSAudioSystem.hasDataLineInfo(sdlInfos)) continue;
                dev = new AJSDevice(mpsd, m);
                break;
            }
        }
        return dev;
    }

    public static AJSDevice getDevice(AJSDeviceInfo deviceInfo) {
        List<MixerProviderServiceDescriptor> mpsdList;
        AJSDevice ajsDevice = null;
        if (deviceInfo == null && (mpsdList = AJSAudioSystem.listMixerProviderDescriptors()) != null && mpsdList.size() > 1) {
            return new AJSDevice(mpsdList.get(0), null);
        }
        MixerProviderServiceDescriptor infoMpsd = deviceInfo.getMixerProviderServiceDescriptor();
        String mpClassname = infoMpsd.getServiceImplementationClassname();
        List<MixerProviderServiceDescriptor> mpsdList2 = AJSAudioSystem.listMixerProviderDescriptors();
        for (MixerProviderServiceDescriptor mpsd : mpsdList2) {
            MixerProvider mp;
            if (!mpClassname.equals(mpsd.getServiceImplementationClassname()) || (mp = AJSAudioSystem.getMixerProvider(mpsd)) == null) continue;
            Mixer.Info mInfo = deviceInfo.getMixerInfo();
            Mixer m = null;
            if (mInfo != null) {
                try {
                    m = mp.getMixer(mInfo);
                }
                catch (IllegalArgumentException iae) {
                    break;
                }
            }
            ajsDevice = new AJSDevice(mpsd, m);
            break;
        }
        return ajsDevice;
    }

    public static List<Mixer.Info> availableCaptureMixerInfos(MixerProviderServiceDescriptor mixerProviderServiceDescriptor) {
        MixerProvider mp = AJSAudioSystem.getMixerProvider(mixerProviderServiceDescriptor);
        Mixer.Info[] mInfos = mp.getMixerInfo();
        ArrayList<Mixer.Info> captureMixerInfoList = new ArrayList<Mixer.Info>();
        for (Mixer.Info mInfo : mInfos) {
            Mixer m = mp.getMixer(mInfo);
            Line.Info[] tlInfos = m.getTargetLineInfo(targetDataLineInfo);
            if (!AJSAudioSystem.hasDataLineInfo(tlInfos)) continue;
            captureMixerInfoList.add(mInfo);
        }
        return captureMixerInfoList;
    }

    public static List<AJSDeviceInfo> availableCaptureDeviceInfos(MixerProviderServiceDescriptor mixerProviderServiceDescriptor) {
        MixerProvider mp = AJSAudioSystem.getMixerProvider(mixerProviderServiceDescriptor);
        Mixer.Info[] mInfos = mp.getMixerInfo();
        ArrayList<AJSDeviceInfo> captureDeviceInfoList = new ArrayList<AJSDeviceInfo>();
        for (Mixer.Info mInfo : mInfos) {
            Mixer m = mp.getMixer(mInfo);
            Line.Info[] tlInfos = m.getTargetLineInfo(targetDataLineInfo);
            if (!AJSAudioSystem.hasDataLineInfo(tlInfos)) continue;
            AJSDeviceInfo dInfo = new AJSDeviceInfo(mixerProviderServiceDescriptor, mInfo);
            captureDeviceInfoList.add(dInfo);
        }
        return captureDeviceInfoList;
    }

    public static List<Mixer.Info> availablePlaybackMixerInfos(MixerProviderServiceDescriptor mixerProviderServiceDescriptor) {
        MixerProvider mp = AJSAudioSystem.getMixerProvider(mixerProviderServiceDescriptor);
        Mixer.Info[] mInfos = mp.getMixerInfo();
        ArrayList<Mixer.Info> playbackMixerInfoList = new ArrayList<Mixer.Info>();
        for (Mixer.Info mInfo : mInfos) {
            Mixer m = mp.getMixer(mInfo);
            Line.Info[] slInfos = m.getSourceLineInfo(sourceDataLineInfo);
            if (!AJSAudioSystem.hasDataLineInfo(slInfos)) continue;
            playbackMixerInfoList.add(mInfo);
        }
        return playbackMixerInfoList;
    }

    public static List<AJSDeviceInfo> availablePlaybackDeviceInfos(MixerProviderServiceDescriptor mixerProviderServiceDescriptor) {
        MixerProvider mp = AJSAudioSystem.getMixerProvider(mixerProviderServiceDescriptor);
        Mixer.Info[] mInfos = mp.getMixerInfo();
        ArrayList<AJSDeviceInfo> playbackDeviceInfoList = new ArrayList<AJSDeviceInfo>();
        for (Mixer.Info mInfo : mInfos) {
            Mixer m = mp.getMixer(mInfo);
            Line.Info[] slInfos = m.getSourceLineInfo(sourceDataLineInfo);
            if (!AJSAudioSystem.hasDataLineInfo(slInfos)) continue;
            AJSDeviceInfo dInfo = new AJSDeviceInfo(mixerProviderServiceDescriptor, mInfo);
            playbackDeviceInfoList.add(dInfo);
        }
        return playbackDeviceInfoList;
    }

    public static AJSDeviceInfo getDefaultCaptureDeviceInfo() {
        AJSDeviceInfo di = null;
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        int mpsdCount = mpsdList.size();
        for (int i = 0; i < mpsdCount; ++i) {
            MixerProviderServiceDescriptor mpsd = mpsdList.get(i);
            if (!mpsd.isProvidesCaptureDevices()) continue;
            di = new AJSDeviceInfo(mpsd, null);
            break;
        }
        return di;
    }

    public static AJSDevice getDefaultCaptureDevice() {
        AJSDevice d = null;
        AJSDeviceInfo di = AJSAudioSystem.getDefaultCaptureDeviceInfo();
        if (di != null) {
            d = AJSAudioSystem.getDevice(di);
        }
        return d;
    }

    public static AJSDeviceInfo getDefaultPlaybackDeviceInfo() {
        AJSDeviceInfo di = null;
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        int mpsdCount = mpsdList.size();
        for (int i = 0; i < mpsdCount; ++i) {
            MixerProviderServiceDescriptor mpsd = mpsdList.get(i);
            if (!mpsd.isProvidesPlaybackDevices()) continue;
            di = new AJSDeviceInfo(mpsd, null);
            break;
        }
        return di;
    }

    public static AJSDevice getDefaultPlaybackDevice() {
        AJSDevice d = null;
        AJSDeviceInfo di = AJSAudioSystem.getDefaultPlaybackDeviceInfo();
        if (di != null) {
            d = AJSAudioSystem.getDevice(di);
        }
        return d;
    }

    public static void main(String[] args) {
        List<MixerProviderServiceDescriptor> mpsds = AJSAudioSystem.listMixerProviderDescriptors();
        for (MixerProviderServiceDescriptor mpsd : mpsds) {
            System.out.println("AJS mixer provider of type: " + mpsd.getAudioInterfaceName() + ": " + mpsd.getTitle());
        }
    }

    public static DataLine getLine(DataLine.Info lineInfo) throws LineUnavailableException {
        block9: {
            List<MixerProviderServiceDescriptor> mpsdList;
            block8: {
                mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
                if (!TargetDataLine.class.equals(lineInfo.getLineClass())) break block8;
                for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                    List<AJSDeviceInfo> availCaptureDevices = AJSAudioSystem.availableCaptureDeviceInfos(mpsd);
                    for (AJSDeviceInfo di : availCaptureDevices) {
                        AJSDevice cd = AJSAudioSystem.getDevice(di);
                        if (cd == null) continue;
                        Mixer m = cd.getMixer();
                        try {
                            Line line = m.getLine(lineInfo);
                            if (line == null || !(line instanceof TargetDataLine)) continue;
                            return (DataLine)line;
                        }
                        catch (LineUnavailableException e) {
                        }
                    }
                }
                break block9;
            }
            if (!SourceDataLine.class.equals(lineInfo.getLineClass())) break block9;
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                List<AJSDeviceInfo> availCaptureDevices = AJSAudioSystem.availablePlaybackDeviceInfos(mpsd);
                for (AJSDeviceInfo di : availCaptureDevices) {
                    AJSDevice cd = AJSAudioSystem.getDevice(di);
                    if (cd == null) continue;
                    Mixer m = cd.getMixer();
                    try {
                        Line line = m.getLine(lineInfo);
                        if (line == null || !(line instanceof SourceDataLine)) continue;
                        return (DataLine)line;
                    }
                    catch (LineUnavailableException e) {
                    }
                }
            }
        }
        throw new LineUnavailableException();
    }

    public static enum DeviceType {
        CAPTURE,
        PLAYBACK;

    }
}

