/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ajs;

import ipsk.audio.DeviceProvider;
import ipsk.audio.DeviceProviderInfo;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.ServiceDescriptorBean;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;

public class MixerProviderServiceDescriptor
extends ServiceDescriptorBean
implements DeviceProviderInfo {
    private String audioInterfaceName;
    private String legacyJavaSoundSuffix;
    private boolean providesCaptureDevices = true;
    private boolean providesPlaybackDevices = true;

    @Override
    @XmlElement(required=true)
    public String getAudioInterfaceName() {
        return this.audioInterfaceName;
    }

    public boolean isStandardJavaSoundWrapper() {
        return false;
    }

    public void setAudioInterfaceName(String audioInterfaceName) {
        this.audioInterfaceName = audioInterfaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MixerProviderServiceDescriptor) {
            MixerProviderServiceDescriptor oMpsd = (MixerProviderServiceDescriptor)o;
            String oAin = oMpsd.getAudioInterfaceName();
            if (oAin != null ? !oAin.equals(this.getAudioInterfaceName()) : this.getAudioInterfaceName() != null) {
                return false;
            }
            if (oMpsd.isStandardJavaSoundWrapper() != this.isStandardJavaSoundWrapper()) {
                return false;
            }
            return super.equals((Object)oMpsd);
        }
        return false;
    }

    public static void main(String[] args) {
        MixerProviderServiceDescriptor td = new MixerProviderServiceDescriptor();
        td.setServiceImplementationClassname("test.bla.Klasse");
        td.setAudioInterfaceName("ALSA");
        Version iv = new Version(new int[]{2, 2, 14});
        td.setImplementationVersion(iv);
        HashMap<Locale, String> lStrs = new HashMap<Locale, String>();
        lStrs.put(null, "IPS ALSA JavaSound implementation");
        lStrs.put(new Locale("de"), "IPS ALSA JavaSound Implementierung");
        lStrs.put(new Locale("en"), "IPS ALSA JavaSound implementation");
        LocalizableMessage lm = new LocalizableMessage(lStrs);
        td.setTitle(lm);
        JAXB.marshal((Object)td, (OutputStream)System.out);
    }

    public void setLegacyJavaSoundSuffix(String legacyJavaSoundSuffix) {
        this.legacyJavaSoundSuffix = legacyJavaSoundSuffix;
    }

    public String getLegacyJavaSoundSuffix() {
        return this.legacyJavaSoundSuffix;
    }

    @Override
    public boolean isProvidesCaptureDevices() {
        return this.providesCaptureDevices;
    }

    public void setProvidesCaptureDevices(boolean providesCaptureDevices) {
        this.providesCaptureDevices = providesCaptureDevices;
    }

    @Override
    public boolean isProvidesPlaybackDevices() {
        return this.providesPlaybackDevices;
    }

    public void setProvidesPlaybackDevices(boolean providesPlaybackDevices) {
        this.providesPlaybackDevices = providesPlaybackDevices;
    }

    public DeviceProvider getInstance() {
        String className = this.getServiceImplementationClassname();
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getImplementationClassname() {
        return this.getServiceImplementationClassname();
    }

    public String toString() {
        return this.getAudioInterfaceName() + " (" + this.getImplementationClassname() + ")";
    }
}

