/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ajs.ui;

import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.DeviceSelection;
import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DeviceChooser
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5926257169892584191L;
    private JComboBox<InterfaceElement> interfaceTypeSelector;
    private JComboBox<DeviceView> availDevicesSelector;
    private AJSAudioSystem.DeviceType deviceType = null;

    public DeviceChooser(DeviceSelection deviceManager) {
        if (deviceManager != null) {
            this.deviceType = deviceManager.getDeviceType();
        }
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        int mpsdCount = mpsdList.size();
        Vector<InterfaceElement> interfaces = new Vector<InterfaceElement>();
        for (int i = 0; i < mpsdCount; ++i) {
            MixerProviderServiceDescriptor mpsd = mpsdList.get(i);
            InterfaceElement ie = new InterfaceElement(mpsd);
            interfaces.add(ie);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        JLabel interfaceTypeLabel = new JLabel("Interface:");
        this.add((Component)interfaceTypeLabel, c);
        ++c.gridx;
        c.anchor = 17;
        this.interfaceTypeSelector = new JComboBox(interfaces);
        this.interfaceTypeSelector.addActionListener(this);
        this.add(this.interfaceTypeSelector, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        JLabel deviceLabel = new JLabel("Device:");
        this.add((Component)deviceLabel, c);
        this.availDevicesSelector = new JComboBox();
        ++c.gridx;
        c.anchor = 17;
        this.add(this.availDevicesSelector, c);
        AJSDevice selDevice = null;
        if (deviceManager != null && (selDevice = deviceManager.getDevice()) != null) {
            MixerProviderServiceDescriptor mpsd = selDevice.getMixerproviderServiceDescriptor();
            InterfaceElement ie = new InterfaceElement(mpsd);
            this.interfaceTypeSelector.setSelectedItem(ie);
            Mixer m = selDevice.getMixer();
            this.availDevicesSelector.setSelectedItem(new DeviceView(m.getMixerInfo()));
        }
        if (selDevice == null) {
            int interfacesCount = interfaces.size();
            boolean hasDevices = false;
            for (int ii = 0; !hasDevices && ii < interfacesCount; ++ii) {
                InterfaceElement ie = (InterfaceElement)interfaces.get(ii);
                hasDevices = this.loadDeviceList(ie);
                if (!hasDevices) continue;
                this.interfaceTypeSelector.setSelectedItem(ie);
                break;
            }
        }
    }

    private boolean loadDeviceList(InterfaceElement ie) {
        boolean hasMatchingDevices = false;
        MixerProviderServiceDescriptor mpsd = ie.getMpsd();
        String siClassname = mpsd.getServiceImplementationClassname();
        try {
            Class<?> siClass = Class.forName(siClassname);
            Object siObj = siClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.availDevicesSelector.removeAllItems();
            if (siObj instanceof MixerProvider) {
                List<Mixer.Info> mixerInfosList = null;
                MixerProvider mp = (MixerProvider)siObj;
                if (this.deviceType == null) {
                    Mixer.Info[] miInfos = mp.getMixerInfo();
                    mixerInfosList = Arrays.asList(miInfos);
                } else if (AJSAudioSystem.DeviceType.CAPTURE.equals((Object)this.deviceType)) {
                    mixerInfosList = AJSAudioSystem.availableCaptureMixerInfos(mpsd);
                } else if (AJSAudioSystem.DeviceType.PLAYBACK.equals((Object)this.deviceType)) {
                    mixerInfosList = AJSAudioSystem.availablePlaybackMixerInfos(mpsd);
                }
                if (mixerInfosList != null && mixerInfosList.size() > 0) {
                    hasMatchingDevices = true;
                    this.availDevicesSelector.setEnabled(true);
                    DeviceView defDv = new DeviceView(null);
                    this.availDevicesSelector.addItem(defDv);
                    for (Mixer.Info mi : mixerInfosList) {
                        DeviceView mDv = new DeviceView(mi);
                        this.availDevicesSelector.addItem(mDv);
                    }
                } else {
                    this.availDevicesSelector.setEnabled(false);
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return hasMatchingDevices;
    }

    public AJSDeviceInfo getSelectedDeviceInfo() {
        InterfaceElement ie = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
        MixerProviderServiceDescriptor mpsd = ie.getMpsd();
        DeviceView dv = (DeviceView)this.availDevicesSelector.getSelectedItem();
        Mixer.Info mixerInfo = dv.getMixerInfo();
        AJSDeviceInfo di = new AJSDeviceInfo(mpsd, mixerInfo);
        return di;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object evSrc = ae.getSource();
        if (evSrc == this.interfaceTypeSelector) {
            InterfaceElement ie = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
            this.loadDeviceList(ie);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceSelection deviceManager = new DeviceSelection(AJSAudioSystem.DeviceType.CAPTURE);
                List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
                MixerProviderServiceDescriptor mpsd = mpsdList.get(0);
                MixerProvider mp = AJSAudioSystem.getMixerProvider(mpsd);
                Mixer.Info[] mInfos = mp.getMixerInfo();
                Mixer m = mp.getMixer(mInfos[0]);
                AJSDevice ajsD = new AJSDevice(mpsd, m);
                deviceManager.setDevice(ajsD);
                DeviceChooser mc = new DeviceChooser(deviceManager);
                JFrame f = new JFrame("Mixer chooser");
                f.getContentPane().add(mc);
                f.setVisible(true);
                f.pack();
            }
        });
    }

    public class InterfaceElement {
        private MixerProviderServiceDescriptor mpsd;

        InterfaceElement(MixerProviderServiceDescriptor mpsd) {
            this.mpsd = mpsd;
        }

        public String toString() {
            return this.mpsd.getAudioInterfaceName();
        }

        public boolean equals(Object o) {
            InterfaceElement oIe;
            if (o == this) {
                return true;
            }
            return o instanceof InterfaceElement && this.mpsd.equals((oIe = (InterfaceElement)o).getMpsd());
        }

        public MixerProviderServiceDescriptor getMpsd() {
            return this.mpsd;
        }
    }

    public class DeviceView {
        private Mixer.Info mixerInfo;

        public DeviceView(Mixer.Info mInfo) {
            this.mixerInfo = mInfo;
        }

        public String toString() {
            if (this.mixerInfo == null) {
                return "(Default device)";
            }
            return this.mixerInfo.getName();
        }

        public Mixer.Info getMixerInfo() {
            return this.mixerInfo;
        }

        public boolean equals(Object o) {
            DeviceView oDv;
            Mixer.Info oMi;
            if (o == this) {
                return true;
            }
            return o instanceof DeviceView && ((oMi = (oDv = (DeviceView)o).getMixerInfo()) != null ? oMi.equals(this.mixerInfo) : this.mixerInfo == null);
        }
    }
}

