/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.ui.AudioSignalRenderer;
import ipsk.audio.arr.clip.ui.AudioSignalRendererEvent;
import ipsk.audio.arr.clip.ui.AudioSignalRendererListener;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;

public class AudioClipPainter
implements AudioSignalRendererListener {
    public AudioSource audioSource;

    public AudioClipPainter(AudioSource audioSource) {
        this.audioSource = audioSource;
    }

    public void paintToImage(BufferedImage img) throws AudioFormatNotSupportedException, AudioSourceException {
        this.paintToImage(img, 1.0);
    }

    public void paintToImage(BufferedImage img, double xZoom) throws AudioFormatNotSupportedException, AudioSourceException {
        int w = img.getWidth();
        int h = img.getHeight();
        Dimension size = new Dimension(w, h);
        AudioClip ac = new AudioClip(this.audioSource);
        AudioSignalUI signalUI = new AudioSignalUI(ac);
        signalUI.setSize(size);
        signalUI.doLayout();
    }

    public RenderedImage createImage(double xZoom, int height) throws AudioFormatNotSupportedException, AudioSourceException {
        AudioFormat af = this.audioSource.getFormat();
        long frameLength = this.audioSource.getFrameLength();
        double lengthSeconds = (double)frameLength / (double)af.getSampleRate();
        int w = (int)(lengthSeconds * xZoom);
        double framesPerPixel = (double)frameLength / (double)w;
        AudioSignalRenderer asr = new AudioSignalRenderer(this.audioSource, this);
        asr.setBackgroundColor(Color.BLACK);
        return asr.renderImage(w, height, framesPerPixel);
    }

    public static void main(String[] args) {
        FileAudioSource fas = new FileAudioSource(new File(args[0]));
        AudioClipPainter acp = new AudioClipPainter(fas);
        try {
            RenderedImage img = acp.createImage(20.0, 50);
            ImageIO.write(img, "png", new File(args[1]));
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    @Override
    public void update(AudioSignalRendererEvent event) {
    }
}

