/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ips.media.MediaLengthUnit;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionList;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionProvider;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.CheckActionLeaf;
import ipsk.util.LocalizableMessage;
import java.awt.event.ActionEvent;
import java.text.Format;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AudioClipScrollPane
extends JScrollPane
implements ActionProvider {
    private static final long serialVersionUID = 4662537204671679638L;
    private AudioClipUIContainer audioClipUiContainer;
    private boolean showYScales = true;
    private ActionTreeRoot ar;

    public boolean isShowYScales() {
        return this.showYScales;
    }

    public void setShowYScales(boolean showYScales) {
        boolean oldShowYScales = this.showYScales;
        this.showYScales = showYScales;
        if (this.showYScales != oldShowYScales) {
            this.updateYScales();
        }
    }

    public AudioClipUIContainer getAudioClipUiContainer() {
        return this.audioClipUiContainer;
    }

    public void setAudioClipUiContainer(AudioClipUIContainer audioClipUiContainer) {
        this.audioClipUiContainer = audioClipUiContainer;
        this.setViewportView(audioClipUiContainer);
        this.updateYScales();
    }

    private void createActions() {
        String packageName = this.getClass().getPackage().getName();
        String resBundleName = packageName + ".ResBundle";
        this.ar = new ActionTreeRoot();
        ActionFolder vF = ActionFolder.buildTopLevelFolder((String)"view");
        this.ar.add((ActionNode)vF);
        vF.add((ActionNode)new ToggleYScalesVisibilityAction(new LocalizableMessage(resBundleName, "show_y_scales")));
    }

    public AudioClipScrollPane() {
        this.createActions();
    }

    public AudioClipScrollPane(AudioClipUIContainer audioClipUiContainer) {
        super(audioClipUiContainer);
        this.audioClipUiContainer = audioClipUiContainer;
        this.createActions();
        this.updateYScales();
    }

    public AudioClipScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
    }

    public AudioClipScrollPane(AudioClipUIContainer view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.audioClipUiContainer = view;
        this.updateYScales();
    }

    private void updateYScales() {
        JPanel rowHeaderView = null;
        if (this.showYScales) {
            rowHeaderView = this.audioClipUiContainer.getyScalesComponent();
        }
        this.setRowHeaderView(rowHeaderView);
    }

    public void setXZoom(double xZoom) {
        this.audioClipUiContainer.setXZoom(xZoom);
    }

    public void xZoomFitToPanel() {
        this.audioClipUiContainer.xZoomFitToPanel();
    }

    public void setFixXZoomFitToPanel(boolean b) {
        this.audioClipUiContainer.setFixXZoomFitToPanel(b);
    }

    public double getXZoom() {
        return this.audioClipUiContainer.getXZoom();
    }

    public void xZoomToSelection() {
        this.audioClipUiContainer.xZoomToSelection();
    }

    public void xZoomOnePixelPerSample() {
        this.audioClipUiContainer.xZoomOnePixelPerSample();
    }

    public void setTimeFormat(Format timeFormat) {
        this.audioClipUiContainer.setTimeFormat(timeFormat);
    }

    public void setMediaLengthUnit(MediaLengthUnit mediaLengthUnit) {
        this.audioClipUiContainer.setMediaLengthUnit(mediaLengthUnit);
    }

    public ActionTreeRoot getActionTreeRoot() {
        ActionTreeRoot af = this.audioClipUiContainer.getActionTreeRoot();
        af.merge((ActionList)this.ar);
        return af;
    }

    public class ToggleYScalesVisibilityAction
    extends CheckActionLeaf {
        public ToggleYScalesVisibilityAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipScrollPane.this.setShowYScales(this.isSelected());
        }
    }
}

