/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ips.media.MediaLengthUnit;
import ips.media.MediaView;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipUI;
import ipsk.audio.arr.clip.ui.FragmentActionBarUI;
import ipsk.awt.TickProvider;
import ipsk.swing.JAutoScale;
import ipsk.swing.JMultiSplitPane;
import ipsk.swing.action.tree.AbstractActionLeaf;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.ActionList;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionProvider;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.CheckActionLeaf;
import ipsk.text.TimeFormat;
import ipsk.util.LocalizableMessage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.Format;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class AudioClipUIContainer
extends JPanel
implements Scrollable,
AudioClipListener,
ComponentListener,
ActionProvider,
MediaView {
    private static final long serialVersionUID = 7378566581967916025L;
    private static final boolean DEBUG = false;
    protected double xZoom;
    private Vector<ActionListener> actionListener;
    private JPopupMenu popup;
    private boolean fixXZoomFitToPanel = true;
    private Container parent = null;
    private boolean internalChange = false;
    private double lengthInSeconds;
    private AudioClip audioClip;
    private long length;
    private AudioFormat audioFormat;
    private Vector<Plugin> plugins = new Vector();
    private int preferredWidth = 0;
    private JAutoScale xScale;
    private JMultiSplitPane defaultPane;
    private MediaLengthUnit mediaLengthUnit = MediaLengthUnit.TIME;
    private Format timeFormat = TimeFormat.FIXED_SECONDS_MS_TIME_FORMAT;
    private ActionTreeRoot actionRoot = new ActionTreeRoot();
    private XZoomInAction xZoomInAction;
    private XZoomOutAction xZoomOutAction;
    private XZoomFitToPanelAction xZoomFitToPanelAction;
    private XZoomOnePixelPerSampleAction xZoomOnePixelPerSampleAction;
    private XZoomToSelectionAction xZoomToSelectionAction;
    private XZoomFixFitToPanelAction xZoomFixFitToPanelAction;
    private CancelSelectionAction cancelSelectionAction;
    private YScalesPanel yScalesComponent;
    private ActionFolder actionViewFolder;
    private ToggleXScaleVisibilityAction toggleXScaleVisibilityAction = new ToggleXScaleVisibilityAction();

    public JPanel getyScalesComponent() {
        return this.yScalesComponent;
    }

    public AudioClipUIContainer() {
        super(null);
        String packageName = this.getClass().getPackage().getName();
        String resBundleName = packageName + ".ResBundle";
        this.actionListener = new Vector();
        this.popup = new JPopupMenu();
        this.actionViewFolder = ActionFolder.buildTopLevelFolder((String)"view");
        this.actionRoot.getChildren().add(this.actionViewFolder);
        this.cancelSelectionAction = new CancelSelectionAction(new LocalizableMessage(resBundleName, "select.cancel"));
        this.actionViewFolder.getChildren().add(this.cancelSelectionAction);
        this.cancelSelectionAction.setEnabled(false);
        ActionGroup zoomGroup = new ActionGroup("zoom");
        ActionFolder xZoomSubMenuAF = new ActionFolder("xZoom", new LocalizableMessage("X-Zoom"));
        zoomGroup.add((ActionNode)xZoomSubMenuAF);
        this.actionViewFolder.getChildren().add(zoomGroup);
        this.xZoomInAction = new XZoomInAction(new LocalizableMessage(resBundleName, "in"));
        xZoomSubMenuAF.getChildren().add(this.xZoomInAction);
        this.xZoomOutAction = new XZoomOutAction(new LocalizableMessage(resBundleName, "out"));
        xZoomSubMenuAF.getChildren().add(this.xZoomOutAction);
        this.xZoomFitToPanelAction = new XZoomFitToPanelAction(new LocalizableMessage(resBundleName, "fit_to_panel"));
        xZoomSubMenuAF.getChildren().add(this.xZoomFitToPanelAction);
        this.xZoomOnePixelPerSampleAction = new XZoomOnePixelPerSampleAction(new LocalizableMessage(resBundleName, "one_pixel_per_sample"));
        xZoomSubMenuAF.getChildren().add(this.xZoomOnePixelPerSampleAction);
        this.xZoomToSelectionAction = new XZoomToSelectionAction(new LocalizableMessage(resBundleName, "zoom_selection"));
        xZoomSubMenuAF.getChildren().add(this.xZoomToSelectionAction);
        this.xZoomFixFitToPanelAction = new XZoomFixFitToPanelAction(new LocalizableMessage(resBundleName, "fix_fit_to_panel"));
        xZoomSubMenuAF.getChildren().add(this.xZoomFixFitToPanelAction);
        this.defaultPane = new JMultiSplitPane();
        super.add((Component)this.defaultPane);
        this.setFixXZoomFitToPanel(true);
        this.yScalesComponent = new YScalesPanel();
        this.yScalesComponent.setLayout(null);
    }

    public AudioClipUIContainer(AudioClip audioSample) throws AudioFormatNotSupportedException, AudioSourceException {
        this();
        this.setAudioClip(audioSample);
    }

    @Override
    public Component add(Component pluginUI) {
        if (pluginUI instanceof JAutoScale) {
            super.add(pluginUI);
            this.xScale = (JAutoScale)pluginUI;
            if (pluginUI instanceof AudioClipUI) {
                AudioClipUI acui = (AudioClipUI)((Object)pluginUI);
                acui.setMediaLengthUnit(this.mediaLengthUnit);
                acui.setTimeFormat(this.timeFormat);
            }
            this.xScale.setFont(this.xScale.getFont().deriveFont(10.0f));
            for (Plugin p : this.plugins) {
                p.getClipUI().setTimeScaleTickProvider((TickProvider<Long>)this.xScale);
            }
            this.actionViewFolder.getChildren().add(this.toggleXScaleVisibilityAction);
        } else if (pluginUI instanceof FragmentActionBarUI) {
            super.add(pluginUI);
            AudioClipUI acui = (AudioClipUI)((Object)pluginUI);
            Plugin plugin = new Plugin(acui, this);
            this.plugins.add(plugin);
            TogglePluginAction tpa = plugin.getTogglePluginAction();
            tpa.setSelected(true);
            this.actionViewFolder.add((ActionNode)tpa);
        } else if (pluginUI instanceof AudioClipUI) {
            JComponent[] yScales;
            AudioClipUI acui = (AudioClipUI)((Object)pluginUI);
            Plugin plugin = new Plugin(acui, this);
            this.plugins.add(plugin);
            acui.setAudioSample(this.audioClip);
            acui.setMediaLengthUnit(this.mediaLengthUnit);
            acui.setTimeFormat(this.timeFormat);
            if (this.xScale != null) {
                acui.setTimeScaleTickProvider((TickProvider<Long>)this.xScale);
            }
            if ((yScales = acui.getYScales()) != null) {
                for (JComponent yScale : yScales) {
                    if (yScale == null) continue;
                    this.yScalesComponent.add(yScale);
                    yScale.addComponentListener(this);
                    pluginUI.addComponentListener(this);
                }
            }
            if (acui.isPreferredFixedHeight()) {
                super.add(pluginUI);
            } else {
                this.defaultPane.add(pluginUI);
            }
            TogglePluginAction tpa = plugin.getTogglePluginAction();
            tpa.setSelected(true);
            this.actionViewFolder.add((ActionNode)tpa);
        } else {
            super.add(pluginUI);
        }
        return pluginUI;
    }

    @Override
    public void remove(Component plugin) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin p = this.plugins.get(i);
            AudioClipUI acUi = p.getClipUI();
            if (this.internalChange || !acUi.equals(plugin)) continue;
            TogglePluginAction tpa = p.getTogglePluginAction();
            this.actionViewFolder.remove((Object)tpa);
            this.plugins.remove(i);
        }
        if (plugin instanceof AudioClipUI) {
            AudioClipUI acUI = (AudioClipUI)((Object)plugin);
            JComponent[] yScales = acUI.getYScales();
            plugin.removeComponentListener(this);
            if (yScales != null) {
                for (JComponent yScale : yScales) {
                    if (yScale == null) continue;
                    this.yScalesComponent.remove(yScale);
                }
            }
        }
        this.defaultPane.remove(plugin);
        super.remove(plugin);
    }

    protected long mapPixelToFrame(int pixelPosition) {
        double currWidth = this.getWidth();
        if (currWidth > 0.0) {
            double framesPerPixel = (double)this.length / currWidth;
            return (int)((double)pixelPosition * framesPerPixel);
        }
        return 0L;
    }

    protected int mapFrameToPixel(long framePosition) {
        double currWidth = this.getWidth();
        if (currWidth > 0.0) {
            double framesPerPixel = (double)this.length / currWidth;
            return (int)((double)framePosition / framesPerPixel);
        }
        return 0;
    }

    public synchronized void setXZoom(double xZoom) {
        Rectangle currentVisible = this.getVisibleRect();
        long currentXFramePos = this.mapPixelToFrame(currentVisible.x);
        this.xZoom = xZoom;
        this.preferredWidth = (int)(this.lengthInSeconds * xZoom);
        this.revalidate();
        ScrollToFramePositionRunnable sr = new ScrollToFramePositionRunnable(currentXFramePos);
        SwingUtilities.invokeLater(sr);
    }

    private void stop() {
    }

    public synchronized void clear() {
        this.clearScreen();
    }

    public synchronized void clearScreen() {
        this.stop();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
    }

    public void setAudioClip(AudioClip audioSample) {
        if (audioSample == this.audioClip) {
            return;
        }
        if (this.audioClip != null) {
            this.audioClip.removeAudioSampleListener(this);
        }
        this.audioClip = audioSample;
        if (audioSample != null) {
            audioSample.addAudioSampleListener(this);
            this.audioClipChanged(new AudioSourceChangedEvent(this, audioSample.getAudioSource()));
        }
        this.preferredWidth = (int)(this.lengthInSeconds * this.xZoom);
        if (this.xScale != null) {
            ((AudioClipUI)this.xScale).setAudioSample(audioSample);
        }
        for (Plugin p : this.plugins) {
            p.getClipUI().setAudioSample(audioSample);
        }
        AudioSource as = null;
        if (audioSample != null) {
            as = audioSample.getAudioSource();
        }
        this.audioClipChanged(new AudioSourceChangedEvent(this, as));
        this.xZoomFitToPanel();
        this.repaint();
    }

    public void setMediaLengthUnit(MediaLengthUnit mediaLengthUnit) {
        this.mediaLengthUnit = mediaLengthUnit;
        for (Plugin p : this.plugins) {
            AudioClipUI pUI = p.getClipUI();
            pUI.setMediaLengthUnit(mediaLengthUnit);
        }
        if (this.xScale != null) {
            AudioClipUI plugin = (AudioClipUI)this.xScale;
            plugin.setMediaLengthUnit(mediaLengthUnit);
        }
    }

    public void setTimeFormat(Format timeFormat) {
        this.timeFormat = timeFormat;
        for (Plugin p : this.plugins) {
            AudioClipUI pUI = p.getClipUI();
            pUI.setTimeFormat(timeFormat);
        }
        if (this.xScale != null) {
            AudioClipUI plugin = (AudioClipUI)this.xScale;
            plugin.setTimeFormat(timeFormat);
        }
    }

    public double getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = this.getPreferredSize();
        return d;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 50;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 1;
    }

    public double getXZoom() {
        return this.xZoom;
    }

    private void setSelection(Selection s) {
        this.xZoomToSelectionAction.setEnabled(s != null);
        this.repaint();
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        if (event instanceof SelectionChangedEvent) {
            Selection newSelection = ((SelectionChangedEvent)event).getSelection();
            this.setSelection(newSelection);
            this.cancelSelectionAction.setEnabled(newSelection != null);
        } else if (event instanceof AudioSourceChangedEvent) {
            try {
                this.cancelSelectionAction.setEnabled(false);
                AudioSource audioSource = ((AudioSourceChangedEvent)event).getAudioSource();
                if (audioSource != null) {
                    AudioInputStream ais = audioSource.getAudioInputStream();
                    this.audioFormat = ais.getFormat();
                    long frameLength = ais.getFrameLength();
                    try {
                        ais.close();
                    }
                    catch (IOException e) {
                        throw new AudioSourceException(e);
                    }
                    this.length = frameLength;
                    this.lengthInSeconds = this.length == (long)ThreadSafeAudioSystem.NOT_SPECIFIED || this.audioFormat == null ? 0.0 : (double)((float)this.length / this.audioFormat.getFrameRate());
                    if (this.length == 0L) {
                        this.preferredWidth = 0;
                    } else if (this.fixXZoomFitToPanel || this.xZoom == 0.0) {
                        this.xZoomFitToPanel();
                    } else {
                        this.preferredWidth = (int)(this.lengthInSeconds * this.xZoom);
                    }
                } else {
                    this.audioFormat = null;
                    this.length = ThreadSafeAudioSystem.NOT_SPECIFIED;
                    this.lengthInSeconds = 0.0;
                    this.preferredWidth = 0;
                    this.remove(this.yScalesComponent);
                }
                this.revalidate();
                this.repaint();
            }
            catch (AudioSourceException audioSourceException) {
                // empty catch block
            }
        }
    }

    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.actionListener.contains(acl)) {
            this.actionListener.addElement(acl);
        }
    }

    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.actionListener.removeElement(acl);
        }
    }

    protected synchronized void updateListeners(ActionEvent ae) {
        for (ActionListener listener : this.actionListener) {
            listener.actionPerformed(ae);
        }
    }

    private void doXZoomFitToPanel() {
        Container p = this.getParent();
        this.preferredWidth = p != null && this.length > 0L ? p.getSize().width : 0;
        if (this.length > 0L && this.lengthInSeconds > 0.0) {
            this.xZoom = (double)this.preferredWidth / this.lengthInSeconds;
        }
    }

    public void xZoomFitToPanel() {
        this.doXZoomFitToPanel();
        this.revalidate();
        this.repaint();
    }

    public void setFixXZoomFitToPanel(boolean b) {
        this.fixXZoomFitToPanel = b;
        this.xZoomFixFitToPanelAction.setSelected(this.fixXZoomFitToPanel);
        if (this.fixXZoomFitToPanel) {
            this.xZoomFitToPanel();
        }
    }

    public void xZoomOnePixelPerSample() {
        this.setFixXZoomFitToPanel(false);
        if (this.audioFormat != null) {
            float frameRate = this.audioFormat.getFrameRate();
            this.setXZoom(frameRate);
        }
    }

    public void xZoomToSelection() {
        double selectedLength;
        this.setFixXZoomFitToPanel(false);
        Selection selection = this.audioClip.getSelection();
        if (selection != null && (selectedLength = (double)((float)selection.getLength() / this.audioFormat.getFrameRate())) > 0.0) {
            this.fixXZoomFitToPanel = false;
            Rectangle currentVisible = new Rectangle();
            this.computeVisibleRect(currentVisible);
            this.xZoom = (double)currentVisible.width / selectedLength;
            this.preferredWidth = (int)(this.lengthInSeconds * this.xZoom);
            this.revalidate();
            ScrollToFramePositionRunnable sr = new ScrollToFramePositionRunnable(selection.getLeft());
            SwingUtilities.invokeLater(sr);
        }
    }

    public void actionPerformed(ActionEvent ae) {
    }

    public void setXScaleVisible(boolean visible) {
        if (visible) {
            super.add((Component)this.xScale);
        } else {
            super.remove((Component)this.xScale);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.parent = this.getParent();
        if (this.parent != null) {
            this.parent.addComponentListener(this);
        }
    }

    @Override
    public void removeNotify() {
        if (this.parent != null) {
            this.parent.removeComponentListener(this);
        }
        super.removeNotify();
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        AudioClipUI acui;
        JComponent[] yScales;
        Component rc = ce.getComponent();
        if (rc == this.parent) {
            Container parent = this.getParent();
            if (parent != null && this.fixXZoomFitToPanel) {
                this.xZoomFitToPanel();
            }
        } else if (rc instanceof AudioClipUI && (yScales = (acui = (AudioClipUI)((Object)rc)).getYScales()) != null) {
            for (JComponent yScale : yScales) {
                yScale.setLocation(yScale.getX(), rc.getY());
            }
            if (this.yScalesComponent != null) {
                this.yScalesComponent.revalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets insets = this.getInsets();
            Component[] cs = this.getComponents();
            int preferredHeight = 0;
            for (int i = 0; i < cs.length; ++i) {
                Dimension d = cs[i].getPreferredSize();
                if (d == null || d.height <= 0) continue;
                preferredHeight += d.height;
            }
            preferredHeight += insets.top;
            Dimension preferredSize = new Dimension(this.preferredWidth + insets.left + insets.right, preferredHeight += insets.bottom);
            return preferredSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets insets = this.getInsets();
            int height = this.getSize().height;
            int availableHeight = height - insets.top - insets.bottom;
            int width = this.getSize().width;
            if (this.xScale != null && this.toggleXScaleVisibilityAction.isSelected()) {
                int xScaleHeight = this.xScale.getMinimumSize().height;
                this.xScale.setBounds(0, height - xScaleHeight, width, xScaleHeight);
                availableHeight -= xScaleHeight;
            }
            for (Plugin p : this.plugins) {
                Component[] cmps;
                AudioClipUI plugin = p.getClipUI();
                Component pc = plugin.asComponent();
                for (Component c : cmps = this.getComponents()) {
                    if (c != pc || !plugin.isPreferredFixedHeight()) continue;
                    int fbHeight = 0;
                    JComponent[] yScales = plugin.getYScales();
                    if (!pc.isVisible()) continue;
                    pc.doLayout();
                    fbHeight = pc.getPreferredSize().height;
                    pc.setBounds(0, availableHeight - fbHeight, width, fbHeight);
                    availableHeight -= fbHeight;
                    if (yScales == null) continue;
                    for (JComponent yScale : yScales) {
                        yScale.setLocation(yScale.getX(), pc.getY());
                    }
                }
            }
            this.defaultPane.setBounds(0, 0, width, availableHeight);
            this.defaultPane.doLayout();
        }
        if (this.yScalesComponent != null) {
            this.yScalesComponent.revalidate();
            this.yScalesComponent.repaint();
        }
    }

    public JAutoScale getXScale() {
        return this.xScale;
    }

    public void setXScale(JAutoScale scale) {
        this.xScale = scale;
    }

    public void close() {
        Component[] childs = this.getComponents();
        for (int i = 0; i < childs.length; ++i) {
            if (!(childs[i] instanceof AudioClipUI)) continue;
            AudioClipUI plugin = (AudioClipUI)((Object)childs[i]);
            plugin.close();
        }
    }

    public AudioClip getAudioClip() {
        return this.audioClip;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public ActionTreeRoot getActionTreeRoot() {
        for (Plugin p : this.plugins) {
            ShowPluginControlComponentAction spcca;
            TogglePluginAction tpa = p.getTogglePluginAction();
            if (tpa != null && !this.actionViewFolder.getChildren().contains(tpa)) {
                this.actionViewFolder.add((ActionNode)tpa);
            }
            if ((spcca = p.getShowPluginControlComponentAction()) == null || this.actionViewFolder.getChildren().contains((Object)spcca)) continue;
            this.actionViewFolder.add((ActionNode)spcca);
        }
        for (Plugin p : this.plugins) {
            ActionTreeRoot at = p.getClipUI().getActionTreeRoot();
            this.actionRoot.merge((ActionList)at);
        }
        return this.actionRoot;
    }

    public void addPopupMouseListener(MouseListener ml) {
        this.defaultPane.addMouseListener(ml);
    }

    public MediaLengthUnit getMediaLengthUnit() {
        return this.mediaLengthUnit;
    }

    public Format getTimeFormat() {
        return this.timeFormat;
    }

    public class ScrollToFramePositionRunnable
    implements Runnable {
        private long framePosition;

        public ScrollToFramePositionRunnable(long framePosition) {
            this.framePosition = framePosition;
        }

        @Override
        public void run() {
            int newVisibleX = AudioClipUIContainer.this.mapFrameToPixel(this.framePosition);
            Rectangle currentVisible = new Rectangle();
            AudioClipUIContainer.this.computeVisibleRect(currentVisible);
            if (newVisibleX < 0) {
                newVisibleX = 0;
            }
            Rectangle newVisible = new Rectangle(newVisibleX, currentVisible.y, currentVisible.width, currentVisible.height);
            AudioClipUIContainer.this.scrollRectToVisible(newVisible);
        }
    }

    public class YScalesPanel
    extends JPanel {
        private static final long serialVersionUID = -1804157337370209591L;

        public YScalesPanel() {
            super(null);
        }

        @Override
        public Dimension getMinimumSize() {
            Component[] comps;
            int maxWidth = 0;
            int maxY = 0;
            for (Component c : comps = this.getComponents()) {
                int cMaxY;
                Rectangle b = c.getBounds();
                if (b.width > maxWidth) {
                    maxWidth = b.width;
                }
                if ((cMaxY = b.y + b.height) <= maxY) continue;
                maxY = cMaxY;
            }
            Dimension minSize = new Dimension(maxWidth, maxY);
            return minSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void doLayout() {
            int cWidth;
            Component[] comps;
            int minWidth = 0;
            for (Component c : comps = this.getComponents()) {
                cWidth = 0;
                if (c.isVisible()) {
                    cWidth = c.getPreferredSize().width;
                }
                if (cWidth <= minWidth) continue;
                minWidth = cWidth;
            }
            for (Component c : comps) {
                cWidth = c.getWidth();
                Point l = c.getLocation();
                int alignedX = minWidth - cWidth;
                int w = 0;
                int h = 0;
                if (c.isVisible()) {
                    Dimension ps = c.getPreferredSize();
                    w = ps.width;
                    h = ps.height;
                }
                c.setBounds(alignedX, l.y, w, h);
            }
        }
    }

    public class ShowPluginControlComponentAction
    extends AbstractActionLeaf {
        private Plugin plugin;

        public ShowPluginControlComponentAction(Component parent, Plugin plugin, LocalizableMessage displayMessage) {
            super(displayMessage);
            this.plugin = plugin;
        }

        public void actionPerformed(ActionEvent arg0) {
            this.plugin.getClipUI().showJControlDialog(AudioClipUIContainer.this.parent);
        }
    }

    public class TogglePluginAction
    extends CheckActionLeaf
    implements ComponentListener {
        private Plugin plugin;

        public TogglePluginAction(Plugin plugin, LocalizableMessage displayMessage) {
            super(displayMessage);
            this.plugin = plugin;
            this.plugin.getClipUI().asComponent().addComponentListener(this);
        }

        public void actionPerformed(ActionEvent arg0) {
            this.plugin.setVisible(this.isSelected());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.setSelected(false);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.setSelected(true);
        }
    }

    public class ToggleXScaleVisibilityAction
    extends CheckActionLeaf {
        public ToggleXScaleVisibilityAction() {
            super(new LocalizableMessage("Time scale"));
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipUIContainer.this.setXScaleVisible(this.isSelected());
        }
    }

    public class CancelSelectionAction
    extends AbstractActionLeaf {
        public CancelSelectionAction(LocalizableMessage displayMessage) {
            super(displayMessage);
        }

        public void actionPerformed(ActionEvent arg0) {
            if (AudioClipUIContainer.this.audioClip != null) {
                AudioClipUIContainer.this.audioClip.setSelection(null);
            }
        }
    }

    public class XZoomFixFitToPanelAction
    extends CheckActionLeaf {
        public XZoomFixFitToPanelAction(LocalizableMessage displayMessage) {
            super(displayMessage);
        }

        public void actionPerformed(ActionEvent arg0) {
            boolean sel = this.isSelected();
            AudioClipUIContainer.this.setFixXZoomFitToPanel(sel);
        }
    }

    public class XZoomToSelectionAction
    extends AbstractActionLeaf {
        public XZoomToSelectionAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipUIContainer.this.xZoomToSelection();
        }
    }

    public class XZoomOnePixelPerSampleAction
    extends AbstractActionLeaf {
        public XZoomOnePixelPerSampleAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipUIContainer.this.xZoomOnePixelPerSample();
        }
    }

    public class XZoomFitToPanelAction
    extends AbstractActionLeaf {
        public XZoomFitToPanelAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipUIContainer.this.setFixXZoomFitToPanel(false);
            AudioClipUIContainer.this.xZoomFitToPanel();
        }
    }

    public class XZoomOutAction
    extends AbstractActionLeaf {
        public XZoomOutAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipUIContainer.this.setFixXZoomFitToPanel(false);
            AudioClipUIContainer.this.setXZoom(AudioClipUIContainer.this.getXZoom() / 2.0);
        }
    }

    public class XZoomInAction
    extends AbstractActionLeaf {
        public XZoomInAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioClipUIContainer.this.setFixXZoomFitToPanel(false);
            AudioClipUIContainer.this.setXZoom(AudioClipUIContainer.this.getXZoom() * 2.0);
        }
    }

    public class Plugin {
        private TogglePluginAction togglePluginAction;
        private ShowPluginControlComponentAction showPluginControlComponentAction;
        private AudioClipUI clipUI;

        public Plugin(AudioClipUI clipUI, JComponent container) {
            this.clipUI = clipUI;
            this.togglePluginAction = new TogglePluginAction(this, clipUI.getLocalizableName());
            if (clipUI.hasControlDialog()) {
                LocalizableMessage lm = new LocalizableMessage(clipUI.getLocalizableName().localize() + " control...");
                this.showPluginControlComponentAction = new ShowPluginControlComponentAction(container, this, lm);
            }
        }

        public AudioClipUI getClipUI() {
            return this.clipUI;
        }

        public boolean isVisible() {
            return this.clipUI.asComponent().isVisible();
        }

        public void setVisible(boolean visible) {
            this.clipUI.asComponent().setVisible(visible);
            if (this.togglePluginAction != null) {
                this.togglePluginAction.setSelected(visible);
            }
        }

        public TogglePluginAction getTogglePluginAction() {
            return this.togglePluginAction;
        }

        public ShowPluginControlComponentAction getShowPluginControlComponentAction() {
            return this.showPluginControlComponentAction;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AudioClipUIContainer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                AudioClipUIContainer.this.getParent().dispatchEvent(e);
            }
        }
    }
}

