/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.capture;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.LimitLengthAudioInputStream;
import ipsk.audio.capture.CaptureException;
import ipsk.audio.capture.CaptureListener;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.audio.capture.TargetDataLineInputStream;
import ipsk.audio.capture.event.CaptureCloseEvent;
import ipsk.audio.capture.event.CaptureErrorEvent;
import ipsk.audio.capture.event.CaptureEvent;
import ipsk.audio.capture.event.CaptureOpenEvent;
import ipsk.audio.capture.event.CaptureRecordedEvent;
import ipsk.audio.capture.event.CaptureStartCaptureEvent;
import ipsk.audio.capture.event.CaptureStartRecordEvent;
import ipsk.audio.capture.event.CaptureStopEvent;
import ipsk.audio.capture.event.CaptureStoppedEvent;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.LevelMeasureAudioInputStream;
import ipsk.audio.tools.FrameUnitParser;
import ipsk.audio.utils.AudioFormatUtils;
import ipsk.util.EventQuequeListener;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class Capture
implements Runnable,
EventQuequeListener {
    private static final boolean DEBUG = false;
    private static final Float STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    private static String[] LARGE_BUFFER_SIZE_CAPABLE_LINE_CLASS_NAMES = new String[]{"ips.audio.ds.DSTargetDataLine", "ips.audio.coreaudio.CoreAudioTargetDataLine"};
    private static final boolean USE_JS_LINE_FRAME_POSITION = false;
    public static final int CLOSE = 0;
    public static final int STOP = 1;
    public static final int CAPTURE = 2;
    public static final int RECORD = 3;
    public static final int PAUSE = 4;
    public static final int ERROR = -1;
    public static AudioFileFormat.Type DEF_AUDIO_FILE_TYPE = AudioFileFormat.Type.WAVE;
    public static AudioFormat DEF_AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);
    public static AudioFileFormat DEF_AUDIO_FILE_FORMAT = new AudioFileFormat(AudioFileFormat.Type.WAVE, DEF_AUDIO_FORMAT, -1);
    private static final int DEF_PREFERRED_BUFFER_SIZE = 8092;
    private TargetDataLine line;
    private Mixer device;
    private AudioInputStream tdlAis;
    private AudioInputStream ais;
    private TargetDataLineInputStream tdlis;
    private File recFile;
    private AudioFileFormat.Type fileType;
    private Long maxFrameLength = null;
    private Thread thread;
    private volatile boolean running;
    private AudioFormat format;
    private int frameSize;
    private DataLine.Info lineInfo;
    private Object streamNotify;
    private volatile int status;
    private Vector<CaptureListener> listeners;
    private boolean measureLevel = true;
    private volatile long streamPosOffset;
    private volatile long streamFramePosition;
    private boolean captureOnly;
    private int bufferSize;
    private int preferredBufferSize;
    private Integer preferredLineBufferSize = null;
    private Integer lineBufferSize = null;
    private HashSet<String> largeBufferSizeCapableLineClassNames;
    private int channels;
    private LevelInfo[] levelInfos;
    private Float preferredLineBufferSizeMillis;
    private boolean useAWTEventThread = true;
    private boolean forceOpening = false;
    private PrimaryRecordTarget primaryRecordTarget = null;
    private File tempRecFile;

    public boolean isUseTempFile() {
        return PrimaryRecordTarget.TEMP_RAW_FILE.equals((Object)this.primaryRecordTarget);
    }

    public void setUseTempFile(boolean useTempFile) {
        if (!useTempFile) {
            if (PrimaryRecordTarget.TEMP_RAW_FILE.equals((Object)this.primaryRecordTarget)) {
                this.primaryRecordTarget = null;
            }
        } else {
            this.primaryRecordTarget = PrimaryRecordTarget.TEMP_RAW_FILE;
        }
    }

    public Capture() {
        this(null);
    }

    public Capture(Mixer device) {
        this.device = device;
        this.preferredBufferSize = 8092;
        this.streamNotify = new Object();
        this.listeners = new Vector();
        this.setAudioFileFormat(DEF_AUDIO_FILE_FORMAT);
        this.resetPeakHold();
        this.streamPosOffset = 0L;
        this.status = 0;
        this.captureOnly = false;
        this.largeBufferSizeCapableLineClassNames = new HashSet<String>(Arrays.asList(LARGE_BUFFER_SIZE_CAPABLE_LINE_CLASS_NAMES));
    }

    public Capture(Mixer device, File recFile, AudioFileFormat aff) {
        this(device);
        this.recFile = recFile;
        this.setAudioFileFormat(aff);
    }

    public void setAudioFileFormat(AudioFileFormat aff) {
        this.format = aff.getFormat();
        this.fileType = aff.getType();
        this.setAudioFormat(aff.getFormat());
    }

    public AudioFileFormat getAudioFileFormat() {
        return new AudioFileFormat(this.fileType, this.format, -1);
    }

    public void setAudioFormat(AudioFormat af) {
        this.format = af;
        this.frameSize = this.format.getFrameSize();
        this.channels = this.format.getChannels();
        if (this.levelInfos != null && this.levelInfos.length != this.channels) {
            this.levelInfos = null;
        }
        this.lineInfo = new DataLine.Info(TargetDataLine.class, this.format);
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public Integer getMinLineBufferSize() {
        if (this.lineInfo == null) {
            return null;
        }
        return this.lineInfo.getMinBufferSize();
    }

    public Integer getMaxLineBufferSize() {
        if (this.lineInfo == null) {
            return null;
        }
        return this.lineInfo.getMaxBufferSize();
    }

    public synchronized void open() throws CaptureException {
        if (this.status != 0) {
            return;
        }
        int bufferFrames = this.preferredBufferSize / this.frameSize;
        this.bufferSize = bufferFrames * this.frameSize;
        if (this.line == null) {
            if (this.device == null) {
                try {
                    this.line = (TargetDataLine)AudioSystem.getLine(this.lineInfo);
                }
                catch (LineUnavailableException e) {
                    throw new CaptureException("Could not get line from audio system: ", e);
                }
                catch (IllegalArgumentException e) {
                    throw new CaptureException(e);
                }
            }
            try {
                this.line = (TargetDataLine)this.device.getLine(this.lineInfo);
            }
            catch (LineUnavailableException e) {
                throw new CaptureException("Could not get line from device: ", e);
            }
            catch (IllegalArgumentException e) {
                if (this.forceOpening) {
                    Line[] lines;
                    for (Line l : lines = this.device.getTargetLines()) {
                        if (!(l instanceof TargetDataLine)) continue;
                        this.line = (TargetDataLine)l;
                        break;
                    }
                    if (this.line == null) {
                        throw new CaptureException(e);
                    }
                }
                throw new CaptureException(e);
            }
        }
        try {
            Integer requestedLinebufferSize = null;
            if (this.preferredLineBufferSize != null) {
                requestedLinebufferSize = this.preferredLineBufferSize;
            } else if (this.preferredLineBufferSizeMillis != null) {
                float preferredLimitedLineBufferSizeMillis = this.preferredLineBufferSizeMillis.floatValue();
                requestedLinebufferSize = AudioFormatUtils.pcmSizeInBytesFromLength(this.format, preferredLimitedLineBufferSizeMillis / 1000.0f);
            }
            if (requestedLinebufferSize != null) {
                Class<?> lineClass;
                String lineClassName;
                float requestedLineBufferSizeInMillis = AudioFormatUtils.pcmLengthFromByteLength(this.format, requestedLinebufferSize) * 1000.0f;
                if (requestedLineBufferSizeInMillis > STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS.floatValue() && !this.largeBufferSizeCapableLineClassNames.contains(lineClassName = (lineClass = this.line.getClass()).getName())) {
                    requestedLinebufferSize = AudioFormatUtils.pcmSizeInBytesFromLength(this.format, STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS.floatValue() / 1000.0f);
                }
                this.line.open(this.format, requestedLinebufferSize);
            } else {
                this.line.open(this.format);
            }
            this.lineBufferSize = this.line.getBufferSize();
            this.line.flush();
        }
        catch (LineUnavailableException e1) {
            throw new CaptureException("Could not open line: " + e1.getMessage(), e1);
        }
        catch (Exception e) {
            throw new CaptureException("Could not open line: " + e.getMessage(), e);
        }
        this.tdlis = new TargetDataLineInputStream(this.line);
        this.ais = this.tdlAis = new AudioInputStream(this.tdlis, this.format, -1L);
        if (this.maxFrameLength != null && this.maxFrameLength != -1L) {
            LimitLengthAudioInputStream llais = new LimitLengthAudioInputStream(this.ais, this.maxFrameLength);
            this.ais = llais;
        }
        if (this.measureLevel) {
            try {
                LevelMeasureAudioInputStream lmais = new LevelMeasureAudioInputStream(this.ais, this.levelInfos);
                this.levelInfos = lmais.getLevelInfos();
                this.ais = lmais;
            }
            catch (AudioFormatNotSupportedException e) {
                throw new CaptureException(e);
            }
        }
        if (this.isUseTempFile()) {
            try {
                this.tempRecFile = File.createTempFile(this.getClass().getName(), ".raw");
                this.tempRecFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        }
        this.running = true;
        this.status = 1;
        this.syncPosition();
        if (System.getProperty("debug.sinustest") != null) {
            // empty if block
        }
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Audio-Capture");
            this.thread.setPriority(10);
            this.thread.start();
        }
        this.sendEventAndWait(new CaptureOpenEvent(this));
    }

    private void sendEventAndWait(EventObject eo) {
        if (!this.useAWTEventThread || EventQueue.isDispatchThread()) {
            this.update(eo);
        } else {
            EventSender es = new EventSender(eo);
            try {
                EventQueue.invokeAndWait(es);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendEvent(EventObject eo) {
        if (!this.useAWTEventThread || EventQueue.isDispatchThread()) {
            this.update(eo);
        } else {
            EventSender es = new EventSender(eo);
            EventQueue.invokeLater(es);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.line.start();
        if (this.status != 3 && this.status != 2) {
            this.status = this.captureOnly ? 2 : 3;
            Object object = this.streamNotify;
            synchronized (object) {
                this.streamNotify.notifyAll();
            }
            if (this.status == 2) {
                this.sendEventAndWait(new CaptureStartCaptureEvent(this));
            } else {
                this.sendEventAndWait(new CaptureStartRecordEvent(this));
            }
        }
    }

    public long getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public synchronized void pause() {
        if (this.line != null) {
            if (this.status == 3) {
                this.line.stop();
            } else if (this.status == 1) {
                this.line.start();
            }
        }
    }

    public synchronized void stop() throws CaptureException {
        if (this.status != 1 && this.status != 0) {
            int oldStatus = this.status;
            this.status = 1;
            this.tdlis.stop();
            if (this.line != null) {
                this.line.stop();
            }
            if (oldStatus == 2) {
                this.sendEventAndWait(new CaptureStoppedEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void close() throws CaptureException {
        if (this.status == 0) {
            return;
        }
        this.stop();
        this.running = false;
        Object object = this.streamNotify;
        // MONITORENTER : object
        this.streamNotify.notifyAll();
        // MONITOREXIT : object
        if (this.thread != null) {
            try {
                this.thread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        try {
            if (this.ais == null) return;
            this.ais.close();
            return;
        }
        catch (IOException e) {
            throw new CaptureException(e);
        }
        finally {
            try {
                if (this.tdlAis != null) {
                    this.tdlAis.close();
                }
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
            finally {
                if (this.line != null) {
                    this.line.flush();
                    this.line.close();
                }
                this.line = null;
                if (this.isUseTempFile() && this.tempRecFile != null) {
                    this.tempRecFile.delete();
                }
                this.status = 0;
                this.sendEventAndWait(new CaptureCloseEvent(this));
            }
        }
    }

    public long getFramePosition() {
        if (this.tdlis == null) {
            return 0L;
        }
        return this.tdlis.getFramePosition() - this.streamPosOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        while (this.running) {
            while (this.running && this.status != 3 && this.status != 2) {
                Object object = this.streamNotify;
                synchronized (object) {
                    try {
                        this.streamNotify.wait(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            IOException exception = null;
            while (this.status == 2) {
                try {
                    this.ais.read(buffer);
                }
                catch (IOException e) {
                    this.sendEvent(new CaptureErrorEvent(this, e));
                }
            }
            if (this.status != 3) continue;
            this.syncPosition();
            if (this.isUseTempFile()) {
                FileOutputStream tmpOs;
                block37: {
                    tmpOs = null;
                    try {
                        tmpOs = new FileOutputStream(this.tempRecFile);
                        int read = 0;
                        while ((read = this.ais.read(buffer)) != -1) {
                            tmpOs.write(buffer, 0, read);
                        }
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    if (tmpOs != null) {
                        try {
                            tmpOs.close();
                        }
                        catch (IOException e1) {
                            tmpOs = null;
                            if (exception != null) break block37;
                            exception = e1;
                        }
                    }
                }
                this.running = false;
                if (this.status != 1 && this.status != 0) {
                    this.status = 1;
                    if (this.line != null) {
                        this.line.stop();
                    }
                }
                if (exception != null) {
                    this.sendEvent(new CaptureErrorEvent(this, exception));
                    System.err.println(exception.getLocalizedMessage());
                    return;
                }
                if (tmpOs != null) {
                    block38: {
                        FileInputStream tmpIs = null;
                        try {
                            tmpIs = new FileInputStream(this.tempRecFile);
                            int frameSize = this.format.getFrameSize();
                            long fileLength = this.tempRecFile.length();
                            long frameLength = fileLength / (long)frameSize;
                            AudioInputStream tmpAis = new AudioInputStream(tmpIs, this.format, frameLength);
                            AudioSystem.write(tmpAis, this.fileType, this.recFile);
                        }
                        catch (IOException e) {
                            exception = e;
                        }
                        if (tmpIs != null) {
                            try {
                                tmpIs.close();
                            }
                            catch (IOException e) {
                                if (exception != null) break block38;
                                exception = e;
                            }
                        }
                    }
                    if (exception != null) {
                        this.sendEvent(new CaptureErrorEvent(this, exception));
                        System.err.println(exception.getLocalizedMessage());
                        return;
                    }
                }
            } else {
                try {
                    AudioSystem.write(this.ais, this.fileType, this.recFile);
                }
                catch (IOException e) {
                    try {
                        File tmp = File.createTempFile("speechrecorder", this.fileType.getExtension());
                        tmp.deleteOnExit();
                        AudioInputStream tmpAis = AudioSystem.getAudioInputStream(this.recFile);
                        AudioSystem.write(tmpAis, this.fileType, tmp);
                        tmpAis.close();
                        AudioInputStream tmpAis2 = AudioSystem.getAudioInputStream(tmp);
                        AudioSystem.write(tmpAis2, this.fileType, this.recFile);
                        tmpAis2.close();
                        tmp.delete();
                    }
                    catch (Exception repairException) {
                        this.recFile.delete();
                    }
                    this.sendEvent(new CaptureErrorEvent(this, e));
                    System.err.println(e.getLocalizedMessage());
                    return;
                }
                finally {
                    this.running = false;
                    if (this.status != 1 && this.status != 0) {
                        this.status = 1;
                        if (this.line != null) {
                            this.line.stop();
                        }
                    }
                }
            }
            this.sendEvent(new CaptureRecordedEvent(this));
        }
    }

    private void syncPosition() {
        if (this.line == null) {
            this.streamPosOffset = 0L;
            return;
        }
        this.streamPosOffset = this.line.getLongFramePosition() - this.streamFramePosition;
    }

    public synchronized void addCaptureListener(CaptureListener cl) {
        if (cl != null && !this.listeners.contains(cl)) {
            this.listeners.addElement(cl);
        }
    }

    public synchronized void removeCaptureListener(CaptureListener cl) {
        if (cl != null) {
            this.listeners.removeElement(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(EventObject eventObject) {
        Vector<CaptureListener> vector = this.listeners;
        synchronized (vector) {
            for (CaptureListener listener : this.listeners) {
                listener.update((CaptureEvent)eventObject);
            }
        }
    }

    public void setMeasureLevel(boolean b) {
        this.measureLevel = b;
    }

    public LevelInfo[] getLevelInfos() {
        if (this.ais != null && this.ais instanceof LevelMeasureAudioInputStream) {
            return ((LevelMeasureAudioInputStream)this.ais).getLevelInfos();
        }
        return this.levelInfos;
    }

    public boolean isRecording() {
        return this.status == 3;
    }

    public boolean isCapturing() {
        return this.status == 2;
    }

    public void setRecordingFile(File file) {
        this.recFile = file;
    }

    public File getRecordingFile() {
        return this.recFile;
    }

    public void setMixer(Mixer newCaptureMixer) {
        this.device = newCaptureMixer;
    }

    public boolean isCaptureOnly() {
        return this.captureOnly;
    }

    public void setCaptureOnly(boolean captureOnly) {
        this.captureOnly = captureOnly;
        if (this.status == 2 && !captureOnly) {
            this.status = 3;
            this.sendEventAndWait(new CaptureStartRecordEvent(this));
        } else if (this.status == 3 && captureOnly) {
            this.status = 2;
            this.sendEventAndWait(new CaptureStartCaptureEvent(this));
        }
    }

    public Integer getPreferredBufferSize() {
        return this.preferredBufferSize;
    }

    public void setPreferredBufferSize(int preferredBufferSize) {
        this.preferredBufferSize = preferredBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public float[] getPeakLevelHold() {
        if (this.ais != null && this.ais instanceof LevelMeasureAudioInputStream) {
            return ((LevelMeasureAudioInputStream)this.ais).getPeakLevelHold();
        }
        return null;
    }

    public void resetPeakHold() {
        if (this.levelInfos != null) {
            for (int ch = 0; ch < this.channels; ++ch) {
                this.levelInfos[ch].setPeakLevelHold(0.0f);
            }
        }
    }

    public Integer getPreferredLineBufferSize() {
        return this.preferredLineBufferSize;
    }

    public void setPreferredLineBufferSize(Integer preferredLineBufferSize) {
        this.preferredLineBufferSizeMillis = null;
        this.preferredLineBufferSize = preferredLineBufferSize;
    }

    public Integer getLineBufferSize() {
        return this.lineBufferSize;
    }

    public Float getLineBufferSizeSeconds() {
        Integer lineBufferSize = this.getLineBufferSize();
        if (lineBufferSize == null || this.format == null) {
            return null;
        }
        float framerate = this.format.getFrameRate();
        if (framerate == -1.0f) {
            return null;
        }
        int frameSize = this.format.getFrameSize();
        if (frameSize == -1) {
            return null;
        }
        int lineBufferFrames = lineBufferSize / frameSize;
        return Float.valueOf((float)lineBufferFrames / framerate);
    }

    public boolean isOpen() {
        return this.status != 0;
    }

    public Float getPreferredLineBufferSizeMillis() {
        return this.preferredLineBufferSizeMillis;
    }

    public void setPreferredLineBufferSizeMillis(Float preferredLineBufferSizeMillis) {
        this.preferredLineBufferSize = null;
        this.preferredLineBufferSizeMillis = preferredLineBufferSizeMillis;
    }

    public boolean isUseAWTEventThread() {
        return this.useAWTEventThread;
    }

    public void setUseAWTEventThread(boolean useAWTEventThread) {
        this.useAWTEventThread = useAWTEventThread;
    }

    public void setMaxFrameLength(long maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    private static void printUsage() {
        System.out.println("Audio recorder version " + Capture.class.getPackage().getImplementationVersion() + "\nRecords audio from standard audio input device to recordingfilename.\nUsage: java " + Capture.class.getName() + " [-length recordingtime] recordingfilename\nWithout option the program records until the program terminates (by Ctrl-C)\nOptions:\n       -length recordingtime:\n       Stop recording after recordingtime.\n       \n       -overwrite\n       force  overwrite existing recording file.\n\nNote: Recording time value must can be given in audio frames (without unit)\n      in seconds (with unit \"s\") or in milliseconds (unit \"ms\").\n      units must be directly appended to the value (no blank)Examples:\njava " + Capture.class.getName() + " record.wav\nRecords to file record.wav. Recording can be stopped by Ctrl-C.\njava " + Capture.class.getName() + " -length 44100 record.wav\nRecords 44100 frames (samples) to file record.wav\njava " + Capture.class.getName() + " -v -overwrite -length 1s record.wav\nRecords 1 second to file record.wav, overrides record.wav if it exists and shows verbose messages\n");
    }

    public static void main(String[] args) {
        OptionParser op = new OptionParser();
        Option overwriteOption = new Option("overwrite");
        Option recTimeOption = new Option("length", null);
        Option verboseOption = new Option("v");
        Option helpOption = new Option("h");
        op.addOption(verboseOption);
        op.addOption(helpOption);
        op.addOption(recTimeOption);
        op.addOption(overwriteOption);
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(-1);
        }
        if (helpOption.isSet()) {
            Capture.printUsage();
            System.exit(0);
        }
        final boolean verbose = verboseOption.isSet();
        Capture c = new Capture();
        c.setUseAWTEventThread(false);
        c.setMeasureLevel(false);
        String recordingTime = null;
        File recFile = null;
        boolean overwrite = false;
        overwrite = overwriteOption.isSet();
        recordingTime = recTimeOption.getParam();
        String[] params = op.getParams();
        if (params.length == 0) {
            Capture.printUsage();
            System.exit(-1);
        } else if (params.length == 1) {
            try {
                URL url = new URL(params[0]);
                String urlProto = url.getProtocol();
                if (!urlProto.equalsIgnoreCase("file")) {
                    System.err.println("Only file protocol URL's are supported");
                    System.exit(-1);
                }
                recFile = new File(url.toURI().getPath());
            }
            catch (MalformedURLException e1) {
                recFile = new File(params[0]);
            }
            catch (URISyntaxException e) {
                recFile = new File(params[0]);
            }
        }
        if (verbose) {
            System.out.println("Audio recorder version " + Capture.class.getPackage().getImplementationVersion() + "\n");
        }
        if (!overwrite && recFile.exists()) {
            System.err.println("Recording file exists. Exiting.\nUse overwrite option to force overwrite.");
            System.exit(-1);
        }
        c.setRecordingFile(recFile);
        CaptureListener cl = null;
        Shutdown shutDown = new Shutdown(c, verbose);
        cl = new CaptureListener(){

            @Override
            public void update(CaptureEvent captureEvent) {
                if (captureEvent instanceof CaptureStopEvent && verbose) {
                    System.out.println("Capture stopped.");
                }
                if (captureEvent instanceof CaptureCloseEvent && verbose) {
                    System.out.println("Capture closed.");
                }
            }
        };
        c.addCaptureListener(cl);
        Runtime.getRuntime().addShutdownHook(shutDown);
        if (recordingTime != null) {
            FrameUnitParser fup = new FrameUnitParser(c.getAudioFormat().getFrameRate());
            long frameLength = fup.parseFrameUnitString(recordingTime);
            c.setMaxFrameLength(frameLength);
        }
        try {
            c.open();
            if (verbose) {
                System.out.println("Capture open.");
            }
        }
        catch (CaptureException e1) {
            System.err.println("Could not open capture engine:");
            e1.printStackTrace();
            System.exit(-1);
        }
        c.start();
        if (verbose) {
            System.out.println("Capture started.");
        }
        if (verbose && !recTimeOption.isSet()) {
            System.out.println("Press Ctrl-C to stop.");
        }
    }

    public boolean isForceOpening() {
        return this.forceOpening;
    }

    public void setForceOpening(boolean forceOpening) {
        this.forceOpening = forceOpening;
    }

    public PrimaryRecordTarget getPrimaryRecordTarget() {
        return this.primaryRecordTarget;
    }

    public void setPrimaryRecordTarget(PrimaryRecordTarget primaryRecordTarget) {
        this.primaryRecordTarget = primaryRecordTarget;
    }

    private static class Shutdown
    extends Thread {
        private Capture c;
        private boolean verbose;

        public Shutdown(Capture c, boolean verbose) {
            this.c = c;
            this.verbose = verbose;
        }

        @Override
        public void run() {
            block5: {
                if (this.verbose) {
                    System.out.println("Shutdown ...");
                }
                try {
                    if (this.c.isOpen()) {
                        if (this.verbose) {
                            System.out.println("Capture closing...");
                        }
                        this.c.close();
                    }
                }
                catch (CaptureException e) {
                    System.err.println("Could not close capture engine !");
                    if (!this.verbose) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    private class EventSender
    implements Runnable {
        private final EventObject eo;

        public EventSender(EventObject eo) {
            this.eo = eo;
        }

        @Override
        public void run() {
            Capture.this.update(this.eo);
        }
    }
}

