/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioPluginException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.SourcePlugin;
import ipsk.audio.plugins.BasicPCMSignedAndFloatPlugin;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AppendPlugin
extends BasicPCMSignedAndFloatPlugin
implements SourcePlugin {
    private AudioSource insertSource;
    private AudioFormat af;
    private long frameLength;

    public AppendPlugin(AudioSource appendSource) {
        this.insertSource = appendSource;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream ais) throws AudioPluginException {
        AudioInputStream insertAis;
        try {
            insertAis = this.insertSource.getAudioInputStream();
        }
        catch (AudioSourceException e) {
            throw new AudioPluginException(e);
        }
        this.frameLength = ais.getFrameLength() + insertAis.getFrameLength();
        this.af = ais.getFormat();
        AudioFormat insertAf = insertAis.getFormat();
        if (!this.af.matches(insertAf)) {
            throw new AudioPluginException("Insert audio format does not match !");
        }
        SequenceInputStream sis = new SequenceInputStream(ais, insertAis);
        return new AudioInputStream(sis, this.af, this.frameLength);
    }

    @Override
    public AudioSource getAudioSource() {
        return this.insertSource;
    }
}

