/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioPluginException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;

public class EncodingPlugin
implements AudioPlugin {
    protected AudioFormat[] supportedAudioFormats;
    protected AudioFormat inputFormat;
    protected AudioFormat outputFormat = null;
    protected AudioFormat.Encoding[] encodings;

    public EncodingPlugin(AudioFormat.Encoding encoding) {
        this(new AudioFormat.Encoding[]{encoding});
    }

    public EncodingPlugin(AudioFormat.Encoding[] encodings) {
        this.encodings = encodings;
        this.supportedAudioFormats = new AudioFormat[0];
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream source) throws AudioPluginException {
        AudioFormat srcAf = source.getFormat();
        AudioFormat.Encoding srcEnc = srcAf.getEncoding();
        for (AudioFormat.Encoding encoding : this.encodings) {
            if (!srcEnc.equals(encoding)) continue;
            return source;
        }
        if (this.outputFormat == null) {
            return AudioSystem.getAudioInputStream(this.encodings[0], source);
        }
        return AudioSystem.getAudioInputStream(this.outputFormat, source);
    }

    @Override
    public AudioFormat[] getSupportedInputFormats() {
        return this.supportedAudioFormats;
    }

    @Override
    public AudioFormat[] getSupportedOutputFormats(AudioFormat inputFormat) {
        return new AudioFormat[0];
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public boolean isInputFormatSupported(AudioFormat audioFormat) {
        for (AudioFormat.Encoding encoding : this.encodings) {
            boolean supp = AudioSystem.isConversionSupported(encoding, audioFormat);
            if (!supp) continue;
            return supp;
        }
        return false;
    }

    @Override
    public boolean isOutputFormatSupported(AudioFormat inputFormat, AudioFormat outputFormat) {
        if (!this.isInputFormatSupported(inputFormat)) {
            return false;
        }
        AudioFormat.Encoding outputEnc = outputFormat.getEncoding();
        boolean supp = false;
        for (AudioFormat.Encoding encoding : this.encodings) {
            if (!outputEnc.equals(encoding)) continue;
            supp = true;
            break;
        }
        if (!supp) {
            return false;
        }
        return AudioSystem.isConversionSupported(outputFormat, inputFormat);
    }

    @Override
    public void setInputFormat(AudioFormat inputFormat) throws AudioFormatNotSupportedException {
        if (!this.isInputFormatSupported(inputFormat)) {
            throw new AudioFormatNotSupportedException(inputFormat);
        }
        this.inputFormat = inputFormat;
    }

    @Override
    public AudioFormat getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public void setOutputFormat(AudioFormat outputFormat) throws AudioFormatNotSupportedException {
        if (!this.isOutputFormatSupported(this.inputFormat, outputFormat)) {
            throw new AudioFormatNotSupportedException(outputFormat);
        }
        this.outputFormat = outputFormat;
    }

    @Override
    public AudioFormat getOutputFormat() {
        int fmtCnt;
        AudioFormat[] formats;
        if (this.outputFormat != null) {
            return this.outputFormat;
        }
        ArrayList<AudioFormat> fmtsList = new ArrayList<AudioFormat>();
        if (this.inputFormat != null) {
            for (AudioFormat.Encoding encoding : this.encodings) {
                AudioFormat[] fmts = AudioSystem.getTargetFormats(encoding, this.inputFormat);
                fmtsList.addAll(Arrays.asList(fmts));
            }
        }
        if ((formats = fmtsList.toArray(new AudioFormat[fmtCnt = fmtsList.size()])) != null && formats.length > 0) {
            return formats[0];
        }
        return this.inputFormat;
    }
}

