//    IPS Java Audio Tools
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Audio Tools
//
//
//    IPS Java Audio Tools is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Audio Tools is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Audio Tools.  If not, see <http://www.gnu.org/licenses/>.

/*
 * Date  : Jul 16, 2004
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.audio;

import java.awt.datatransfer.DataFlavor;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

/**
 * A source for audio streams.
 * 
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
public interface AudioSource {
	public static final DataFlavor DATA_FLAVOR = new DataFlavor(AudioSource.class,
			"Audio source");

    /**
     * Returns a new audio input stream.
     * 
     * @return a new audio input stream
     * @throws AudioSourceException audio source exception
     */
    public AudioInputStream getAudioInputStream() throws AudioSourceException;
    public long getFrameLength() throws AudioSourceException;
    public AudioFormat getFormat() throws AudioSourceException;

}
