//    IPS Java Audio Tools
// 	  (c) Copyright 2015
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Audio Tools
//
//
//    IPS Java Audio Tools is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Audio Tools is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Audio Tools.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.audio.dsp.speech;

import java.util.EventObject;

/**
 * @author klausj
 *
 */
public class SpeechFinalSilenceDetectorEvent extends EventObject {

	private static final long serialVersionUID = -6412671001536900902L;
	private boolean finalSilenceDetected=true;
	
	/**
	 * @return true if final silence was detected
	 */
	public boolean isFinalSilenceDetected() {
		return finalSilenceDetected;
	}

	/**
	 * @param source source object
	 */
	public SpeechFinalSilenceDetectorEvent(Object source) {
		super(source);
	}

}
