package ipsk.audio.plugins;

import java.util.Arrays;
import java.util.stream.Stream;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

import ipsk.audio.AudioPluginException;

public abstract class BasicPCMSignedAndFloatPlugin extends BasicPCMPlugin {

	protected AudioFormat[] supportedFloatAudioFormats;
	
	protected AudioFormat[] allSupportedAudioFormats;
	
	public BasicPCMSignedAndFloatPlugin() {
		super();
		// this plugin additionally supports float encoded files.
		supportedFloatAudioFormats = new AudioFormat[] {
				new AudioFormat(AudioFormat.Encoding.PCM_FLOAT,
						(float) AudioSystem.NOT_SPECIFIED,
						AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED,
						AudioSystem.NOT_SPECIFIED,
						(float) AudioSystem.NOT_SPECIFIED, true),
				new AudioFormat(AudioFormat.Encoding.PCM_FLOAT,
						(float) AudioSystem.NOT_SPECIFIED,
						AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED,
						AudioSystem.NOT_SPECIFIED,
						(float) AudioSystem.NOT_SPECIFIED, false)};
		allSupportedAudioFormats=Stream.concat(Arrays.stream(supportedAudioFormats),Arrays.stream(supportedFloatAudioFormats)).toArray(AudioFormat[]::new);
	}

	@Override
	public abstract  AudioInputStream getAudioInputStream(AudioInputStream source) throws AudioPluginException;
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see ipsk.audio.AudioPlugin#isFormatSupported(javax.sound.sampled.AudioFormat)
	 */
	public boolean isInputFormatSupported(AudioFormat audioFormat) {
		boolean basicSupported=super.isInputFormatSupported(audioFormat);
		if(basicSupported) {
			return basicSupported;
		}else {
			for (int i = 0; i < supportedFloatAudioFormats.length; i++) {
				// AudioFormat.matches() checks AudioSystem.NOT_SPECIFIED
				// only on samplerate and framerate, so we have to write it
				// ourselves
				//			if (audioFormat.matches(supportedAudioFormats[i]))
				AudioFormat suppFormat = supportedFloatAudioFormats[i];
				if (suppFormat.getEncoding().equals(audioFormat.getEncoding())
						&& ((suppFormat.getSampleRate() == (float) AudioSystem.NOT_SPECIFIED) || (suppFormat
								.getSampleRate() == audioFormat.getSampleRate()))
//						&& (suppFormat.getSampleSizeInBits() == AudioSystem.NOT_SPECIFIED || suppFormat
//								.getSampleSizeInBits() == audioFormat
//								.getSampleSizeInBits())
						&& (suppFormat.getChannels() == AudioSystem.NOT_SPECIFIED || suppFormat
								.getChannels() == audioFormat.getChannels()
//								&& (suppFormat.getFrameSize() == AudioSystem.NOT_SPECIFIED || suppFormat
//										.getFrameSize() == audioFormat
//										.getFrameSize())
								&& ((suppFormat.getFrameRate() == (float) AudioSystem.NOT_SPECIFIED) || (suppFormat
										.getFrameRate() == audioFormat
										.getFrameRate()))
//								&& ((suppFormat.getSampleSizeInBits() <= 8) || (suppFormat
//										.isBigEndian() == audioFormat.isBigEndian())))
								)) {
								return true;
							}
			}
		}
		return false;
	}

	
	@Override
	public AudioFormat[] getSupportedInputFormats() {
		return allSupportedAudioFormats;
	}

}
