/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.audioeditor.ui;

import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.awt.StatusBarLayout;
import ipsk.text.MediaTimeFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 126282374634493683L;
    private Border b = BorderFactory.createLoweredBevelBorder();
    private JLabel encodingLabel = new JLabel();
    private JLabel sampleRateLabel;
    private JLabel sampleSizeInBitsLabel;
    private JLabel frameLengthLabel;
    private MediaTimeFormat mtf;
    private AudioFormat audioFormat = null;

    public StatusBar() {
        super((LayoutManager)new StatusBarLayout());
        this.encodingLabel.setBorder(this.b);
        this.encodingLabel.setToolTipText("Encoding");
        this.add((Component)this.encodingLabel, "align left");
        this.sampleRateLabel = new JLabel();
        this.sampleRateLabel.setBorder(this.b);
        this.sampleRateLabel.setToolTipText("Sample rate");
        this.add((Component)this.sampleRateLabel, "align left");
        this.sampleSizeInBitsLabel = new JLabel();
        this.sampleSizeInBitsLabel.setBorder(this.b);
        this.sampleSizeInBitsLabel.setToolTipText("Sample size");
        this.add((Component)this.sampleSizeInBitsLabel, "align left");
        this.frameLengthLabel = new JLabel("Unknown");
        this.frameLengthLabel.setBorder(this.b);
        this.frameLengthLabel.setToolTipText("Length of audio file (hour:min:sec.msec)");
        this.mtf = new MediaTimeFormat();
        this.add((Component)this.frameLengthLabel, "align left");
    }

    public void setAudioClipInfo(AudioClipDSPInfo info) {
        this.setAudioFormat(info.getAudioFormat());
    }

    public void setAudioFormat(AudioFormat af) {
        this.audioFormat = af;
        if (af == null) {
            this.encodingLabel.setText("-");
            this.sampleRateLabel.setText("-");
            this.sampleSizeInBitsLabel.setText("-");
        } else {
            this.encodingLabel.setText(af.getEncoding().toString());
            this.sampleRateLabel.setText(Float.toString(af.getSampleRate()) + " Hz");
            this.sampleSizeInBitsLabel.setText(Integer.toString(af.getSampleSizeInBits()) + " bit");
        }
        this.revalidate();
    }

    public void setFrameLength(long frameLength) {
        Double formatObj = null;
        if (frameLength != (long)ThreadSafeAudioSystem.NOT_SPECIFIED && this.audioFormat != null) {
            double seconds = (float)frameLength / this.audioFormat.getFrameRate();
            formatObj = seconds;
            this.frameLengthLabel.setText(this.mtf.format((Object)formatObj));
        } else {
            this.frameLengthLabel.setText(this.mtf.format(null));
        }
    }

    public void setAudioFileFormat(AudioFileFormat aff) {
        this.setAudioFormat(aff.getFormat());
        this.setFrameLength(aff.getFrameLength());
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)new JLabel("Hello"), "Center");
        f.getContentPane().add((Component)new StatusBar(), "South");
        f.pack();
        f.setVisible(true);
    }
}

