/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

public enum Profile {
    CD_QUALITY("CD quality", 44100.0f, 16, true, null),
    SPEECH_RECORDING("Speech recording", 16000.0f, 16, true, 5000),
    PHONE("Phone quality", 8000.0f, 8, false, null);

    private final float minSampleRate;
    private final int minSampleSizeInBits;
    private final boolean pcmSignedRecommended;
    private final Integer defaultMaxFreqSpectrumView;
    private final String value;

    private Profile(String value, float minSampleRate, int minSampleSizeInBits, boolean pcmSignedRecommended, Integer defaultMaxFreqSpectrumView) {
        this.value = value;
        this.minSampleRate = minSampleRate;
        this.minSampleSizeInBits = minSampleSizeInBits;
        this.pcmSignedRecommended = pcmSignedRecommended;
        this.defaultMaxFreqSpectrumView = defaultMaxFreqSpectrumView;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static Profile getByValue(String value) {
        for (Profile pp : Profile.values()) {
            if (!pp.value.equals(value)) continue;
            return pp;
        }
        return null;
    }

    public float getMinSampleRate() {
        return this.minSampleRate;
    }

    public int getMinSampleSizeInBits() {
        return this.minSampleSizeInBits;
    }

    public boolean isPcmSignedRecommended() {
        return this.pcmSignedRecommended;
    }

    public Integer getDefaultMaxFreqSpectrumView() {
        return this.defaultMaxFreqSpectrumView;
    }
}

