/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ajs.ui;

import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.DeviceSelection;
import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import ipsk.awt.util.gridbaglayout.Gridbag;
import ipsk.awt.util.gridbaglayout.form.FormGridComponentProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class DeviceChooserComponentProvider
implements FormGridComponentProvider,
ActionListener {
    private static final String PROTOTYPE_MIXERNAME = "Audio dummy prototype mixer name foo bla (dummy)";
    private Component parentComponent;
    private JComboBox<InterfaceElement> interfaceTypeSelector;
    private JComboBox<DeviceView> availDevicesSelector;
    private AJSAudioSystem.DeviceType deviceType = null;
    private Gridbag[][] grid = new Gridbag[2][];
    private FormGridComponentProvider.ColumnType[] columnTypes = new FormGridComponentProvider.ColumnType[]{FormGridComponentProvider.ColumnType.LABEL, FormGridComponentProvider.ColumnType.VALUE};
    private Vector<InterfaceElement> interfaces;

    public DeviceChooserComponentProvider(DeviceSelection deviceManager) {
        if (deviceManager != null) {
            this.deviceType = deviceManager.getDeviceType();
        }
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        int mpsdCount = mpsdList.size();
        this.interfaces = new Vector();
        for (int i = 0; i < mpsdCount; ++i) {
            MixerProviderServiceDescriptor mpsd = mpsdList.get(i);
            if (this.deviceType != null && (!AJSAudioSystem.DeviceType.CAPTURE.equals((Object)this.deviceType) || !mpsd.isProvidesCaptureDevices()) && (!AJSAudioSystem.DeviceType.PLAYBACK.equals((Object)this.deviceType) || !mpsd.isProvidesPlaybackDevices())) continue;
            InterfaceElement ie = new InterfaceElement(mpsd);
            this.interfaces.add(ie);
        }
        this.grid[0] = new Gridbag[2];
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        JLabel interfaceTypeLabel = new JLabel("Interface:");
        this.grid[0][0] = new Gridbag((Component)interfaceTypeLabel, c);
        ++c.gridx;
        c.anchor = 17;
        this.interfaceTypeSelector = new JComboBox<InterfaceElement>(this.interfaces);
        if (this.interfaces.size() <= 1) {
            this.interfaceTypeSelector.setEnabled(false);
        }
        this.interfaceTypeSelector.addActionListener(this);
        this.grid[0][1] = new Gridbag(this.interfaceTypeSelector, c);
        this.grid[1] = new Gridbag[2];
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        JLabel deviceLabel = new JLabel("Device:");
        this.grid[1][0] = new Gridbag((Component)deviceLabel, c);
        this.availDevicesSelector = new JComboBox();
        DeviceView protoDv = new DeviceView(PROTOTYPE_MIXERNAME);
        this.availDevicesSelector.setPrototypeDisplayValue(protoDv);
        ++c.gridx;
        c.anchor = 17;
        this.grid[1][1] = new Gridbag(this.availDevicesSelector, c);
        AJSDevice selDevice = null;
        if (deviceManager != null && (selDevice = deviceManager.getDevice()) != null) {
            MixerProviderServiceDescriptor mpsd = selDevice.getMixerproviderServiceDescriptor();
            InterfaceElement ie = new InterfaceElement(mpsd);
            this.interfaceTypeSelector.setSelectedItem(ie);
            Mixer m = selDevice.getMixer();
            Mixer.Info mInfo = null;
            if (m != null) {
                mInfo = m.getMixerInfo();
            }
            this.availDevicesSelector.setSelectedItem(new DeviceView(mInfo));
        }
        if (selDevice == null) {
            int interfacesCount = this.interfaces.size();
            boolean hasDevices = false;
            for (int ii = 0; !hasDevices && ii < interfacesCount; ++ii) {
                InterfaceElement ie = this.interfaces.get(ii);
                hasDevices = this.loadDeviceList(ie);
                if (!hasDevices) continue;
                this.interfaceTypeSelector.setSelectedItem(ie);
                break;
            }
        }
    }

    private boolean loadDeviceList(InterfaceElement ie) {
        boolean hasMatchingDevices = false;
        MixerProviderServiceDescriptor mpsd = ie.getMpsd();
        MixerProvider mp = AJSAudioSystem.getMixerProvider(mpsd);
        this.availDevicesSelector.removeAllItems();
        if (mp != null) {
            List<Mixer.Info> mixerInfosList = null;
            if (this.deviceType == null) {
                Mixer.Info[] miInfos = mp.getMixerInfo();
                mixerInfosList = Arrays.asList(miInfos);
            } else if (AJSAudioSystem.DeviceType.CAPTURE.equals((Object)this.deviceType)) {
                mixerInfosList = AJSAudioSystem.availableCaptureMixerInfos(mpsd);
            } else if (AJSAudioSystem.DeviceType.PLAYBACK.equals((Object)this.deviceType)) {
                mixerInfosList = AJSAudioSystem.availablePlaybackMixerInfos(mpsd);
            }
            if (mixerInfosList != null && mixerInfosList.size() > 0) {
                hasMatchingDevices = true;
                this.availDevicesSelector.setEnabled(true);
                DeviceView defDv = new DeviceView((Mixer.Info)null);
                this.availDevicesSelector.addItem(defDv);
                for (Mixer.Info mi : mixerInfosList) {
                    DeviceView mDv = new DeviceView(mi);
                    this.availDevicesSelector.addItem(mDv);
                }
            } else {
                this.availDevicesSelector.setEnabled(false);
            }
        }
        return hasMatchingDevices;
    }

    public AJSDeviceInfo getSelectedDeviceInfo() {
        InterfaceElement ie = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
        MixerProviderServiceDescriptor mpsd = ie.getMpsd();
        DeviceView dv = (DeviceView)this.availDevicesSelector.getSelectedItem();
        if (dv == null) {
            return null;
        }
        Mixer.Info mixerInfo = dv.getMixerInfo();
        AJSDeviceInfo di = new AJSDeviceInfo(mpsd, mixerInfo);
        return di;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object evSrc = ae.getSource();
        if (evSrc == this.interfaceTypeSelector) {
            InterfaceElement ie = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
            MixerProviderServiceDescriptor mpsd = ie.getMpsd();
            boolean hasDevices = this.loadDeviceList(ie);
            if (!hasDevices) {
                JOptionPane.showMessageDialog(this.parentComponent, "\"" + mpsd.getAudioInterfaceName() + "\" provider provides no devices.", "Audio device warning", 2);
            }
        }
    }

    public Gridbag[][] getGrid() {
        return this.grid;
    }

    public FormGridComponentProvider.ColumnType[] getColumnTypes() {
        return this.columnTypes;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public class InterfaceElement {
        private MixerProviderServiceDescriptor mpsd;

        InterfaceElement(MixerProviderServiceDescriptor mpsd) {
            this.mpsd = mpsd;
        }

        public String toString() {
            return this.mpsd.getAudioInterfaceName();
        }

        public boolean equals(Object o) {
            InterfaceElement oIe;
            if (o == this) {
                return true;
            }
            return o instanceof InterfaceElement && this.mpsd.equals((oIe = (InterfaceElement)o).getMpsd());
        }

        public MixerProviderServiceDescriptor getMpsd() {
            return this.mpsd;
        }
    }

    public class DeviceView {
        private Mixer.Info mixerInfo = null;
        private String protoTypeName = null;

        public DeviceView(Mixer.Info mInfo) {
            this.mixerInfo = mInfo;
        }

        public DeviceView(String protoTypeName) {
            this.protoTypeName = protoTypeName;
        }

        public String toString() {
            if (this.mixerInfo == null) {
                if (this.protoTypeName != null) {
                    return this.protoTypeName;
                }
                return "(Default device)";
            }
            return this.mixerInfo.getName();
        }

        public Mixer.Info getMixerInfo() {
            return this.mixerInfo;
        }

        public boolean equals(Object o) {
            DeviceView oDv;
            Mixer.Info oMi;
            if (o == this) {
                return true;
            }
            return o instanceof DeviceView && ((oMi = (oDv = (DeviceView)o).getMixerInfo()) != null ? oMi.equals(this.mixerInfo) : this.mixerInfo == null);
        }
    }
}

