/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ips.media.MediaLengthUnit;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Marker;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipUI;
import ipsk.awt.TickProvider;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.text.TimeFormat;
import ipsk.util.LocalizableMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Format;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BasicAudioClipUI
extends JPanel
implements AudioClipUI {
    private static final long serialVersionUID = -614132542400613905L;
    public final Color DEFAULT_TIME_GRID_COLOR = Color.YELLOW.darker();
    protected AudioSource audioSource = null;
    protected AudioClip audioSample = null;
    protected int channels;
    protected double lengthInSeconds;
    protected long length;
    protected AudioFormat audioFormat = null;
    protected int frameSize;
    protected double framesPerPixel;
    protected double pixelsPerFrame;
    protected int pixelPosition = 0;
    protected Selection selection = null;
    protected ViewSelection viewSelection = null;
    protected Vector<ActionListener> listenerList;
    protected float sampleRate;
    protected MediaLengthUnit mediaLengthUnit = MediaLengthUnit.FRAMES;
    protected Format timeFormat = TimeFormat.FIXED_SECONDS_MS_TIME_FORMAT;
    protected TickProvider<Long> timeScaleTickProvider;
    protected boolean showTimeScaleGrid = false;

    public boolean isShowTimeScaleGrid() {
        return this.showTimeScaleGrid;
    }

    public void setShowTimeScaleGrid(boolean showTimeScaleGrid) {
        this.showTimeScaleGrid = showTimeScaleGrid;
    }

    public BasicAudioClipUI() {
        this.listenerList = new Vector();
        this.length = ThreadSafeAudioSystem.NOT_SPECIFIED;
    }

    public BasicAudioClipUI(AudioClip audioSample) throws AudioFormatNotSupportedException, AudioSourceException {
        this();
        this.setAudioSample(audioSample);
    }

    protected long mapPixelToFrame(int pixelPosition) {
        return (int)((double)pixelPosition * this.framesPerPixel);
    }

    protected int mapFrameToPixel(long framePosition) {
        return (int)((double)framePosition / this.framesPerPixel);
    }

    protected double framesToTimeInSeconds(long framePosition) {
        return (float)framePosition / this.sampleRate;
    }

    private void reset() {
        this.audioFormat = null;
        this.length = ThreadSafeAudioSystem.NOT_SPECIFIED;
        this.lengthInSeconds = 0.0;
        this.audioSource = null;
    }

    @Override
    public LocalizableMessage getLocalizableName() {
        return new LocalizableMessage(this.getName());
    }

    @Override
    public void setAudioSample(AudioClip audioSample) {
        if (audioSample == this.audioSample) {
            return;
        }
        if (this.audioSample != null) {
            this.audioSample.removeAudioSampleListener(this);
        }
        this.audioSample = audioSample;
        if (audioSample != null) {
            audioSample.addAudioSampleListener(this);
            this.audioClipChanged(new AudioSourceChangedEvent(this, audioSample.getAudioSource()));
        } else {
            this.reset();
            try {
                this.setAudioSource(null);
            }
            catch (AudioSourceException e) {
                JOptionPane.showMessageDialog(this, "Cannot reset audio source: \n" + e.getLocalizedMessage(), "Audio source error", 0);
            }
        }
        this.setSelection();
    }

    protected void setAudioSource(AudioSource audioSource) throws AudioSourceException {
        this.close();
        this.audioSource = audioSource;
        if (audioSource != null) {
            AudioInputStream ais = audioSource.getAudioInputStream();
            this.audioFormat = ais.getFormat();
            this.channels = this.audioFormat.getChannels();
            this.frameSize = this.audioFormat.getFrameSize();
            this.sampleRate = this.audioFormat.getSampleRate();
            long frameLength = ais.getFrameLength();
            try {
                ais.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
            this.setProcessedFrameLength(frameLength);
        } else {
            this.reset();
        }
        this.setSelection();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        JComponent[] yScales = this.getYScales();
        if (yScales != null) {
            for (JComponent sc : yScales) {
                if (sc == null) continue;
                ((Component)sc).setVisible(visible);
            }
        }
    }

    @Override
    public void doLayout() {
        this.resized();
    }

    private void resized() {
        if (this.length == (long)ThreadSafeAudioSystem.NOT_SPECIFIED) {
            this.lengthInSeconds = 0.0;
        } else {
            this.lengthInSeconds = (float)this.length / this.audioFormat.getFrameRate();
            int width = this.getWidth();
            if (width > 0 && this.length > 0L) {
                this.framesPerPixel = (double)this.length / (double)width;
                this.pixelsPerFrame = (double)width / (double)this.length;
            } else {
                this.framesPerPixel = 0.0;
                this.pixelsPerFrame = 0.0;
            }
        }
    }

    public void setProcessedFrameLength(long frameLength) {
        this.length = frameLength;
        if (this.length == 0L) {
            this.setSize(new Dimension(0, this.getHeight()));
        }
        this.resized();
    }

    protected void setFramePosition(long position) {
        int oldPixelPosition = this.pixelPosition;
        this.pixelPosition = this.mapFrameToPixel(position);
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(oldPixelPosition - 1, 0, 3, this.getHeight());
            this.paintImmediately(this.pixelPosition, 0, 1, this.getHeight());
        } else {
            this.repaint(oldPixelPosition - 1, 0, 3, this.getHeight());
            this.repaint(this.pixelPosition, 0, 1, this.getHeight());
        }
    }

    public AudioClip getAudioSample() {
        return this.audioSample;
    }

    public double getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        if (event instanceof AudioSourceChangedEvent) {
            AudioSourceChangedEvent asEvent = (AudioSourceChangedEvent)event;
            try {
                this.setAudioSource(asEvent.getAudioSource());
            }
            catch (AudioSourceException audioSourceException) {}
        } else if (event instanceof SelectionChangedEvent) {
            this.setSelection();
        }
    }

    protected void setSelection() {
        this.selection = null;
        if (this.audioSample != null) {
            this.selection = this.audioSample.getSelection();
        }
        this.viewSelection = this.selection == null ? null : new ViewSelection(this.selection);
        this.repaint();
    }

    @Override
    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    @Override
    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void fireActionEvent(ActionEvent ae) {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(ae);
        }
    }

    public Format getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public void setTimeFormat(Format timeFormat) {
        this.timeFormat = timeFormat;
        this.repaint();
    }

    protected String formatPosition(long framePosition) {
        if (MediaLengthUnit.TIME.equals((Object)this.mediaLengthUnit)) {
            Double timePostionSeconds = this.framesToTimeInSeconds(framePosition);
            if (this.timeFormat == null) {
                return timePostionSeconds.toString();
            }
            return this.timeFormat.format(timePostionSeconds);
        }
        return Long.toString(framePosition);
    }

    @Override
    public void setTimeScaleTickProvider(TickProvider<Long> timeScaleTickProvider) {
        this.timeScaleTickProvider = timeScaleTickProvider;
    }

    public JMenu[] getJMenus() {
        return new JMenu[0];
    }

    @Override
    public void close() {
    }

    @Override
    public JComponent[] getYScales() {
        return new JComponent[0];
    }

    @Override
    public void setMediaLengthUnit(MediaLengthUnit mediaLengthUnit) {
        this.mediaLengthUnit = mediaLengthUnit;
        this.repaint();
    }

    public ActionTreeRoot getActionTreeRoot() {
        return null;
    }

    @Override
    public void showJControlDialog(Component parentComponent) {
    }

    @Override
    public boolean hasControlDialog() {
        return false;
    }

    @Override
    public boolean isPreferredFixedHeight() {
        return false;
    }

    @Override
    public Component asComponent() {
        return this;
    }

    public class ViewSelection {
        private Selection selection;

        public ViewSelection() {
            this(new Selection());
        }

        public ViewSelection(Selection s) {
            this.setSelection(s);
        }

        public int getXLeft() {
            return BasicAudioClipUI.this.mapFrameToPixel(this.selection.getLeft());
        }

        public int getXRight() {
            return BasicAudioClipUI.this.mapFrameToPixel(this.selection.getRight());
        }

        public void setXEnd(int i) {
            this.selection.setEnd(BasicAudioClipUI.this.mapPixelToFrame(i));
        }

        public int getXEnd() {
            return BasicAudioClipUI.this.mapFrameToPixel(this.selection.getEnd());
        }

        public void setXStart(int i) {
            this.selection.setStart(BasicAudioClipUI.this.mapPixelToFrame(i));
        }

        public int getXStart() {
            return BasicAudioClipUI.this.mapFrameToPixel(this.selection.getStart());
        }

        public boolean isInXSelection(int pixelPos) {
            int xStart = this.getXStart();
            int xEnd = this.getXEnd();
            boolean inSelection = pixelPos > xStart && pixelPos <= xEnd || pixelPos <= xStart && pixelPos > xEnd;
            return inSelection;
        }

        public long getEnd() {
            return this.selection.getEnd();
        }

        public long getLength() {
            return this.selection.getLength();
        }

        public boolean isInSelection(long pos) {
            return this.selection.isInSelection(pos);
        }

        public void limitTo(long startLimit, long endLimit) {
            this.selection.limitTo(startLimit, endLimit);
        }

        public Selection getSelection() {
            return this.selection;
        }

        public void setSelection(Selection selection) {
            this.selection = selection;
        }

        public Marker getEndMarker() {
            return this.selection.getEndMarker();
        }

        public long getLeft() {
            return this.selection.getLeft();
        }

        public String getName() {
            return this.selection.getName();
        }

        public long getRight() {
            return this.selection.getRight();
        }

        public long getStart() {
            return this.selection.getStart();
        }

        public Marker getStartMarker() {
            return this.selection.getStartMarker();
        }

        public void setEnd(long l) {
            this.selection.setEnd(l);
        }

        public void setEndMarker(Marker endMarker) {
            this.selection.setEndMarker(endMarker);
        }

        public void setName(String name) {
            this.selection.setName(name);
        }

        public void setStart(long l) {
            this.selection.setStart(l);
        }

        public void setStartMarker(Marker startMarker) {
            this.selection.setStartMarker(startMarker);
        }
    }
}

