/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.dsp.FloatRandomAccessStream;
import ipsk.math.Complex;
import ipsk.math.FFT2;
import ipsk.math.GaussianWindow;
import ipsk.math.Window;
import java.awt.Toolkit;
import java.io.File;

public class FourierAudioInputStream {
    private int channels;
    private double[][] srcBuf;
    private int n;
    private int len;
    private FloatRandomAccessStream srcStream;
    private FFT2 fft;
    private Window window;
    private int windowLen;
    private int frameOffset = 0;

    public FourierAudioInputStream(FloatRandomAccessStream srcStream) throws AudioSourceException {
        this(srcStream, 128, 128);
    }

    public FourierAudioInputStream(FloatRandomAccessStream srcStream, int n) throws AudioSourceException {
        this(srcStream, n, n);
    }

    public FourierAudioInputStream(FloatRandomAccessStream srcStream, int n, int windowSize) throws AudioSourceException {
        this.srcStream = srcStream;
        this.channels = this.getChannels();
        this.setNAndWindowSize(n, windowSize);
    }

    public void setNAndWindowSize(int n, int windowSize) {
        this.n = n;
        this.len = windowSize;
        if (n > this.len) {
            this.srcBuf = new double[n][this.channels];
            int padding = n - this.len;
            for (int ch = 0; ch < this.channels; ++ch) {
                for (int i = 0; i < padding; ++i) {
                    this.srcBuf[this.len + i][ch] = 0.0;
                }
            }
            this.windowLen = this.len;
        } else {
            this.srcBuf = new double[this.len][this.channels];
            this.windowLen = n;
        }
        this.window = new GaussianWindow(this.windowLen);
        this.fft = new FFT2(n);
    }

    public void setFramePosition(long newPos) throws AudioSourceException {
        long srcStreamPos = newPos - (long)(this.len / 2);
        if (srcStreamPos < 0L) {
            this.frameOffset = (int)(-srcStreamPos);
            srcStreamPos = 0L;
        } else {
            this.frameOffset = 0;
        }
        this.srcStream.setFramePosition(srcStreamPos);
    }

    public boolean readFrame(Complex[][][] buf, int offset) throws AudioSourceException {
        int ch;
        int read = 0;
        if (this.frameOffset > 0) {
            for (int i = 0; i < this.frameOffset; ++i) {
                for (ch = 0; ch < this.channels; ++ch) {
                    this.srcBuf[i][ch] = 0.0;
                }
            }
            read += this.frameOffset;
        }
        while (read < this.len) {
            int r = this.srcStream.readFrames(this.srcBuf, read, this.len - read);
            if (r == -1) {
                if (read == 0) {
                    return false;
                }
                while (read < this.len) {
                    for (ch = 0; ch < this.channels; ++ch) {
                        this.srcBuf[read][ch] = 0.0;
                    }
                    ++read;
                }
                continue;
            }
            read += r;
        }
        for (int ch2 = 0; ch2 < this.channels; ++ch2) {
            double[] chBuf = new double[this.n];
            for (int i = 0; i < this.windowLen; ++i) {
                chBuf[i] = this.srcBuf[i][ch2] * this.window.getScale(i);
            }
            Complex[] x = this.fft.process(chBuf);
            System.arraycopy(x, 0, buf[offset][ch2], 0, this.n);
        }
        return true;
    }

    public void close() throws AudioSourceException {
        this.srcStream.close();
    }

    public static void main(String[] args) throws AudioSourceException {
        FileAudioSource ais = null;
        if (args.length < 3) {
            System.err.println("Usage: " + FourierAudioInputStream.class.getName() + " audioFilename DFT_size window_len [ouputfile]");
        }
        int size = Integer.parseInt(args[1]);
        float windowLen = Float.parseFloat(args[2]);
        ais = new FileAudioSource(new File(args[0]));
        FloatRandomAccessStream fAis = null;
        try {
            fAis = new FloatRandomAccessStream(ais);
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        float sampleRate = -1.0f;
        try {
            sampleRate = ais.getFormat().getSampleRate();
        }
        catch (AudioSourceException e1) {
            e1.printStackTrace();
        }
        int windowSize = (int)(sampleRate * windowLen);
        FourierAudioInputStream dftAis = new FourierAudioInputStream(fAis, size, windowSize);
        int channels = ais.getFormat().getChannels();
        Complex[][][] buf = new Complex[1][channels][size];
        while (dftAis.readFrame(buf, 0)) {
            for (int ch = 0; ch < channels; ++ch) {
                for (int i = 0; i < size / 2; ++i) {
                }
            }
        }
        dftAis.close();
        Toolkit.getDefaultToolkit().beep();
        Toolkit.getDefaultToolkit().beep();
        Toolkit.getDefaultToolkit().beep();
    }

    public int getChannels() throws AudioSourceException {
        return this.srcStream.getChannels();
    }

    public long getFrameLength() throws AudioSourceException {
        return this.srcStream.getFrameLength();
    }
}

