/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp.speech.vad.impl;

import ips.dsp.AutoCorrelator;
import ips.dsp.SampledTime;
import ipsk.audio.dsp.DSPUtils;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetector;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetectorEvent;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetectorListener;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.swing.SwingUtilities;

public class VoicedSpeechDetector
implements VoiceActivityDetector {
    private double startCorrTime = 0.004;
    private double endCorrTime = 0.015;
    private double corrLenTime = 0.1;
    private double VOICED_THRESHOLD = 0.5;
    private double MIN_RELATIVE_ENERGY_LEVEL = -80.0;
    private double LOWEST_ENERGY_MIN = DSPUtils.toPowerLinearLevel(-120.0);
    public static final boolean DEBUG = false;
    private float sampleRate;
    private double[] buf;
    private volatile int avail = 0;
    private volatile long framePosition = 0L;
    private int processLen;
    private boolean voiced = false;
    private VoiceActivityDetectorListener listener;
    private long corrStartFrames;
    private long corrEndFrames;
    private double lowestEnergy = Double.MAX_VALUE;
    private double highestEnergy = this.LOWEST_ENERGY_MIN;
    private volatile boolean running = true;

    private void init() {
        long corrLenFrames = (long)(this.corrLenTime * (double)this.sampleRate);
        this.corrStartFrames = (long)(this.startCorrTime * (double)this.sampleRate);
        this.corrEndFrames = (long)(this.endCorrTime * (double)this.sampleRate);
        this.processLen = (int)(corrLenFrames + this.corrEndFrames);
        this.buf = new double[this.processLen * 2];
    }

    private void reset() {
        this.avail = 0;
        this.voiced = false;
    }

    @Override
    public void setAudioFormat(AudioFormat audioFormat) {
        this.sampleRate = audioFormat.getSampleRate();
        this.init();
    }

    public void setChannels(int channels) {
    }

    public void write(double[][] buf, int offset, int len) throws IOException {
        if (this.running) {
            int reqBufLen = this.avail + len;
            if (this.buf.length < reqBufLen) {
                this.buf = Arrays.copyOf(this.buf, reqBufLen);
            }
            for (int i = 0; i < len; ++i) {
                this.buf[this.avail + i] = buf[offset + i][0];
            }
            this.avail += len;
            while (this.avail >= this.processLen) {
                double currE;
                boolean currVoiced;
                this.framePosition += (long)this.processLen;
                AutoCorrelator.AutoCorrelationResult res = AutoCorrelator.autoCorrelate((double[])this.buf, (int)0, (int)this.processLen, (int)((int)this.corrStartFrames), (int)((int)this.corrEndFrames));
                double bufE = res.getEnergy();
                if (bufE > this.highestEnergy) {
                    this.highestEnergy = bufE;
                }
                if (bufE < this.lowestEnergy) {
                    this.lowestEnergy = bufE;
                }
                boolean bl = currVoiced = (currE = DSPUtils.toPowerLevelInDB(bufE / this.highestEnergy)) > this.MIN_RELATIVE_ENERGY_LEVEL && res.correlation() > this.VOICED_THRESHOLD;
                if (this.voiced != currVoiced) {
                    this.voiced = currVoiced;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VoicedSpeechDetector.this.listener.update(new VoiceActivityDetectorEvent(this, VoicedSpeechDetector.this.voiced, new SampledTime((double)VoicedSpeechDetector.this.sampleRate, VoicedSpeechDetector.this.framePosition)));
                        }
                    });
                }
                this.avail -= this.processLen;
                for (int j = 0; j < this.avail; ++j) {
                    this.buf[j] = this.buf[this.processLen + j];
                }
            }
        }
    }

    public void close() throws IOException {
        this.reset();
    }

    public void flush() throws IOException {
    }

    @Override
    public void setVoiceActivityDetectorListener(VoiceActivityDetectorListener voiceActivityDetectorListener) {
        this.listener = voiceActivityDetectorListener;
    }
}

