/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io;

import ipsk.audio.AudioFormatNotSupportedException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class ChannelRoutingAudioInputStream
extends AudioInputStream {
    public ChannelRoutingAudioInputStream(InputStream stream, AudioFormat format, long length, Integer[] channelRouting) {
        super(stream, format, length);
        int maxInIdx = -1;
        Integer[] integerArray = channelRouting;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int r = integerArray[i];
            if (r <= maxInIdx) continue;
            maxInIdx = r;
        }
    }

    public ChannelRoutingAudioInputStream(AudioInputStream stream, int srcChannelCount, AudioFormat format, long length, Integer[] channelRouting) throws AudioFormatNotSupportedException {
        super(stream, format, length);
        int maxInIdx = -1;
        Integer[] integerArray = channelRouting;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int r = integerArray[i];
            if (r <= maxInIdx) continue;
            maxInIdx = r;
        }
        int inputChannelCountByAssignment = maxInIdx + 1;
        AudioFormat af = stream.getFormat();
        if (srcChannelCount < inputChannelCountByAssignment) {
            throw new AudioFormatNotSupportedException(af);
        }
    }

    public ChannelRoutingAudioInputStream(AudioInputStream stream, AudioFormat format, long length, Integer[] channelRouting) throws AudioFormatNotSupportedException {
        super(stream, format, length);
        int maxInIdx = -1;
        Integer[] integerArray = channelRouting;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int r = integerArray[i];
            if (r <= maxInIdx) continue;
            maxInIdx = r;
        }
        int inputChannelCountByAssignment = maxInIdx + 1;
        AudioFormat af = stream.getFormat();
        int srcChannelCount = af.getChannels();
        if (srcChannelCount < inputChannelCountByAssignment) {
            throw new AudioFormatNotSupportedException(af);
        }
    }
}

