/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io;

import ipsk.audio.io.CancelledException;
import ipsk.awt.AWTEventTransferAgent;
import ipsk.awt.ProgressListener;
import ipsk.awt.event.ProgressEvent;
import ipsk.util.ProgressStatus;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class ProgressMonitorAudioInputStream
extends AudioInputStream {
    private AudioInputStream srcAudioInputStream;
    private int frameSize;
    private long position;
    private long frameLength;
    private EventTransformer evTr = new EventTransformer();
    private long byteLength;
    private boolean cancelled;
    private ProgressStatus progressStatus;

    public ProgressMonitorAudioInputStream(AudioInputStream srcAudioInputStream) {
        super(srcAudioInputStream, srcAudioInputStream.getFormat(), srcAudioInputStream.getFrameLength());
        this.srcAudioInputStream = srcAudioInputStream;
        AudioFormat audioFormat = srcAudioInputStream.getFormat();
        this.frameSize = audioFormat.getFrameSize();
        this.frameLength = srcAudioInputStream.getFrameLength();
        this.byteLength = (long)this.frameSize * this.frameLength;
        this.progressStatus = new ProgressStatus();
        this.progressStatus.setLength(this.byteLength);
        this.progressStatus.open();
        this.position = 0L;
    }

    @Override
    public int available() throws IOException {
        return this.srcAudioInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.srcAudioInputStream.close();
        this.progressStatus.done();
        this.evTr.fireAWTEventAndWait((EventObject)new ProgressEvent((Object)this, this.progressStatus));
    }

    @Override
    public AudioFormat getFormat() {
        return this.srcAudioInputStream.getFormat();
    }

    @Override
    public long getFrameLength() {
        return this.srcAudioInputStream.getFrameLength();
    }

    @Override
    public synchronized void mark(int arg0) {
        this.srcAudioInputStream.mark(arg0);
    }

    @Override
    public boolean markSupported() {
        return this.srcAudioInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return 0xFF & read;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.cancelled) {
            throw new CancelledException();
        }
        int read = this.srcAudioInputStream.read(buf, offset, len);
        if (read == -1) {
            return read;
        }
        if (read > 0) {
            this.position += (long)read;
            this.progressStatus.setProgress(this.position);
            this.evTr.fireAWTEventAndWait((EventObject)new ProgressEvent((Object)this, this.progressStatus));
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.srcAudioInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.cancelled) {
            throw new CancelledException();
        }
        long skipped = this.srcAudioInputStream.skip(n);
        this.position += n;
        this.progressStatus.setProgress(this.position);
        this.evTr.fireAWTEventAndWait((EventObject)new ProgressEvent((Object)this, this.progressStatus));
        return skipped;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        this.evTr.addListener((EventListener)progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        this.evTr.removeListener((EventListener)progressListener);
    }

    public String toString() {
        return new String("Progress monitoring audio stream based on:" + this.srcAudioInputStream.toString());
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public class EventTransformer
    extends AWTEventTransferAgent<ProgressListener, ProgressEvent> {
        public void fireEvent(ProgressListener pl, ProgressEvent ev) {
            pl.update(ev);
        }
    }
}

