/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.ControlUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.sound.sampled.FloatControl;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FloatControlUI
extends ControlUI
implements ChangeListener {
    private static final long serialVersionUID = -2165793886440708526L;
    private FloatControl fc;
    private FloatControl.Type type;
    private JSlider slider;
    private JLabel label;
    private float minimum;
    private float range;
    private int ticks;
    private float precision;
    private boolean updating = false;

    public FloatControlUI(FloatControl fc) {
        this.fc = fc;
        this.setLayout(new BorderLayout());
        this.type = (FloatControl.Type)fc.getType();
        this.label = new JLabel(this.type.toString());
        this.label.setFont(this.getFont().deriveFont(0));
        this.minimum = fc.getMinimum();
        this.precision = fc.getPrecision();
        this.range = fc.getMaximum() - this.minimum;
        this.ticks = (int)(this.range / this.precision);
        float value = fc.getValue();
        int sliderValue = (int)((value - this.minimum) / this.precision);
        if (sliderValue > this.ticks) {
            sliderValue = this.ticks;
        }
        this.preferredOrientation = this.type == FloatControl.Type.BALANCE ? 0 : 1;
        this.slider = new JSlider(this.preferredOrientation, 0, this.ticks, sliderValue);
        if (this.preferredOrientation == 0) {
            this.slider.setPreferredSize(new Dimension(30, 20));
        } else {
            this.slider.setPreferredSize(new Dimension(20, 100));
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel(fc.getMinLabel()));
        labelTable.put(this.ticks, new JLabel(fc.getMaxLabel()));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        this.setToolTipText(fc.toString());
        this.label.setToolTipText(fc.toString());
        this.slider.setToolTipText(fc.toString());
        this.add((Component)this.label, "North");
        this.add((Component)this.slider, "Center");
        this.slider.addChangeListener(this);
    }

    public void updateToolTip() {
        this.setToolTipText(this.fc.toString());
        this.label.setToolTipText(this.fc.toString());
        this.slider.setToolTipText(this.fc.toString());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.type == FloatControl.Type.BALANCE) {
            return new Dimension(40, super.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.type == FloatControl.Type.BALANCE) {
            return new Dimension(80, super.getPreferredSize().height);
        }
        return super.getMaximumSize();
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (!this.updating) {
            int sliderValue = this.slider.getValue();
            this.fc.setValue((float)sliderValue * this.precision + this.minimum);
            this.updateValue();
        }
    }

    @Override
    public void updateValue() {
        float value = this.fc.getValue();
        int sliderValue = (int)((value - this.minimum) / this.precision);
        if (sliderValue != this.slider.getValue()) {
            this.updating = true;
            this.slider.setValue(sliderValue);
            this.updating = false;
        }
        this.updateToolTip();
    }
}

