/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.MixerConfigPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.ButtonGroup;
import javax.swing.JTabbedPane;

public class MixerDevicesUI
extends JTabbedPane
implements ActionListener {
    private static final long serialVersionUID = 2787148265624589065L;
    static final boolean DEBUG = false;
    private Mixer.Info[] mixerInfos = null;
    private Mixer[] mixers = null;
    private Mixer selectedPlaybackMixer = null;
    private Mixer selectedCaptureMixer = null;
    private MixerConfigPanel[] mixerPanels = null;
    private int numMixers;
    private ButtonGroup playbackMixerButtonGroup;
    private ButtonGroup captureMixerButtonGroup;
    private Vector<ActionListener> listenerList = new Vector();
    private static int id = 0;

    public MixerDevicesUI() {
        this.createUI();
    }

    public MixerDevicesUI(Mixer selectedTargetMixer, Mixer selectedSourceMixer) {
        this.createUI();
        this.setSelectedCaptureMixer(selectedTargetMixer);
        this.setSelectedPlaybackMixer(selectedSourceMixer);
    }

    private void createUI() {
        this.mixerInfos = AudioSystem.getMixerInfo();
        this.numMixers = this.mixerInfos.length;
        this.mixers = new Mixer[this.numMixers];
        this.mixerPanels = new MixerConfigPanel[this.numMixers];
        this.playbackMixerButtonGroup = new ButtonGroup();
        this.captureMixerButtonGroup = new ButtonGroup();
        for (int i = 0; i < this.numMixers; ++i) {
            this.mixers[i] = AudioSystem.getMixer(this.mixerInfos[i]);
            if (this.mixers[i] == null) continue;
            this.mixerPanels[i] = new MixerConfigPanel(this.mixers[i], this);
            this.addTab(this.mixerInfos[i].getName(), this.mixerPanels[i]);
            this.playbackMixerButtonGroup.add(this.mixerPanels[i].selectPlayRadioButton);
            this.captureMixerButtonGroup.add(this.mixerPanels[i].selectCaptureRadioButton);
        }
        this.revalidate();
        this.repaint();
    }

    public void setSelectedPlaybackMixer(Mixer playbackMixer) {
        for (int i = 0; i < this.numMixers; ++i) {
            this.mixerPanels[i].selectPlayRadioButton.setSelected(false);
            if (this.mixers[i] != playbackMixer) continue;
            this.mixerPanels[i].selectPlayRadioButton.setSelected(true);
            this.selectedPlaybackMixer = this.mixers[i];
        }
    }

    public void setSelectedCaptureMixer(Mixer captureMixer) {
        for (int i = 0; i < this.numMixers; ++i) {
            this.mixerPanels[i].selectCaptureRadioButton.setSelected(false);
            if (this.mixers[i] != captureMixer) continue;
            this.mixerPanels[i].selectCaptureRadioButton.setSelected(true);
            this.selectedCaptureMixer = this.mixers[i];
        }
    }

    public Mixer getSelectedPlaybackMixer() {
        return this.selectedPlaybackMixer;
    }

    public Mixer getSelectedCaptureMixer() {
        return this.selectedCaptureMixer;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.numMixers; ++i) {
            this.mixerPanels[i].setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.numMixers; ++i) {
            if (e.getSource() == this.mixerPanels[i].selectPlayRadioButton) {
                this.selectedPlaybackMixer = this.mixers[i];
                this.updateListeners(new ActionEvent(this, id++, "playback device changed"));
                continue;
            }
            if (e.getSource() != this.mixerPanels[i].selectCaptureRadioButton) continue;
            this.selectedCaptureMixer = this.mixers[i];
            this.updateListeners(new ActionEvent(this, id++, "capture device changed"));
        }
    }

    public synchronized void addActionListener(ActionListener al) {
        if (al != null && !this.listenerList.contains(al)) {
            this.listenerList.addElement(al);
        }
    }

    public synchronized void removeActionListener(ActionListener al) {
        if (al != null) {
            this.listenerList.removeElement(al);
        }
    }

    protected synchronized void updateListeners(ActionEvent ae) {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(ae);
        }
    }
}

