/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.MixerPortsUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PortMixersUI
extends JPanel
implements AncestorListener,
ActionListener {
    private static final long serialVersionUID = 8999681591936590292L;
    public int DEF_UPDATE_INTERVALL = 100;
    private ArrayList<MixerPortsUI> mixerPortUIs = new ArrayList();
    private JTabbedPane portMixersTabPane = null;
    private Object value;
    private JDialog d;
    private Timer updateTimer;
    private int updateIntervall;
    private boolean updating = true;

    public PortMixersUI() throws LineUnavailableException {
        super(new BorderLayout());
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer m = AudioSystem.getMixer(mixerInfos[i]);
            String name = m.getMixerInfo().getName();
            if (!this.hasPorts(m)) continue;
            if (this.portMixersTabPane == null) {
                this.portMixersTabPane = new JTabbedPane();
            }
            MixerPortsUI mpui = new MixerPortsUI(m);
            this.mixerPortUIs.add(mpui);
            this.portMixersTabPane.addTab(name, mpui);
        }
        if (this.portMixersTabPane == null) {
            this.add((Component)new JLabel("Sorry, no mixers found !"), "Center");
        } else {
            this.add((Component)this.portMixersTabPane, "Center");
        }
        this.updateIntervall = this.DEF_UPDATE_INTERVALL;
        this.updateTimer = new Timer(this.updateIntervall, this);
        this.updateTimer.setRepeats(true);
        this.addAncestorListener(this);
    }

    private boolean hasPorts(Mixer m) throws LineUnavailableException {
        int i;
        Line.Info[] lineInfo = m.getSourceLineInfo();
        for (i = 0; i < lineInfo.length; ++i) {
            if (!(lineInfo[i] instanceof Port.Info)) continue;
            return true;
        }
        lineInfo = m.getTargetLineInfo();
        for (i = 0; i < lineInfo.length; ++i) {
            if (!(lineInfo[i] instanceof Port.Info)) continue;
            return true;
        }
        return false;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Audio Mixer");
        frame.setDefaultCloseOperation(3);
        PortMixersUI newContentPane = null;
        try {
            newContentPane = new PortMixersUI();
        }
        catch (LineUnavailableException e) {
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "Audio mixer error", 0);
        }
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public Object getValue() {
        return this.value;
    }

    public JDialog getDialog() {
        return this.d;
    }

    public JDialog createDialog(Frame owner) {
        JDialog dialog = new JDialog(owner, "Audio mixer", true);
        dialog.getContentPane().add(this);
        return dialog;
    }

    public Object showDialog(Frame parent) {
        this.d = this.createDialog(parent);
        this.d.pack();
        if (parent != null) {
            this.d.setLocationRelativeTo(parent);
        }
        this.d.setVisible(true);
        return this.getValue();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PortMixersUI.createAndShowGUI();
            }
        });
    }

    public void updateValue() {
        for (MixerPortsUI mpui : this.mixerPortUIs) {
            mpui.updateValue();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (event.getAncestor().isVisible() && this.updating) {
            this.updateTimer.start();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.updateTimer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.updateTimer && this.updating) {
            this.updateValue();
        }
    }

    public int getUpdateIntervall() {
        return this.updateIntervall;
    }

    public void setUpdateIntervall(int updateIntervall) {
        this.updateIntervall = updateIntervall;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
        this.updateTimer.stop();
    }
}

