/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.player;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPluginException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.audio.FileAudioSource;
import ipsk.audio.URLAudioSource;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.dsp.BufferLevelInfo;
import ipsk.audio.dsp.BufferLevelInfoArray;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.PeakDetector;
import ipsk.audio.io.InterceptorAudioInputStream;
import ipsk.audio.io.push.IAudioOutputStream;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEndOfMediaEvent;
import ipsk.audio.player.event.PlayerErrorEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerOpenEvent;
import ipsk.audio.player.event.PlayerPauseEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.player.event.PlayerStoppedEvent;
import ipsk.audio.plugins.ChannelRoutingPlugin;
import ipsk.audio.utils.AudioFormatUtils;
import ipsk.awt.UpdateAWTEventTransferAgent;
import ipsk.io.ChannelRouting;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class Player
implements Runnable,
LineListener {
    protected static final int DEF_PREFERRED_BUFFER_SIZE = 2048;
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(4000.0f);
    private static final Float STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    private static String[] LARGE_BUFFER_SIZE_CAPABLE_LINE_CLASS_NAMES = new String[]{"ips.audio.ds.DSSourceDataLine"};
    private static String[] STOP_WHILE_DRAIN_CAPABLE_LINE_CLASS_NAMES = new String[]{"ips.audio.ds.DSSourceDataLine"};
    protected static final int THREAD_INTERRUPT_TIMEOUT = 30000;
    private static final boolean DEFAULT_AVOID_WRITE_LOCK = true;
    private static final int DEFAULT_BUFFER_LEVEL_INFO_RING_BUFFER_SIZE = 1024;
    protected UpdateAWTEventTransferAgent<PlayerListener, PlayerEvent> apETA = new UpdateAWTEventTransferAgent();
    private SourceDataLine line;
    private Mixer device;
    protected AudioSource audioSource;
    private AudioInputStream srcStream;
    private InterceptorAudioInputStream interCeptorStream;
    private AudioInputStream ais;
    private long frameLength;
    private volatile long streamFramePosition;
    private volatile long streamPosOffset;
    private volatile boolean streaming;
    private byte[] buffer;
    private Thread thread;
    private volatile boolean running;
    private AudioFormat format;
    private DataLine.Info lineInfo;
    private Object streamNotify;
    private volatile int avail = 0;
    private volatile State status;
    private volatile long startFramePosition;
    private volatile long stopFramePosition;
    private boolean looping;
    private BufferLevelInfoArray bufferInfos;
    private PeakDetector peakDetector;
    private float[] peakLevelHolds;
    private LevelInfo[] zeroLevelInfos;
    private int bufferSize;
    private int preferredBufferSize;
    private HashSet<String> largeBufferSizeCapableLineClassNames;
    private HashSet<String> stopWhileDrainCapableLineClassNames;
    private boolean avoidWriteLock = true;
    private volatile int loopOffsets = 0;
    private Integer preferredLineBufferSize = null;
    private Float preferredLineBufferSizeMillis;
    private boolean measureLevel = true;
    private boolean forceOpening = true;
    private ChannelRouting channelRouting = null;
    private ChannelRoutingPlugin channelRoutingPlugin;
    private int channelOffset = 0;
    private ChannelRouting currentChannelRouting = null;
    private long lastLevelCheckposition;
    private volatile boolean stopWhileDrainCapable = false;

    public Player() {
        this((Mixer)null);
    }

    public Player(Mixer device) {
        this.device = device;
        this.preferredBufferSize = 2048;
        this.streamNotify = new Object();
        this.streamPosOffset = 0L;
        this.startFramePosition = 0L;
        this.stopFramePosition = this.frameLength = -1L;
        this.bufferInfos = new BufferLevelInfoArray(1024);
        this.resetPeakHold();
        this.status = State.CLOSE;
        this.looping = false;
        this.largeBufferSizeCapableLineClassNames = new HashSet<String>(Arrays.asList(LARGE_BUFFER_SIZE_CAPABLE_LINE_CLASS_NAMES));
        this.stopWhileDrainCapableLineClassNames = new HashSet<String>(Arrays.asList(STOP_WHILE_DRAIN_CAPABLE_LINE_CLASS_NAMES));
    }

    public Player(AudioSource audioSource) {
        this(null, audioSource);
    }

    public Player(File audioFile) {
        this(null, new FileAudioSource(audioFile));
    }

    public Player(URL audioURL) {
        this(null, new URLAudioSource(audioURL));
    }

    public Player(Mixer device, AudioSource audioSource) {
        this(device);
        this.audioSource = audioSource;
    }

    public Player(Mixer device, File audioFile) {
        this(device, new FileAudioSource(audioFile));
    }

    public Player(Mixer device, URL audioURL) {
        this(device, new URLAudioSource(audioURL));
    }

    public boolean isPlaying() {
        return State.PLAY.equals((Object)this.status);
    }

    public boolean isPaused() {
        return State.PAUSE.equals((Object)this.status);
    }

    public synchronized void setAudioSource(AudioSource audioSource) throws PlayerException {
        if (!State.CLOSE.equals((Object)this.status)) {
            this.close();
            this.audioSource = audioSource;
            this.open();
        } else {
            this.audioSource = audioSource;
        }
    }

    private synchronized void setAudioStreamPosition(long pos) throws AudioSourceException, IOException, AudioPluginException, AudioFormatNotSupportedException {
        if (pos < this.streamFramePosition) {
            this.resetAudioStream();
            this.syncPosition();
        }
        if (this.ais != null) {
            int frameSize = this.ais.getFormat().getFrameSize();
            for (long toSkip = (long)frameSize * (pos - this.streamFramePosition); toSkip > 0L; toSkip -= this.ais.skip(toSkip)) {
            }
        }
        this.streamFramePosition = pos;
    }

    private void resetAudioStream() throws AudioSourceException, IOException, AudioPluginException, AudioFormatNotSupportedException {
        if (this.ais != null) {
            this.ais.close();
        }
        if (this.audioSource != null) {
            this.srcStream = this.audioSource.getAudioInputStream();
            this.interCeptorStream = new InterceptorAudioInputStream(this.srcStream);
            if (this.channelRouting != null) {
                this.currentChannelRouting = this.channelRouting;
            } else if (this.channelOffset != 0) {
                this.currentChannelRouting = new ChannelRouting(false, this.channelOffset, this.srcStream.getFormat().getChannels());
            } else {
                this.currentChannelRouting = null;
                this.ais = this.interCeptorStream;
            }
            if (this.currentChannelRouting != null) {
                if (this.channelRoutingPlugin == null) {
                    this.channelRoutingPlugin = new ChannelRoutingPlugin();
                }
                this.channelRoutingPlugin.setChannelRouting(this.currentChannelRouting);
                this.ais = this.channelRoutingPlugin.getAudioInputStream(this.interCeptorStream);
            }
            this.applyMeasureLevelStream();
        }
        this.avail = 0;
        this.streamFramePosition = 0L;
    }

    public boolean isFormatSupported(AudioFormat af) {
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, af);
        if (this.device == null) {
            return AudioSystem.isLineSupported(lineInfo);
        }
        return this.device.isLineSupported(lineInfo);
    }

    public synchronized void open() throws PlayerException {
        if (!State.CLOSE.equals((Object)this.status)) {
            return;
        }
        try {
            this.resetAudioStream();
            this.syncPosition();
        }
        catch (AudioSourceException e) {
            throw new PlayerException(e);
        }
        catch (IOException e) {
            throw new PlayerException(e);
        }
        catch (AudioPluginException e) {
            throw new PlayerException(e);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new PlayerException(e);
        }
        this.format = this.srcStream.getFormat();
        this.frameLength = this.srcStream.getFrameLength();
        int frameSize = this.format.getFrameSize();
        this.resetPeakHold();
        int bufferFrames = this.preferredBufferSize / frameSize;
        this.bufferSize = bufferFrames * frameSize;
        this.buffer = new byte[this.bufferSize];
        AudioFormat playbackFormat = this.format;
        if (this.currentChannelRouting != null) {
            try {
                this.channelRoutingPlugin.setOutputFormat(null);
                this.channelRoutingPlugin.setInputFormat(this.format);
                playbackFormat = this.channelRoutingPlugin.getOutputFormat();
            }
            catch (AudioFormatNotSupportedException e) {
                e.printStackTrace();
                throw new PlayerException("Cannot route playback stream: ", e);
            }
        }
        this.lineInfo = new DataLine.Info(SourceDataLine.class, playbackFormat);
        if (this.device == null) {
            AJSDevice ajsDevice = AJSAudioSystem.getDefaultResolvedPlaybackDevice();
            this.device = ajsDevice.getMixer();
            if (this.device == null) {
                this.device = AudioSystem.getMixer(null);
            }
        }
        try {
            this.line = this.device == null ? (SourceDataLine)AJSAudioSystem.getLine(this.lineInfo) : (SourceDataLine)this.device.getLine(this.lineInfo);
        }
        catch (LineUnavailableException e) {
            throw new PlayerException(e);
        }
        catch (IllegalArgumentException e) {
            if (this.forceOpening) {
                Line[] lines;
                for (Line l : lines = this.device.getSourceLines()) {
                    if (!(l instanceof SourceDataLine)) continue;
                    this.line = (SourceDataLine)l;
                    break;
                }
                if (this.line == null) {
                    throw new PlayerException(e);
                }
            }
            throw new PlayerException(e);
        }
        Class<?> lineClass = this.line.getClass();
        String lineClassName = lineClass.getName();
        this.stopWhileDrainCapable = this.stopWhileDrainCapableLineClassNames.contains(lineClassName);
        this.line.addLineListener(this);
        try {
            Integer requestedLinebufferSize = null;
            if (this.preferredLineBufferSize != null) {
                requestedLinebufferSize = this.preferredLineBufferSize;
            } else if (this.preferredLineBufferSizeMillis != null) {
                float preferredLimitedLineBufferSizeMillis = this.preferredLineBufferSizeMillis.floatValue();
                requestedLinebufferSize = AudioFormatUtils.pcmSizeInBytesFromLength(playbackFormat, preferredLimitedLineBufferSizeMillis / 1000.0f);
            }
            if (requestedLinebufferSize != null) {
                float requestedLineBufferSizeInMillis = AudioFormatUtils.pcmLengthFromByteLength(playbackFormat, requestedLinebufferSize) * 1000.0f;
                if (requestedLineBufferSizeInMillis > STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS.floatValue() && !this.largeBufferSizeCapableLineClassNames.contains(lineClassName)) {
                    requestedLinebufferSize = AudioFormatUtils.pcmSizeInBytesFromLength(playbackFormat, STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS.floatValue() / 1000.0f);
                }
                this.line.open(playbackFormat, requestedLinebufferSize);
            } else {
                this.line.open(playbackFormat);
            }
            this.line.flush();
            int lineBufferSize = this.line.getBufferSize();
            if (this.bufferSize >= lineBufferSize) {
                bufferFrames = lineBufferSize / frameSize / 4;
                this.bufferSize = bufferFrames * frameSize;
            }
            int lineBufferFrameLength = lineBufferSize * 2 / frameSize + 1;
            int bufferFrameLength = this.bufferSize / frameSize;
            int requiredLevelInfosLookBackArraySize = lineBufferFrameLength / bufferFrameLength;
            if (this.bufferInfos.getLength() < requiredLevelInfosLookBackArraySize) {
                this.bufferInfos = new BufferLevelInfoArray(requiredLevelInfosLookBackArraySize);
            }
        }
        catch (LineUnavailableException e) {
            throw new PlayerException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PlayerException(e);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new PlayerException(e);
        }
        try {
            this.peakDetector = new PeakDetector(this.format);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new PlayerException(e);
        }
        this.lastLevelCheckposition = 0L;
        this.bufferInfos.clear();
        this.running = true;
        this.status = State.STOP;
        this.thread = new Thread((Runnable)this, "Audio-Player");
        this.thread.setPriority(4);
        this.thread.start();
        this.syncPosition();
        this.apETA.fireEventAndWait((EventObject)new PlayerOpenEvent(this));
    }

    private void applyMeasureLevelStream() throws AudioFormatNotSupportedException {
        if (this.measureLevel) {
            this.interCeptorStream.addAudioOutputStream(new IAudioOutputStream(){
                private AudioFormat af;
                private int channels;
                private int frameSize;

                public void close() throws IOException {
                }

                public void flush() throws IOException {
                }

                public void write(byte[] buf, int offset, int len) throws IOException {
                    if (len > 0) {
                        LevelInfo[] lis = Player.this.peakDetector.processBuffer(buf, offset, len);
                        for (int ch = 0; ch < this.channels; ++ch) {
                            float peakLevel = lis[ch].getPeakLevel();
                            if (Player.this.peakLevelHolds[ch] < peakLevel) {
                                Player.this.peakLevelHolds[ch] = peakLevel;
                            }
                            lis[ch].setPeakLevelHold(Player.this.peakLevelHolds[ch]);
                        }
                        BufferLevelInfo bli = new BufferLevelInfo(Player.this.streamFramePosition, len / this.frameSize, lis);
                        Player.this.bufferInfos.add(bli);
                    }
                }

                @Override
                public void setAudioFormat(AudioFormat audioFormat) throws AudioFormatNotSupportedException {
                    this.af = audioFormat;
                    this.channels = audioFormat.getChannels();
                    this.frameSize = audioFormat.getFrameSize();
                }

                @Override
                public AudioFormat getAudioFormat() {
                    return this.af;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.streamNotify;
        synchronized (object) {
            if (State.CLOSE.equals((Object)this.status) || this.line == null) {
                return;
            }
            this.line.start();
            if (State.PLAY.equals((Object)this.status)) {
                return;
            }
            this.status = State.PLAY;
            this.streamNotify.notifyAll();
        }
        this.apETA.fireEventAndWait((EventObject)new PlayerStartEvent(this));
    }

    public synchronized void play() throws PlayerException {
        if (State.CLOSE.equals((Object)this.status)) {
            throw new PlayerException("Cannot play. Player is not open.");
        }
        this.setFramePosition(this.startFramePosition);
        this.start();
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void pauseAndFlush() {
        Object object = this.streamNotify;
        synchronized (object) {
            this.status = State.STOPPING;
            if (this.line != null) {
                this.line.stop();
            }
            this.status = State.PAUSE;
            while (this.streaming) {
                try {
                    this.streamNotify.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.line != null && this.line.getLongFramePosition() != 0L) {
            this.line.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long setFramePosition(long pos) throws PlayerException {
        State oldStatus = this.status;
        this.pauseAndFlush();
        this.avail = 0;
        long newPos = pos;
        if (newPos < 0L) {
            this.status = oldStatus;
            return -1L;
        }
        if (newPos > this.frameLength) {
            newPos = this.frameLength;
        }
        try {
            this.setAudioStreamPosition(newPos);
        }
        catch (AudioSourceException e) {
            throw new PlayerException(e);
        }
        catch (IOException e) {
            throw new PlayerException(e);
        }
        catch (AudioPluginException e) {
            throw new PlayerException(e);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new PlayerException(e);
        }
        this.syncPosition();
        Object object = this.streamNotify;
        synchronized (object) {
            if (State.PLAY.equals((Object)oldStatus)) {
                this.line.start();
                this.status = oldStatus;
                this.streamNotify.notifyAll();
            } else {
                this.status = oldStatus;
            }
        }
        return newPos;
    }

    public synchronized void pause() {
        if (State.STOP.equals((Object)this.status)) {
            this.status = State.PAUSE;
            this.apETA.fireEventAndWait((EventObject)new PlayerPauseEvent(this));
        } else if (State.PLAY.equals((Object)this.status)) {
            if (this.line != null) {
                this.status = State.STOPPING;
                this.line.stop();
            }
            this.status = State.PAUSE;
            this.apETA.fireEventAndWait((EventObject)new PlayerPauseEvent(this));
        } else if (this.stopWhileDrainCapable && State.DRAINING.equals((Object)this.status)) {
            this.stop();
        } else if (State.PAUSE.equals((Object)this.status)) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = this.streamNotify;
        synchronized (object) {
            if (State.STOP.equals((Object)this.status) || State.STOPPING.equals((Object)this.status) || !this.stopWhileDrainCapable && State.DRAINING.equals((Object)this.status) || State.CLOSE.equals((Object)this.status) || State.CLOSING.equals((Object)this.status)) {
                return;
            }
            this.status = State.STOPPING;
            if (this.line != null) {
                this.line.stop();
            }
            this.status = State.STOP;
        }
        this.apETA.fireEventAndWait((EventObject)new PlayerStoppedEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws PlayerException {
        Object object = this.streamNotify;
        synchronized (object) {
            if (State.CLOSE.equals((Object)this.status) || State.CLOSING.equals((Object)this.status)) {
                return;
            }
            this.status = State.CLOSING;
            this.running = false;
        }
        if (this.line != null) {
            this.line.stop();
            this.line.flush();
        }
        if (this.thread != null && this.thread != Thread.currentThread() && this.thread.isAlive()) {
            try {
                this.thread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.thread.isAlive()) {
                Thread moribund = this.thread;
                this.thread = null;
                moribund.interrupt();
                this.streaming = false;
                Object object2 = this.streamNotify;
                synchronized (object2) {
                    this.streamNotify.notifyAll();
                }
            }
        }
        try {
            if (this.ais != null) {
                this.ais.close();
            }
        }
        catch (IOException e) {
            throw new PlayerException(e);
        }
        finally {
            if (this.line != null) {
                this.line.close();
                this.line.removeLineListener(this);
            }
            this.ais = null;
            this.interCeptorStream = null;
            this.srcStream = null;
            this.status = State.CLOSE;
            this.syncPosition();
            this.apETA.fireEventAndWait((EventObject)new PlayerCloseEvent(this));
        }
    }

    public long getFramePosition() {
        if (this.line == null || !this.isOpen()) {
            return -1L;
        }
        long linePos = this.line.getLongFramePosition();
        long framePos = linePos - this.streamPosOffset;
        if (framePos > this.stopFramePosition && this.loopOffsets > 0) {
            long loopLength = -1L;
            if (this.stopFramePosition == -1L) {
                if (this.frameLength != -1L) {
                    loopLength = this.frameLength - this.startFramePosition;
                }
            } else {
                loopLength = this.stopFramePosition - this.startFramePosition;
            }
            long overLoops = 0L;
            if (loopLength > 0L) {
                overLoops = (framePos - this.stopFramePosition) / loopLength;
            }
            long loops = 1L + overLoops;
            this.streamPosOffset += loops * loopLength;
            this.loopOffsets = (int)((long)this.loopOffsets - loops);
            framePos = linePos - this.streamPosOffset;
        }
        return framePos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelInfo[] getLevelInfos() {
        BufferLevelInfoArray bufferLevelInfoArray = this.bufferInfos;
        synchronized (bufferLevelInfoArray) {
            long currentFramePosition = this.getFramePosition();
            LevelInfo[] lis = this.bufferInfos.intervalLevelInfos(this.lastLevelCheckposition, currentFramePosition);
            this.lastLevelCheckposition = currentFramePosition;
            if (!this.isPlaying() || lis == null) {
                if (this.format != null) {
                    int channels = this.format.getChannels();
                    for (int ch = 0; ch < channels; ++ch) {
                        this.zeroLevelInfos[ch].setPeakLevelHold(this.peakLevelHolds[ch]);
                    }
                    return this.zeroLevelInfos;
                }
                return null;
            }
            return lis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int read = 0;
        int offset = 0;
        int written = 0;
        long totalWritten = 0L;
        AudioFormat format = this.ais.getFormat();
        int frameSize = format.getFrameSize();
        while (this.running) {
            while (this.running && !State.PLAY.equals((Object)this.status)) {
                this.streaming = false;
                Object object = this.streamNotify;
                synchronized (object) {
                    this.streamNotify.notifyAll();
                }
                object = this.streamNotify;
                synchronized (object) {
                    try {
                        this.streamNotify.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.running) break;
            this.streaming = true;
            Object object = this.streamNotify;
            synchronized (object) {
                this.streamNotify.notifyAll();
            }
            if (this.avail == 0) {
                long toRead = this.bufferSize;
                if (this.stopFramePosition != -1L && (toRead = (this.stopFramePosition - this.streamFramePosition) * (long)frameSize) > (long)this.bufferSize) {
                    toRead = this.bufferSize;
                }
                if (toRead <= 0L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    read = -1;
                } else {
                    try {
                        read = this.ais.read(this.buffer, 0, (int)toRead);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.apETA.fireEvent((EventObject)new PlayerErrorEvent(e));
                    }
                    if (read > 0) {
                        this.avail += read;
                        this.streamFramePosition += (long)(read / frameSize);
                        offset = 0;
                    }
                }
            }
            if (this.avail > 0) {
                int lineAvailable = this.line.available();
                written = this.avoidWriteLock && lineAvailable < this.avail ? 0 : this.line.write(this.buffer, offset, this.avail);
                totalWritten += (long)written;
                if (written != this.avail && written == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if ((offset += written) == this.bufferSize) {
                    offset = 0;
                }
                this.avail -= written;
                continue;
            }
            if (read != -1) continue;
            if (this.looping) {
                try {
                    if (this.startFramePosition < this.streamFramePosition) {
                        this.resetAudioStream();
                    }
                    if (this.ais != null) {
                        for (long toSkip = (long)frameSize * (this.startFramePosition - this.streamFramePosition); toSkip > 0L; toSkip -= this.ais.skip(toSkip)) {
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Send error event");
                    this.apETA.fireEvent((EventObject)new PlayerErrorEvent(e));
                }
                ++this.loopOffsets;
                this.streamFramePosition = this.startFramePosition;
                continue;
            }
            if (totalWritten > 0L) {
                object = this.streamNotify;
                synchronized (object) {
                    this.status = State.DRAINING;
                }
                this.line.drain();
            }
            if (this.status.equals((Object)State.PAUSE)) {
                this.line.stop();
                this.syncPosition();
            }
            object = this.streamNotify;
            synchronized (object) {
                if (!(State.STOP.equals((Object)this.status) || State.CLOSE.equals((Object)this.status) || State.CLOSING.equals((Object)this.status))) {
                    this.status = State.STOP;
                    this.apETA.fireEvent((EventObject)new PlayerEndOfMediaEvent(this));
                }
            }
        }
        this.streaming = false;
        Object object = this.streamNotify;
        synchronized (object) {
            this.streamNotify.notifyAll();
        }
    }

    public boolean isOpen() {
        return !State.CLOSE.equals((Object)this.status);
    }

    private void syncPosition() {
        if (this.line == null || !this.isOpen()) {
            this.streamPosOffset = 0L;
            return;
        }
        this.loopOffsets = 0;
        long linePosition = this.line.getLongFramePosition();
        this.streamPosOffset = linePosition - this.streamFramePosition;
    }

    public synchronized void addPlayerListener(PlayerListener pl) {
        this.apETA.addListener((EventListener)((Object)pl));
    }

    public synchronized void removePlayerListener(PlayerListener pl) {
        this.apETA.removeListener((EventListener)((Object)pl));
    }

    public long getStartFramePosition() {
        return this.startFramePosition;
    }

    public void setStartFramePosition(long startFramePosition) {
        this.startFramePosition = startFramePosition;
        this.lastLevelCheckposition = startFramePosition;
        try {
            this.setFramePosition(startFramePosition);
        }
        catch (PlayerException e) {
            e.printStackTrace();
        }
    }

    public long getStopFramePosition() {
        return this.stopFramePosition;
    }

    public void setStopFramePosition(long stopFramePosition) {
        this.stopFramePosition = stopFramePosition;
        try {
            this.setFramePosition(this.startFramePosition);
        }
        catch (PlayerException e) {
            e.printStackTrace();
        }
    }

    public synchronized void setSelection(long startFramePosition, long stopFramePosition) throws PlayerException {
        this.startFramePosition = startFramePosition;
        this.stopFramePosition = stopFramePosition;
        this.setFramePosition(startFramePosition);
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public void setMixer(Mixer newPlaybackMixer) throws PlayerException {
        if (!State.CLOSE.equals((Object)this.status)) {
            throw new PlayerException("Player must be closed to set new mixer !");
        }
        this.device = newPlaybackMixer;
        this.line = null;
    }

    public int getPreferredBufferSize() {
        return this.preferredBufferSize;
    }

    public void setPreferredBufferSize(int preferredBufferSize) {
        this.preferredBufferSize = preferredBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setPeakLevelHold(float[] peakLevels) {
        this.peakLevelHolds = peakLevels;
    }

    public void resetPeakHold() {
        if (this.format != null) {
            int channels = this.format.getChannels();
            this.peakLevelHolds = new float[channels];
            this.zeroLevelInfos = new LevelInfo[channels];
            for (int ch = 0; ch < channels; ++ch) {
                this.zeroLevelInfos[ch] = new LevelInfo();
            }
        }
    }

    public SourceDataLine getLine() {
        return this.line;
    }

    public AudioSource getAudioSource() {
        return this.audioSource;
    }

    public boolean isAvoidWriteLock() {
        return this.avoidWriteLock;
    }

    public void setAvoidWriteLock(boolean avoidWriteLock) {
        this.avoidWriteLock = avoidWriteLock;
    }

    public Integer getPreferredLineBufferSize() {
        return this.preferredLineBufferSize;
    }

    public void setPreferredLineBufferSize(Integer preferredLineBufferSize) {
        this.preferredLineBufferSizeMillis = null;
        this.preferredLineBufferSize = preferredLineBufferSize;
    }

    public Float getPreferredLineBufferSizeMillis() {
        return this.preferredLineBufferSizeMillis;
    }

    public void setPreferredLineBufferSizeMillis(Float preferredLineBufferSizeMillis) {
        this.preferredLineBufferSize = null;
        this.preferredLineBufferSizeMillis = preferredLineBufferSizeMillis;
    }

    public boolean isUseAWTEventThread() {
        return this.apETA.isEventsInAWTEventThread();
    }

    public void setUseAWTEventThread(boolean useAWTEventThread) {
        this.apETA.setEventsInAWTEventThread(useAWTEventThread);
    }

    public boolean isMeasureLevel() {
        return this.measureLevel;
    }

    public void setMeasureLevel(boolean measureLevel) {
        this.measureLevel = measureLevel;
    }

    public boolean isForceOpening() {
        return this.forceOpening;
    }

    public void setForceOpening(boolean forceOpening) {
        this.forceOpening = forceOpening;
    }

    public ChannelRouting getChannelRouting() {
        return this.channelRouting;
    }

    public void setChannelRouting(ChannelRouting channelRouting) {
        this.channelRouting = channelRouting;
    }

    public int getChannelOffset() {
        return this.channelOffset;
    }

    public void setChannelOffset(int channelOffset) {
        this.channelOffset = channelOffset;
    }

    private static void printUsage() {
        System.out.println("Audio player version " + Player.class.getPackage().getImplementationVersion() + "\nUsage: java " + Player.class.getName() + " [-v] audiofilename\n       Plays audiofile.\n       java " + Player.class.getName() + " -h\n       Displays this help page.\nOptions:\n         -v verbose mode.");
    }

    public static void main(String[] args) {
        boolean verbose;
        OptionParser op = new OptionParser();
        Option verboseOption = new Option("v");
        Option helpOption = new Option("h");
        op.addOption(verboseOption);
        op.addOption(helpOption);
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(-1);
        }
        if (helpOption.isSet()) {
            Player.printUsage();
            System.exit(0);
        }
        if (verbose = verboseOption.isSet()) {
            System.out.println("Audio player version " + Player.class.getPackage().getImplementationVersion());
        }
        String[] params = op.getParams();
        Player p = null;
        p = new Player();
        p.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
        p.setUseAWTEventThread(false);
        p.setMeasureLevel(false);
        Shutdown shutDown = new Shutdown(p, verbose);
        File playFile = null;
        if (params.length == 0) {
            Player.printUsage();
            System.exit(-1);
        } else if (params.length == 1) {
            try {
                URL url = new URL(params[0]);
                String urlProto = url.getProtocol();
                if (!urlProto.equalsIgnoreCase("file")) {
                    System.err.println("Only file protocol URL's are supported !");
                    System.exit(-1);
                }
                playFile = new File(url.toURI().getPath());
            }
            catch (MalformedURLException e1) {
                playFile = new File(params[0]);
            }
            catch (URISyntaxException e) {
                playFile = new File(params[0]);
            }
        }
        Runtime.getRuntime().addShutdownHook(shutDown);
        try {
            p.setAudioSource(new ConvenienceFileAudioSource(playFile));
            if (verboseOption.isSet()) {
                System.out.println("Audio source set.");
            }
        }
        catch (PlayerException e2) {
            System.err.println("Could not set audio source !");
            if (verbose) {
                e2.printStackTrace();
            }
            System.exit(-1);
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        p.addPlayerListener(new PlayerListener(){

            @Override
            public void update(PlayerEvent playerEvent) {
                if (playerEvent instanceof PlayerStopEvent) {
                    if (verbose) {
                        System.out.println("Player stop.");
                    }
                    try {
                        ((Player)playerEvent.getSource()).close();
                    }
                    catch (PlayerException e) {
                        e.printStackTrace();
                    }
                } else if (playerEvent instanceof PlayerCloseEvent && verbose) {
                    System.out.println("Player closed.");
                }
            }
        });
        try {
            p.open();
            if (verbose) {
                System.out.println("Player opened.");
            }
        }
        catch (PlayerException e1) {
            System.err.println("Could not open player !");
            if (verbose) {
                e1.printStackTrace();
            }
            System.exit(-1);
        }
        p.start();
        if (verbose) {
            System.out.println("Player started.\nInterrupt with Ctrl-C.");
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (!State.CLOSING.equals((Object)this.status) && !State.CLOSE.equals((Object)this.status)) {
            if (LineEvent.Type.CLOSE.equals(type)) {
                try {
                    this.close();
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                }
            } else if (LineEvent.Type.STOP.equals(type) && !State.STOP.equals((Object)this.status) && !State.STOPPING.equals((Object)this.status) && !State.PAUSE.equals((Object)this.status)) {
                this.stop();
            }
        }
    }

    private static class Shutdown
    extends Thread {
        private Player player;
        private boolean verbose = false;

        public Shutdown(Player p, boolean verbose) {
            this.player = p;
            this.verbose = verbose;
        }

        @Override
        public void run() {
            block4: {
                try {
                    if (this.player.isOpen()) {
                        if (this.verbose) {
                            System.out.println("Player closing...");
                        }
                        this.player.close();
                    }
                }
                catch (PlayerException e) {
                    System.err.println("Could not close player !");
                    if (!this.verbose) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private static enum State {
        CLOSE,
        STOP,
        PLAY,
        PAUSE,
        DRAINING,
        STOPPING,
        CLOSING,
        ERROR;

    }
}

