/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioPluginException;
import ipsk.audio.plugins.BasicPCMPlugin;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class BasicPCMSignedAndFloatPlugin
extends BasicPCMPlugin {
    protected AudioFormat[] supportedFloatAudioFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, -1, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, -1, -1, -1, -1.0f, false)};
    protected AudioFormat[] allSupportedAudioFormats = (AudioFormat[])Stream.concat(Arrays.stream(this.supportedAudioFormats), Arrays.stream(this.supportedFloatAudioFormats)).toArray(AudioFormat[]::new);

    @Override
    public abstract AudioInputStream getAudioInputStream(AudioInputStream var1) throws AudioPluginException;

    @Override
    public boolean isInputFormatSupported(AudioFormat audioFormat) {
        boolean basicSupported = super.isInputFormatSupported(audioFormat);
        if (basicSupported) {
            return basicSupported;
        }
        for (int i = 0; i < this.supportedFloatAudioFormats.length; ++i) {
            AudioFormat suppFormat = this.supportedFloatAudioFormats[i];
            if (!suppFormat.getEncoding().equals(audioFormat.getEncoding()) || suppFormat.getSampleRate() != -1.0f && suppFormat.getSampleRate() != audioFormat.getSampleRate() || suppFormat.getChannels() != -1 && (suppFormat.getChannels() != audioFormat.getChannels() || suppFormat.getFrameRate() != -1.0f && suppFormat.getFrameRate() != audioFormat.getFrameRate())) continue;
            return true;
        }
        return false;
    }

    @Override
    public AudioFormat[] getSupportedInputFormats() {
        return this.allSupportedAudioFormats;
    }
}

