/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPluginException;
import ipsk.audio.dsp.FloatToPCMAudioInputStream;
import ipsk.audio.dsp.VolumeControlStream;
import ipsk.audio.plugins.BasicPCMPlugin;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.FloatControl;

public class VolumeControlPlugin
extends BasicPCMPlugin {
    private VolumeControlStream vcis = null;
    private double gainRatio = 1.0;

    public VolumeControlPlugin() {
        this.supportedAudioFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, -1, -1, -1.0f, false)};
    }

    public void setVolume(float newValue) {
        this.gainRatio = newValue;
        if (this.vcis != null) {
            this.vcis.setVolume(newValue);
        }
    }

    public void setGainRatio(double newValue) {
        this.gainRatio = newValue;
        if (this.vcis != null) {
            this.vcis.setGainRatio(this.gainRatio);
        }
    }

    public void setVolumeInDezibel(float volumeInDezibel) {
        double gr = Math.pow(10.0, (double)volumeInDezibel / 20.0);
        this.setGainRatio(gr);
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream source) throws AudioPluginException {
        FloatToPCMAudioInputStream fToPCM;
        AudioFormat oFormat = this.getOutputFormat();
        if (oFormat == null) {
            try {
                this.setOutputFormat(source.getFormat());
            }
            catch (AudioFormatNotSupportedException e) {
                e.printStackTrace();
                throw new AudioPluginException(e);
            }
        }
        try {
            this.vcis = new VolumeControlStream(source, true);
            this.vcis.setGainRatio(this.gainRatio);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new AudioPluginException(e);
        }
        try {
            fToPCM = new FloatToPCMAudioInputStream(this.vcis, this.getOutputFormat());
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
            throw new AudioPluginException(e);
        }
        return fToPCM;
    }

    public class VolumeControl
    extends FloatControl {
        public VolumeControl() {
            super(FloatControl.Type.VOLUME, 0.0f, 1.0f, 0.1f, 1, 1.0f, "");
        }

        @Override
        public void setValue(float newValue) {
            VolumeControlPlugin.this.setVolume(newValue);
        }
    }
}

