/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tests;

import ips.dsp.FIRFilter;
import ips.dsp.FIRFilterBuilder;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.FloatToPCMInputStream;
import ipsk.io.FloatStream;
import ipsk.io.InterleavedFloatStream;
import ipsk.io.InterleavedFloatStreamMonoAdapter;
import ipsk.math.Complex;
import ipsk.math.random.GaussianDistributionRandomGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class FIRFilterTest {
    private GaussianDistributionRandomGenerator whiteNoise;

    public FIRFilterTest() {
        double[] coeff;
        int i;
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
        long frameLength = 1000000L;
        this.whiteNoise = new GaussianDistributionRandomGenerator(0.0, 0.1, frameLength);
        Complex[] impulseResponse = new Complex[300];
        for (i = 0; i < 100; ++i) {
            impulseResponse[i] = new Complex(0.0, 0.0);
        }
        while (i < 200) {
            impulseResponse[i] = new Complex(1.0, 0.0);
            ++i;
        }
        while (i < 300) {
            impulseResponse[i] = new Complex(0.0, 0.0);
            ++i;
        }
        for (double d : coeff = FIRFilterBuilder.buildCoefficientsFromImpulsResponse((Complex[])impulseResponse)) {
            System.out.println(d);
        }
        FIRFilter fir = new FIRFilter((FloatStream)this.whiteNoise, coeff);
        InterleavedFloatStreamMonoAdapter ia = new InterleavedFloatStreamMonoAdapter((FloatStream)fir);
        try {
            FloatToPCMInputStream fToPCM = new FloatToPCMInputStream((InterleavedFloatStream)ia, audioFormat);
            AudioInputStream ais = new AudioInputStream((InputStream)((Object)fToPCM), audioFormat, frameLength);
            AudioSystem.write(ais, AudioFileFormat.Type.WAVE, new File("test.wav"));
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new FIRFilterTest();
    }
}

