/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tools;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class RepeatFinder {
    static final boolean DEBUG = false;
    int bufLen;
    int toCompare;
    Vector<byte[]> bufs;
    File f;
    AudioInputStream ais = null;
    boolean verbose = false;

    public RepeatFinder(File f, int bufLen, int toCompare) {
        this.f = f;
        this.bufLen = bufLen;
        this.toCompare = toCompare;
        this.bufs = new Vector();
        try {
            this.ais = AudioSystem.getAudioInputStream(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read() {
        if (this.verbose) {
            System.out.println("Reading " + this.f);
        }
        int read = 0;
        while (read >= 0) {
            byte[] b = new byte[this.bufLen];
            try {
                read = this.ais.read(b, 0, this.bufLen);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bufs.add(b);
        }
    }

    public void findRepeats() {
        if (this.verbose) {
            System.out.print("Checking buffer ");
        }
        for (int i = 0; i < this.bufs.size(); ++i) {
            if (this.verbose) {
                System.out.print(i + " ");
            }
            byte[] b1 = this.bufs.elementAt(i);
            for (int j = i + 1; j < this.bufs.size(); ++j) {
                byte[] b2 = this.bufs.elementAt(j);
                boolean equal = true;
                for (int s = 0; s < this.toCompare; ++s) {
                    equal &= b1[s] == b2[s];
                }
                if (!equal) continue;
                if (this.verbose) {
                    System.out.println();
                }
                System.out.println(this.f + " equality_detected " + i + " = " + j);
            }
        }
    }

    public static void main(String[] args) {
        int toCmp = Integer.parseInt(args[0]);
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]);
            RepeatFinder cf = null;
            try {
                cf = new RepeatFinder(f, 4096, toCmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cf.read();
            cf.findRepeats();
        }
    }
}

