/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.AudioController;
import ipsk.audio.AudioControllerListener;
import ipsk.audio.ui.ConfigurationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class AudioControllerUI
extends JPanel
implements AudioControllerListener,
ActionListener {
    private static final long serialVersionUID = 8962245630129391681L;
    private static final boolean DEBUG = false;
    private ResourceBundle rb;
    private ConfigurationPanel cp;

    public AudioControllerUI(AudioController ac) {
        super(new BorderLayout());
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(packageName + ".ResBundle");
        this.cp = new ConfigurationPanel(ac);
        this.add((Component)((Object)this.cp), "Center");
        ac.addAudioControllerListener(this);
        this.cp.update();
        this.revalidate();
        this.repaint();
    }

    public void update() {
        this.cp.update();
    }

    @Override
    public void update(AudioController.PlaybackStatus pe, AudioController.CaptureStatus ce) {
        String ps = null;
        String cs = null;
        if (pe != null) {
            ps = pe.getStatus();
        }
        if (ce != null) {
            cs = ce.getStatus();
        }
        if (ps == "Configured" || cs == "Configured") {
            this.cp.update();
            this.revalidate();
            this.repaint();
        } else if (cs == "Saved") {
            // empty if block
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public String getTitle() {
        return this.rb.getString("configuration");
    }
}

