/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.Profile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioFormatChooser
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5942375846853236665L;
    static final boolean DEBUG = false;
    private static final int MAX_CHANNELS = 32;
    private static final int MAX_FRAME_SIZE_BYTES = 4;
    protected GridBagConstraints c = new GridBagConstraints();
    private String UNKNOWN_STRING = new String("Unknown");
    private JComboBox<Integer> sampleSizeBox;
    private AudioFormat audioFormat;
    private float[] sampleRatesF = new float[]{8000.0f, 11025.0f, 16000.0f, 22050.0f, 32000.0f, 44100.0f, 48000.0f, 96000.0f};
    private Float[] sampleRates;
    private Integer[] numChannelArr = new Integer[32];
    private JComboBox<String> endianBox;
    private String bigEndianStr;
    private String littleEndianStr;
    private String[] byteOrderStrs = new String[]{this.UNKNOWN_STRING, this.bigEndianStr, this.littleEndianStr};
    private AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ALAW, AudioFormat.Encoding.ULAW};
    private Integer[] frameSizes = new Integer[4];
    private JComboBox<Float> sampleRateBox;
    private JComboBox<Integer> numChannelsBox;
    private JComboBox<AudioFormat.Encoding> encodingBox;
    private boolean enabled = true;
    protected Vector<ChangeListener> listeners;
    protected ResourceBundle resourceBundle;
    private Profile profile = null;
    public static float DEF_SAMPLE_RATE = 44100.0f;
    public static int DEF_SAMPLE_SIZE_IN_BITS = 16;
    public static int DEF_CHANNELS = 2;
    public static boolean DEF_SIGNED = true;
    public static boolean DEF_BIG_ENDIAN = false;
    public static AudioFormat DEF_AUDIOFORMAT = new AudioFormat(DEF_SAMPLE_RATE, DEF_SAMPLE_SIZE_IN_BITS, DEF_CHANNELS, DEF_SIGNED, DEF_BIG_ENDIAN);

    public AudioFormatChooser() {
        this(DEF_AUDIOFORMAT);
    }

    public AudioFormatChooser(AudioFormat audioFormat) {
        super(new GridBagLayout());
        this.audioFormat = audioFormat;
        String packageName = this.getClass().getPackage().getName();
        this.resourceBundle = ResourceBundle.getBundle(packageName + ".ResBundle");
        this.c.fill = 2;
        this.c.insets = new Insets(2, 5, 2, 5);
        this.c.weightx = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.listeners = new Vector();
        JLabel sampleRateLabel = new JLabel(this.resourceBundle.getString("samplerate") + ":");
        this.add((Component)sampleRateLabel, this.c);
        this.sampleRates = new Float[this.sampleRatesF.length];
        for (int i = 0; i < this.sampleRatesF.length; ++i) {
            this.sampleRates[i] = Float.valueOf(this.sampleRatesF[i]);
        }
        this.sampleRateBox = new JComboBox<Float>(this.sampleRates);
        this.sampleRateBox.setEnabled(this.enabled);
        ++this.c.gridx;
        this.add(this.sampleRateBox, this.c);
        ++this.c.gridx;
        this.add((Component)new JLabel("Hz"), this.c);
        JLabel channelLabel = new JLabel(this.resourceBundle.getString("channels") + ":");
        this.c.gridx = 0;
        ++this.c.gridy;
        this.add((Component)channelLabel, this.c);
        for (int i = 0; i < 32; ++i) {
            this.numChannelArr[i] = i + 1;
        }
        this.numChannelsBox = new JComboBox<Integer>(this.numChannelArr);
        ++this.c.gridx;
        this.add(this.numChannelsBox, this.c);
        JLabel endianLabel = new JLabel(this.resourceBundle.getString("byteorder") + ":");
        this.c.gridx = 0;
        ++this.c.gridy;
        this.add((Component)endianLabel, this.c);
        this.bigEndianStr = this.resourceBundle.getString("bigEndian");
        this.littleEndianStr = this.resourceBundle.getString("littleEndian");
        this.byteOrderStrs = new String[]{this.bigEndianStr, this.littleEndianStr};
        this.endianBox = new JComboBox<String>(this.byteOrderStrs);
        ++this.c.gridx;
        this.add(this.endianBox, this.c);
        JLabel encodingLabel = new JLabel(this.resourceBundle.getString("encoding") + ":");
        this.c.gridx = 0;
        ++this.c.gridy;
        this.add((Component)encodingLabel, this.c);
        this.encodingBox = new JComboBox<AudioFormat.Encoding>(this.encodings);
        ++this.c.gridx;
        this.c.weightx = 1.0;
        this.add(this.encodingBox, this.c);
        JLabel sampleSizeLabel = new JLabel(this.resourceBundle.getString("samplesize") + ":");
        this.c.gridx = 0;
        ++this.c.gridy;
        this.add((Component)sampleSizeLabel, this.c);
        for (int i = 0; i < 4; ++i) {
            this.frameSizes[i] = (i + 1) * 8;
        }
        this.sampleSizeBox = new JComboBox<Integer>(this.frameSizes);
        ++this.c.gridx;
        this.add(this.sampleSizeBox, this.c);
        ++this.c.gridx;
        this.add((Component)new JLabel("bits"), this.c);
        this.setAudioFormat(audioFormat);
        this.sampleRateBox.addActionListener(this);
        this.numChannelsBox.addActionListener(this);
        this.endianBox.addActionListener(this);
        this.encodingBox.addActionListener(this);
        this.sampleSizeBox.addActionListener(this);
        this.revalidate();
        this.repaint();
    }

    void createRadioButtonGroup(JPanel target, String[] buttonNames) {
        ButtonGroup bg = new ButtonGroup();
        int numButtons = buttonNames.length;
        JRadioButton[] radioButtons = new JRadioButton[numButtons];
        for (int i = 0; i < numButtons; ++i) {
            radioButtons[i] = new JRadioButton(buttonNames[i]);
            target.add(radioButtons[i]);
            bg.add(radioButtons[i]);
        }
    }

    public void setAudioFormat(AudioFormat newFormat) {
        if (newFormat == null) {
            newFormat = DEF_AUDIOFORMAT;
        }
        this.sampleRateBox.setSelectedItem(Float.valueOf(newFormat.getSampleRate()));
        this.numChannelsBox.setSelectedItem(newFormat.getChannels());
        if (newFormat.isBigEndian()) {
            this.endianBox.setSelectedItem(this.bigEndianStr);
        } else {
            this.endianBox.setSelectedItem(this.littleEndianStr);
        }
        this.encodingBox.setSelectedItem(newFormat.getEncoding());
        this.sampleSizeBox.setSelectedItem(newFormat.getSampleSizeInBits());
        this.audioFormat = newFormat;
    }

    public AudioFormat getAudioFormat() {
        AudioFormat.Encoding ae = (AudioFormat.Encoding)this.encodingBox.getSelectedItem();
        float sampleRate = ((Float)this.sampleRateBox.getSelectedItem()).floatValue();
        int channels = (Integer)this.numChannelsBox.getSelectedItem();
        boolean bigEndian = this.endianBox.getSelectedItem() == this.bigEndianStr;
        int sampleSizeInBits = (Integer)this.sampleSizeBox.getSelectedItem();
        int frameSize = sampleSizeInBits / 8 * channels;
        AudioFormat af = new AudioFormat(ae, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, bigEndian);
        return af;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        AudioFormat newAudioFormat = this.getAudioFormat();
        if (!this.audioFormat.equals(newAudioFormat)) {
            this.audioFormat = newAudioFormat;
            Enumeration<ChangeListener> e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ChangeListener cl = e.nextElement();
                cl.stateChanged(new ChangeEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        if (cl != null && !this.listeners.contains(cl)) {
            Vector<ChangeListener> vector = this.listeners;
            synchronized (vector) {
                this.listeners.addElement(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            Vector<ChangeListener> vector = this.listeners;
            synchronized (vector) {
                this.listeners.removeElement(cl);
            }
        }
    }

    public static AudioFormat showDialog(Component parent, AudioFormat initialFormat) {
        AudioFormatChooser afc = new AudioFormatChooser();
        afc.setAudioFormat(initialFormat);
        JOptionPane selPane = new JOptionPane(afc, -1, 2);
        JDialog d = selPane.createDialog(parent, "Audio format chooser");
        d.setVisible(true);
        Object selectedValue = selPane.getValue();
        if (selectedValue == null) {
            return initialFormat;
        }
        if (selectedValue instanceof Integer) {
            int value = (Integer)selectedValue;
            if (value == 0) {
                return afc.getAudioFormat();
            }
            return initialFormat;
        }
        return initialFormat;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("AudioFormatChooser");
        AudioFormatChooser afc = new AudioFormatChooser();
        f.getContentPane().add(afc);
        f.pack();
        f.setVisible(true);
        afc.setProfile(Profile.SPEECH_RECORDING);
        afc.setAudioFormat(new AudioFormat(11025.0f, 16, 1, true, true));
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        afc.setAudioFormat(new AudioFormat(96000.0f, 8, 5, false, false));
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }
}

