/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.AudioController;
import ipsk.audio.AudioControllerException;
import ipsk.audio.mixer.ui.MixerDevicesUI;
import ipsk.audio.ui.AudioFormatChooser;
import ipsk.audio.ui.OptionsPanel;
import ipsk.swing.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.sound.sampled.AudioSystem;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class ConfigurationPanel
extends TitledPanel
implements ActionListener {
    private static final long serialVersionUID = -9147443427426921238L;
    private static final boolean DEBUG = false;
    private MixerDevicesUI mp;
    private AudioFormatChooser afc;
    private OptionsPanel ms;
    private AudioController ac;
    private JTabbedPane configPanels;
    private JButton applyButton;
    private ResourceBundle rb;

    public ConfigurationPanel(AudioController ac) {
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(packageName + ".ResBundle");
        super.setTitle(this.rb.getString("configuration"));
        this.setLayout(new BorderLayout());
        this.ac = ac;
        this.configPanels = new JTabbedPane();
        this.mp = new MixerDevicesUI();
        this.configPanels.addTab(this.rb.getString("mixer"), this.mp);
        this.afc = new AudioFormatChooser();
        this.configPanels.addTab(this.rb.getString("audio_format"), this.afc);
        this.ms = new OptionsPanel();
        this.configPanels.addTab(this.rb.getString("options"), this.ms);
        this.add(this.configPanels, "North");
        this.applyButton = new JButton(this.rb.getString("apply"));
        this.add(this.applyButton, "South");
        this.applyButton.addActionListener(this);
        this.revalidate();
        this.repaint();
        this.update();
    }

    public void setEnabled(boolean enabled) {
        this.mp.setEnabled(enabled);
    }

    public void update() {
        this.mp.setSelectedPlaybackMixer(AudioSystem.getMixer(this.ac.getSourceMixerInfo()));
        this.mp.setSelectedCaptureMixer(AudioSystem.getMixer(this.ac.getTargetMixerInfo()));
        this.afc.setAudioFormat(this.ac.getAudioFormat());
        this.ms.setOverwrite(this.ac.isOverwrite());
        this.ms.setMode(this.ac.getMode());
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        String pss = this.ac.getPlaybackStatus().getStatus();
        String css = this.ac.getCaptureStatus().getStatus();
        try {
            if (pss == "Playing" || pss == "Pause" || css == "Recording" || css == "Capturing" || css == "Busy" || css == "Paused") {
                throw new AudioControllerException("Controller must be stopped to reconfigure !");
            }
            this.ac.close();
            this.ac.setSourceMixer(this.mp.getSelectedPlaybackMixer().getMixerInfo());
            this.ac.setTargetMixer(this.mp.getSelectedCaptureMixer().getMixerInfo());
            this.ac.setAudioFormat(this.afc.getAudioFormat());
            this.ac.setOverwrite(this.ms.getOverwrite());
            this.ac.setMode(this.ms.getMode());
            this.ac.configure();
            this.ac.open();
        }
        catch (AudioControllerException ex) {
            JOptionPane.showMessageDialog((Component)((Object)this), ex.getLocalizedMessage(), "AudioController Error", 0);
            System.err.println(ex.getLocalizedMessage());
        }
    }
}

