/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.AudioController;
import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioControllerListener;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.impl.j2audio.J2AudioController;
import ipsk.swing.TitledPanel;
import ipsk.text.MediaTimeFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransportPanel
extends TitledPanel
implements ActionListener,
ChangeListener,
AudioControllerListener,
Runnable {
    private static final long serialVersionUID = -4764342647806380021L;
    private static final boolean DEBUG = false;
    static final int STOP = 0;
    static final int PAUSE = 1;
    static final int PLAY_PAUSE = 2;
    static final int PLAY = 3;
    static final int REC_PAUSE = 4;
    static final int REC = 5;
    static final int BUSY = 6;
    static final int CLOSE = 7;
    private boolean pendingStart = false;
    private boolean posUpdate;
    private long playbackFramePos;
    private long playbackFrameLength;
    private boolean running;
    private AudioController ac;
    private int status = 7;
    private JButton playB;
    private JButton recB;
    private JButton stopB;
    private JButton pauseB;
    private JTextField framePosLabel;
    private Thread updateThread;
    private JPanel buttonPanel;
    private JPanel posPanel;
    private JSlider posSlider;
    private JSlider startPosSlider;
    private JSlider stopPosSlider;
    private long startPosition;
    private long stopPosition;
    private MediaTimeFormat timeFormatter;

    public TransportPanel(AudioController ac) {
        super("Transport");
        this.ac = ac;
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel(new FlowLayout());
        this.framePosLabel = new JTextField("0", 10);
        this.framePosLabel.setEditable(false);
        this.framePosLabel.setHorizontalAlignment(4);
        this.createButtons(this.buttonPanel);
        this.add(this.buttonPanel, "North");
        this.posUpdate = true;
        this.posSlider = new JSlider();
        this.posSlider.setMinimum(0);
        this.posSlider.setMaximum(100000);
        this.posSlider.setMajorTickSpacing(500000);
        this.posSlider.setPaintTicks(true);
        this.posSlider.setEnabled(false);
        this.posSlider.addChangeListener(this);
        this.startPosSlider = new JSlider();
        this.startPosSlider.setValue(0);
        this.startPosSlider.setEnabled(false);
        this.stopPosSlider = new JSlider();
        this.stopPosSlider.setValue(this.stopPosSlider.getMaximum());
        this.stopPosSlider.setEnabled(false);
        this.startPosSlider.addChangeListener(this);
        this.stopPosSlider.addChangeListener(this);
        this.posPanel = new JPanel(new GridLayout(4, 1));
        this.posPanel.add(this.framePosLabel);
        this.posPanel.add(this.posSlider);
        this.posPanel.add(this.startPosSlider);
        this.posPanel.add(this.stopPosSlider);
        this.add(this.posPanel, "Center");
        ac.addAudioControllerListener(this);
        this.setStatus(7);
        this.timeFormatter = new MediaTimeFormat();
        this.validate();
        this.repaint();
        this.updateThread = new Thread(this);
        this.updateThread.setPriority(1);
        this.running = true;
        this.updateThread.start();
        this.posUpdate = false;
    }

    public void setStatus(int newStatus) {
        this.status = newStatus;
        switch (this.status) {
            case 6: 
            case 7: {
                this.posSlider.setEnabled(false);
                this.playB.setEnabled(false);
                this.playB.setBackground(Color.GREEN.darker());
                this.recB.setEnabled(false);
                this.recB.setBackground(Color.RED.darker());
                this.stopB.setEnabled(false);
                this.stopB.setBackground(Color.YELLOW.darker());
                this.pauseB.setEnabled(false);
                this.pauseB.setBackground(Color.YELLOW.darker());
                break;
            }
            case 0: {
                this.posSlider.setEnabled(false);
                this.playB.setEnabled(true);
                this.playB.setBackground(Color.GREEN.darker());
                this.recB.setEnabled(true);
                this.recB.setBackground(Color.RED.darker());
                this.stopB.setEnabled(false);
                this.stopB.setBackground(Color.YELLOW);
                this.pauseB.setEnabled(true);
                this.pauseB.setBackground(Color.YELLOW.darker());
                break;
            }
            case 1: {
                this.posSlider.setEnabled(true);
                this.playB.setEnabled(true);
                this.playB.setBackground(Color.GREEN.darker());
                this.recB.setEnabled(true);
                this.recB.setBackground(Color.RED.darker());
                this.stopB.setEnabled(true);
                this.stopB.setBackground(Color.YELLOW.darker());
                this.pauseB.setEnabled(false);
                this.pauseB.setBackground(Color.YELLOW);
                break;
            }
            case 2: {
                this.posSlider.setEnabled(true);
                this.playB.setEnabled(true);
                this.playB.setBackground(Color.GREEN);
                this.recB.setEnabled(false);
                this.recB.setBackground(Color.RED.darker());
                this.stopB.setEnabled(true);
                this.stopB.setBackground(Color.YELLOW.darker());
                this.pauseB.setEnabled(true);
                this.pauseB.setBackground(Color.YELLOW);
                break;
            }
            case 4: {
                this.posSlider.setEnabled(false);
                this.playB.setEnabled(false);
                this.playB.setBackground(Color.GREEN.darker());
                this.recB.setEnabled(true);
                this.recB.setBackground(Color.RED);
                this.stopB.setEnabled(true);
                this.stopB.setBackground(Color.YELLOW.darker());
                this.pauseB.setEnabled(true);
                this.pauseB.setBackground(Color.YELLOW);
                break;
            }
            case 3: {
                this.posSlider.setEnabled(true);
                this.playB.setEnabled(false);
                this.playB.setBackground(Color.GREEN);
                this.recB.setEnabled(false);
                this.recB.setBackground(Color.RED.darker());
                this.stopB.setEnabled(true);
                this.stopB.setBackground(Color.YELLOW.darker());
                this.pauseB.setEnabled(true);
                this.pauseB.setBackground(Color.YELLOW.darker());
                break;
            }
            case 5: {
                this.posSlider.setEnabled(false);
                this.playB.setEnabled(false);
                this.playB.setBackground(Color.GREEN.darker());
                this.recB.setEnabled(false);
                this.recB.setBackground(Color.RED);
                this.stopB.setEnabled(true);
                this.stopB.setBackground(Color.YELLOW.darker());
                this.pauseB.setEnabled(false);
                this.pauseB.setBackground(Color.YELLOW.darker());
            }
        }
    }

    protected void createButtons(JPanel buttonPanel) {
        this.playB = new JButton("PLAY");
        this.playB.setBackground(Color.GREEN.darker());
        buttonPanel.add(this.playB);
        this.playB.addActionListener(this);
        this.recB = new JButton("REC");
        this.recB.setBackground(Color.RED.darker());
        buttonPanel.add(this.recB);
        this.recB.addActionListener(this);
        this.stopB = new JButton("STOP");
        this.stopB.setBackground(Color.YELLOW);
        buttonPanel.add(this.stopB);
        this.stopB.addActionListener(this);
        this.pauseB = new JButton("PAUSE");
        this.pauseB.setBackground(Color.YELLOW.darker());
        buttonPanel.add(this.pauseB);
        this.pauseB.addActionListener(this);
    }

    private boolean prepareRecordingInterActive() throws AudioControllerException, HeadlessException, IOException, LineUnavailableException, AudioFormatNotSupportedException {
        if (this.ac instanceof J2AudioController) {
            J2AudioController j2ac = (J2AudioController)this.ac;
            if (!j2ac.prepareRecording(false)) {
                String msg = new String();
                File[] recFiles = j2ac.getRecordingFiles();
                for (int i = 0; i < recFiles.length; ++i) {
                    if (recFiles[i].exists()) {
                        msg = msg.concat("'" + recFiles[i].getCanonicalPath() + "' already exists !\n");
                    }
                    if (JOptionPane.showConfirmDialog((Component)((Object)this), msg + " Do you want to overwrite ?", "Overwrite file(s) ?", 0) != 0) {
                        return false;
                    }
                    j2ac.prepareRecording(true);
                }
            }
        } else {
            this.ac.prepareRecording();
        }
        return true;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.recB) {
            try {
                if (this.status == 0) {
                    if (this.prepareRecordingInterActive()) {
                        this.ac.startRecording();
                    }
                } else if (this.status == 4) {
                    this.ac.startRecording();
                } else if (this.status == 1 && this.prepareRecordingInterActive()) {
                    this.ac.startCapture();
                }
            }
            catch (IOException e) {
                String errMsg = new String("I/O error:\n" + e.getLocalizedMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), errMsg, "I/O Error !", 0);
                System.err.println(errMsg);
            }
            catch (AudioFormatNotSupportedException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Error !", 0);
                System.err.println(e);
            }
            catch (LineUnavailableException e) {
                String errMsg = new String("Error opening audio device\n" + e.getMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), errMsg, "Error !", 0);
                System.err.println(errMsg);
            }
            catch (AudioControllerException e) {
                String errMsg = new String("Audio controller error\n" + e.getLocalizedMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), errMsg, "Audio controller error !", 0);
            }
        } else if (ae.getSource() == this.stopB) {
            try {
                if (this.status == 1) {
                    this.setStatus(0);
                } else if (this.status == 5) {
                    this.ac.stopRecording();
                } else if (this.status == 4) {
                    this.ac.stopCapture();
                } else if (this.status == 3) {
                    this.ac.stopPlayback();
                } else if (this.status == 2) {
                    this.ac.stopPlayback();
                }
            }
            catch (AudioControllerException e) {
                String errMsg = new String(e.getLocalizedMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), errMsg, "AudioController Error !", 0);
                System.err.println(errMsg);
            }
        } else if (ae.getSource() == this.playB) {
            try {
                if (this.status == 1) {
                    this.ac.preparePlayback();
                    this.ac.pausePlayback();
                } else if (this.status == 0) {
                    this.ac.preparePlayback();
                    this.ac.startPlayback();
                } else if (this.status == 2) {
                    this.ac.startPlayback();
                }
            }
            catch (AudioControllerException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getLocalizedMessage(), "AudioController Error !", 0);
                System.err.println(e);
            }
        } else if (ae.getSource() == this.pauseB) {
            try {
                if (this.ac.getPlaybackStatus().getStatus() == "Playing") {
                    this.ac.pausePlayback();
                } else if (this.status == 4) {
                    this.ac.startRecording();
                } else if (this.status == 2) {
                    this.ac.startPlayback();
                } else if (this.status == 0) {
                    this.setStatus(1);
                }
            }
            catch (AudioControllerException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getLocalizedMessage(), "AudioController Error !", 0);
                System.err.println(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        JSlider source = (JSlider)ev.getSource();
        if (!source.getValueIsAdjusting() && !this.posUpdate) {
            if (source == this.posSlider) {
                this.playbackFramePos = source.getValue();
                if (this.status == 2 && this.pendingStart) {
                    this.pendingStart = false;
                    try {
                        this.ac.setPlaybackFramePosition(this.playbackFramePos);
                        this.ac.startPlayback();
                    }
                    catch (AudioControllerException e) {
                        JOptionPane.showMessageDialog((Component)((Object)this), e.getLocalizedMessage(), "AudioController Error !", 0);
                        System.err.println(e.getLocalizedMessage());
                    }
                } else if (this.status == 2) {
                    this.ac.setPlaybackFramePosition(this.playbackFramePos);
                }
            } else if (source == this.startPosSlider) {
                this.startPosition = source.getValue();
                this.ac.setPlaybackStartFramePosition(this.startPosition);
            } else if (source == this.stopPosSlider) {
                this.stopPosition = source.getValue();
                this.ac.setPlaybackStopFramePosition(this.stopPosition);
            }
        } else if (source.getValueIsAdjusting() && !this.posUpdate && source == this.posSlider && this.status == 3) {
            try {
                this.ac.pausePlayback();
            }
            catch (AudioControllerException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getLocalizedMessage(), "AudioController Error !", 0);
                System.err.println(e.getLocalizedMessage());
            }
            this.pendingStart = true;
        }
    }

    private void configurePositionSliders() {
        this.posUpdate = true;
        this.playbackFrameLength = this.ac.getPlaybackFrameLength();
        this.posSlider.setMaximum((int)this.playbackFrameLength);
        this.startPosSlider.setMaximum((int)this.playbackFrameLength);
        this.startPosSlider.setValue((int)this.ac.getPlaybackStartFramePosition());
        this.stopPosSlider.setMaximum((int)this.playbackFrameLength);
        long stopPosition = this.ac.getPlaybackStopFramePosition();
        if (stopPosition == -1L) {
            this.stopPosSlider.setValue((int)this.playbackFrameLength);
        } else {
            this.stopPosSlider.setValue((int)stopPosition);
        }
        this.posUpdate = false;
        this.posSlider.setEnabled(true);
    }

    @Override
    public synchronized void update(AudioController.PlaybackStatus ps, AudioController.CaptureStatus cs) {
        if (ps != null) {
            String pss = ps.getStatus();
            if (pss == "Played" || pss == "Open") {
                this.setStatus(0);
                this.setPlaybackFramePosition();
            } else if (pss == "Playing") {
                this.setStatus(3);
            } else if (pss == "Pause") {
                this.setStatus(2);
            } else if (pss == "Prepared") {
                this.configurePositionSliders();
                this.setStatus(0);
            } else if (pss == "Closed") {
                this.setStatus(7);
            } else if (pss == "Files set") {
                // empty if block
            }
        }
        if (cs != null) {
            String css = cs.getStatus();
            if (css == "Recording") {
                this.setStatus(5);
            } else if (css == "Opened") {
                this.setStatus(0);
                this.playbackFrameLength = this.ac.getPlaybackFrameLength();
                this.configurePositionSliders();
            } else if (css == "Recorded") {
                this.setStatus(6);
            } else if (css == "Saved") {
                this.setStatus(0);
            } else if (css == "Paused" || css == "Capturing") {
                this.setStatus(4);
            } else if (css == "Closed") {
                this.setStatus(7);
            }
        }
    }

    private void setPlaybackFramePosition() {
        this.playbackFramePos = this.ac.getPlaybackFramePosition();
        this.posUpdate = true;
        this.posSlider.setValue((int)this.playbackFramePos);
        this.posUpdate = false;
        double seconds = (float)this.playbackFramePos / this.ac.getPlaybackAudioFormat().getFrameRate();
        this.framePosLabel.setText(this.timeFormatter.format((Object)new Double(seconds)));
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.status == 5) {
                double seconds = (float)this.ac.getRecordingFramePosition() / this.ac.getAudioFormat().getFrameRate();
                this.framePosLabel.setText(this.timeFormatter.format((Object)new Double(seconds)));
            } else if (this.status == 3) {
                this.playbackFrameLength = this.ac.getPlaybackFrameLength();
                this.setPlaybackFramePosition();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

