/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.ui.URLSelector;
import ipsk.swing.TitledPanel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;

public class URLSetChooser
extends TitledPanel
implements ActionListener {
    private static final long serialVersionUID = 427278935839293860L;
    URLSelector[] selectors;
    URL[] selectedURLs = null;
    Vector<ActionListener> listenerList = new Vector();

    public URLSetChooser(URL[] selectedFiles) {
        this();
        this.setSelectedURLs(selectedFiles);
    }

    public URLSetChooser() {
        super("URL set chooser");
        this.selectors = new URLSelector[0];
    }

    public void setSelectedURLs(URL[] files) {
        int i;
        this.selectedURLs = files;
        if (files.length != this.selectors.length) {
            for (i = 0; i < this.selectors.length; ++i) {
                this.selectors[i].removeActionListener(this);
                this.remove(this.selectors[i]);
            }
            this.setLayout(new GridLayout(1, files.length));
            this.selectors = new URLSelector[files.length];
            for (i = 0; i < files.length; ++i) {
                this.selectors[i] = new URLSelector();
                this.add(this.selectors[i]);
                this.selectors[i].addActionListener(this);
            }
        }
        for (i = 0; i < files.length; ++i) {
            this.selectors[i].setSelectedURL(files[i]);
        }
        this.revalidate();
        this.repaint();
    }

    public URL[] getSelectedURLs() {
        return this.selectedURLs;
    }

    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void updateListeners() {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(new ActionEvent(this, this.hashCode(), "URL set has changed"));
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectedURLs[i] = this.selectors[i].getSelectedURL();
        }
        this.updateListeners();
    }
}

