/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui.icons;

import ipsk.audio.ui.icons.ConfigurableIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class PlayIcon
implements ConfigurableIcon {
    private Type type = Type.NORM;
    private int edgeLength;
    private int border = 5;
    private boolean highLighted = false;
    private Polygon poly;

    public PlayIcon() {
        this(Type.NORM);
    }

    public PlayIcon(Type type) {
        this.type = type;
        this.edgeLength = Font.decode(null).getSize() * 2;
        this.poly = new Polygon(new int[]{this.border, this.edgeLength - this.border, this.border}, new int[]{this.border, this.edgeLength / 2, this.edgeLength - this.border}, 3);
    }

    public boolean isHighLighted() {
        return this.highLighted;
    }

    @Override
    public void setHighLighted(boolean highLighted) {
        this.highLighted = highLighted;
    }

    @Override
    public int getIconHeight() {
        return this.edgeLength;
    }

    @Override
    public int getIconWidth() {
        return this.edgeLength;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.highLighted) {
            g.setColor(Color.GREEN);
        } else if (this.type.equals((Object)Type.PRESSED)) {
            g.setColor(Color.GREEN.darker());
        } else {
            g.setColor(Color.BLACK);
        }
        if (this.type.equals((Object)Type.PRESSED)) {
            System.out.println("pressed");
        }
        g.fillRect(x, y, this.edgeLength, this.edgeLength);
        Polygon trPoly = new Polygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        trPoly.translate(x, y);
        if (this.type.equals((Object)Type.PRESSED)) {
            g.setColor(Color.BLACK);
            g.fillPolygon(trPoly);
        } else if (this.highLighted) {
            g.setColor(Color.BLACK);
            g.drawPolygon(trPoly);
        } else {
            g.setColor(Color.GREEN);
            g.fillPolygon(trPoly);
        }
    }

    public static enum Type {
        NORM,
        MOUSE_OVER,
        PRESSED;

    }
}

