/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FramedEditingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EditInputStream
extends FramedEditingInputStream {
    private long fromByte;
    private long toByte;
    private long pos;
    private byte[] pushBackBuf;
    private int pushBackLen;

    public EditInputStream(InputStream is, long off, long length) {
        this(is, 1, off, length);
    }

    public EditInputStream(InputStream is, int frameSize, long from, long length) {
        super(is, frameSize);
        this.fromByte = from * (long)frameSize;
        this.toByte = (from + length) * (long)frameSize;
        this.pos = 0L;
        this.pushBackBuf = new byte[frameSize];
        this.pushBackLen = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L || n % (long)this.frameSize > 0L) {
            throw new IOException("bytes to skip must be multiple of frame size");
        }
        long skipped = 0L;
        if (n == 0L) {
            return 0L;
        }
        skipped += (long)this.pushBackLen;
        n -= (long)this.pushBackLen;
        this.pos += (long)this.pushBackLen;
        this.pushBackLen = 0;
        if (this.pos < this.fromByte) {
            this.tryToSkipToFrom();
        }
        if (this.pos >= this.fromByte && this.pos < this.toByte) {
            long toSkip = this.toByte - this.pos;
            if (toSkip > n) {
                toSkip = n;
            }
            do {
                long s = this.is.skip(toSkip - skipped);
                this.pos += s;
                skipped += s;
            } while (this.pos % (long)this.frameSize > 0L);
        }
        if (this.pos % (long)this.frameSize > 0L) {
            System.err.println("EditInputStream: pos==" + this.pos);
        }
        return skipped;
    }

    private void tryToSkipToFrom() throws IOException {
        long toSkip = this.fromByte - this.pos;
        long skipped = 0L;
        do {
            long s = this.is.skip(toSkip - skipped);
            this.pos += s;
            skipped += s;
        } while (this.pos % (long)this.frameSize > 0L);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (len % this.frameSize > 0) {
            throw this.frameSizeException;
        }
        int copied = 0;
        while (this.pos < this.fromByte) {
            this.tryToSkipToFrom();
        }
        if (this.pos >= this.toByte) {
            return -1;
        }
        long toRead = this.toByte - this.pos;
        if ((long)len < toRead) {
            toRead = len;
        }
        if (this.pushBackLen > 0) {
            System.arraycopy(this.pushBackBuf, 0, buf, offset, this.pushBackLen);
            copied += this.pushBackLen;
            toRead -= (long)this.pushBackLen;
            offset += this.pushBackLen;
            this.pushBackLen = 0;
        }
        if ((long)offset + toRead > (long)buf.length) {
            System.err.println("buf " + buf.length + " offset: " + offset + " Read: " + toRead);
        }
        int read = this.is.read(buf, offset, (int)toRead);
        this.pushBackLen = (read + copied) % this.frameSize;
        if (this.pushBackLen > 0) {
            System.arraycopy(buf, offset, this.pushBackBuf, 0, this.pushBackLen);
        }
        this.pos += (long)(copied += read - this.pushBackLen);
        if (this.pos % (long)this.frameSize > 0L) {
            System.err.println("EditInputStream: pos==" + this.pos);
        }
        return copied;
    }

    @Override
    public int available() throws IOException {
        if (this.pos < this.fromByte) {
            this.tryToSkipToFrom();
        }
        if (this.pos < this.fromByte) {
            return 0;
        }
        return this.is.available();
    }
}

