/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.awt.ProgressListener;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressEvent;
import ipsk.net.http.ContentType;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.net.ssl.HttpsURLConnection;

public class URLContentLoader
extends ProgressWorker {
    public static final boolean DEBUG = false;
    public static final int DEBUG_TOTAL_MIN_MS = 10000;
    public final int DEFAULT_BUFFER_SIZE = 2048;
    protected URL url;
    private OutputStream outputStream;
    private URLConnection urlConn = null;
    private byte[] buf = new byte[2048];
    private ContentType contentType;
    private int contentLength;
    private boolean openConnectionInThread = true;
    private Integer connectTimeOut = null;
    private Integer readTimeout = null;

    public Integer getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(Integer connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTimeouts(Integer timeout) {
        this.setConnectTimeOut(timeout);
        this.setReadTimeout(timeout);
    }

    public boolean isOpenConnectionInThread() {
        return this.openConnectionInThread;
    }

    public void setOpenConnectionInThread(boolean openConnectionInThread) {
        this.openConnectionInThread = openConnectionInThread;
    }

    public URLContentLoader() {
        this(null, null);
    }

    public URLContentLoader(String threadName) {
        this(null, null, threadName);
    }

    public URLContentLoader(URL url, OutputStream outputStream) {
        this(url, outputStream, null);
    }

    public URLContentLoader(URL url, OutputStream outputStream, String threadName) {
        super(threadName);
        this.url = url;
        this.outputStream = outputStream;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public void open() throws WorkerException {
        if (!this.openConnectionInThread) {
            this.openConn();
        }
        super.open();
    }

    private void openConn() throws WorkerException {
        String responseMsg = null;
        try {
            this.progressStatus.setMessage(new LocalizableMessage("Connecting ..."));
            this.fireProgressEvent();
            this.urlConn = this.url.openConnection();
            if (this.connectTimeOut != null) {
                this.urlConn.setConnectTimeout(this.connectTimeOut);
            }
            if (this.readTimeout != null) {
                this.urlConn.setReadTimeout(this.readTimeout);
            }
            if (this.urlConn != null) {
                if (this.urlConn instanceof HttpURLConnection) {
                    int responseCode = ((HttpURLConnection)this.urlConn).getResponseCode();
                } else if (this.urlConn instanceof HttpsURLConnection) {
                    int n = ((HttpsURLConnection)this.urlConn).getResponseCode();
                }
                if (this.urlConn instanceof HttpURLConnection) {
                    responseMsg = ((HttpURLConnection)this.urlConn).getResponseMessage();
                } else if (this.urlConn instanceof HttpsURLConnection) {
                    responseMsg = ((HttpsURLConnection)this.urlConn).getResponseMessage();
                }
            }
            this.contentType = null;
            String contentTypeStr = this.urlConn.getContentType();
            if (contentTypeStr != null) {
                this.contentType = ContentType.parseHttpString(contentTypeStr);
            }
            this.contentLength = this.urlConn.getContentLength();
            this.progressStatus.setMessage(new LocalizableMessage("Connected."));
            this.fireProgressEvent();
        }
        catch (IOException e) {
            throw new WorkerException(responseMsg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doWork() throws WorkerException {
        if (this.openConnectionInThread) {
            this.openConn();
        }
        try {
            try {
                long transferred = 0L;
                InputStream is = this.urlConn.getInputStream();
                if (this.contentLength == -1) {
                    this.progressStatus.setLength(ProgressStatus.LENGTH_UNKNOWN);
                    this.progressStatus.setIndeterminate(true);
                } else {
                    this.progressStatus.setLength(this.contentLength);
                }
                this.fireProgressEvent();
                int read = 0;
                long startTime = System.currentTimeMillis();
                this.progressStatus.setMessage(new LocalizableMessage("Download ..."));
                while (!this.hasCancelRequest()) {
                    read = is.read(this.buf);
                    if (read == -1) {
                        return;
                    }
                    this.outputStream.write(this.buf, 0, read);
                    transferred += (long)read;
                    if (this.contentLength < 0) continue;
                    long perCentProgress = transferred * 100L / (long)this.contentLength;
                    this.progressStatus.setProgress(transferred);
                    this.fireProgressEvent();
                }
                return;
            }
            catch (IOException e) {
                throw new WorkerException(e);
            }
        }
        finally {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        URL url = null;
        try {
            url = new URL(args[0]);
            File testFile = new File(args[1]);
            FileOutputStream fos = new FileOutputStream(testFile);
            final URLContentLoader cl = new URLContentLoader(url, fos);
            cl.addProgressListener(new ProgressListener(){

                @Override
                public void update(ProgressEvent progressEvent) {
                    Charset cs;
                    String charsetName;
                    ContentType ct;
                    System.out.println(progressEvent.getProgressStatus().getPercentProgress() + " %");
                    ProgressStatus status = progressEvent.getProgressStatus();
                    if (status.isDone() && (ct = cl.getContentType()) != null && (charsetName = ct.getCharsetParameter()) != null && (cs = Charset.forName(charsetName)) != null) {
                        System.out.println(cs.displayName());
                    }
                }
            });
            cl.open();
            cl.start();
            cl.close();
            cl.reset();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public ContentType getContentType() {
        return this.contentType;
    }
}

