/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.symbols;

import ipsk.swing.symbols.CharButton;
import ipsk.swing.symbols.CharHash;
import ipsk.swing.symbols.unicode.CodePage;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CharPane
extends JPanel
implements ActionListener {
    private String name;
    private Font paneFont;
    private JTextArea textArea;
    private CharButton charButton;

    public CharPane(JTextArea ta, CharHash ch) {
        this.textArea = ta;
        this.paneFont = this.textArea.getFont();
        Enumeration e = ch.sortedKeys();
        while (e.hasMoreElements()) {
            String label = (String)e.nextElement();
            String tooltip = (String)ch.get(label);
            CharButton b = new CharButton(label, tooltip);
            b.setFont(this.paneFont);
            b.addActionListener(this);
            this.add(b);
        }
    }

    public CharPane(JTextArea ta, CodePage cp) {
        this.textArea = ta;
        this.name = cp.getName();
        this.paneFont = this.textArea.getFont();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 0.0;
        int j = 0;
        while (j < 16) {
            String hex = Integer.toHexString(j);
            JLabel label = new JLabel(hex.toUpperCase());
            label.setFont(this.paneFont);
            constraints.gridx = j + 1;
            constraints.gridy = 0;
            constraints.insets = new Insets(3, 18, 3, 10);
            gridbag.setConstraints(label, constraints);
            this.add(label);
            ++j;
        }
        int start = cp.getFirstCharacter();
        int end = cp.getLastCharacter();
        int column = 0;
        int row = 1;
        int i = start;
        while (i <= end) {
            if (column > 16 || i == start) {
                column = 0;
                ++row;
                StringBuffer tmp = new StringBuffer("");
                String hex = Integer.toHexString(i);
                if (hex.length() == 1) {
                    tmp.append("000");
                } else if (hex.length() == 2) {
                    tmp.append("00");
                } else if (hex.length() == 3) {
                    tmp.append("0");
                }
                tmp.append(hex);
                JLabel label = new JLabel(tmp.substring(0, tmp.length() - 1).toUpperCase());
                label.setFont(this.paneFont);
                constraints.gridx = column++;
                constraints.gridy = row;
                constraints.insets = new Insets(5, 5, 5, 5);
                gridbag.setConstraints(label, constraints);
                this.add(label);
            }
            char c = (char)i;
            CharButton button = new CharButton(String.valueOf(c), i, this);
            button.setFont(this.paneFont);
            button.addActionListener(this);
            constraints.gridx = column++;
            constraints.gridy = row;
            constraints.insets = new Insets(0, 0, 0, 0);
            gridbag.setConstraints(button, constraints);
            this.add(button);
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        this.textArea.insert(source.getText(), this.textArea.getCaretPosition());
    }

    public CharButton getCharButton() {
        return this.charButton;
    }

    public void setCharButton(CharButton charButton) {
        this.charButton = charButton;
    }
}

